/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.objective;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.client.screen.configuration.objective.ObjectiveConfigurationScreen;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataEntry;
import de.markusbordihn.easynpc.data.objective.ObjectiveType;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import java.util.UUID;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class FollowObjectiveConfigurationScreen<T extends ConfigurationMenu>
extends ObjectiveConfigurationScreen<T> {
    protected Checkbox followOwnerCheckbox;
    protected Checkbox followPlayerCheckbox;
    protected EditBox followPlayerName;
    protected Button followPlayerNameSaveButton;
    protected Checkbox followEntityCheckbox;
    protected EditBox followEntityUUID;
    protected Button followEntityUUIDSaveButton;

    public FollowObjectiveConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.followObjectiveButton.f_93623_ = false;
        int objectiveEntriesTop = this.contentTopPos + 5;
        int objectiveEntriesFirstColumn = this.contentLeftPos + 5;
        int objectiveEntriesSecondColumn = this.contentLeftPos + 145;
        OwnerData ownerData = this.getOwnerData();
        this.followOwnerCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(objectiveEntriesFirstColumn, objectiveEntriesTop, ObjectiveType.FOLLOW_OWNER.getObjectiveName(), ownerData.getOwnerName(), this.objectiveDataSet.hasObjective(ObjectiveType.FOLLOW_OWNER), checkbox -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.FOLLOW_OWNER, 6);
            objectiveDataEntry.setTargetOwnerUUID(ownerData.m_142504_());
            if (checkbox.selected()) {
                NetworkMessageHandlerManager.getServerHandler().addOrUpdateObjective(this.getEasyNPCUUID(), objectiveDataEntry);
            } else {
                NetworkMessageHandlerManager.getServerHandler().removeObjective(this.getEasyNPCUUID(), objectiveDataEntry);
            }
        }));
        this.followPlayerCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(objectiveEntriesFirstColumn, objectiveEntriesTop += 20, ObjectiveType.FOLLOW_PLAYER.getObjectiveName(), this.objectiveDataSet.hasObjective(ObjectiveType.FOLLOW_PLAYER), checkbox -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.FOLLOW_PLAYER, 7);
            if (this.followPlayerName != null) {
                objectiveDataEntry.setTargetPlayerName(this.followPlayerName.m_94155_());
                this.followPlayerName.m_94186_(checkbox.selected());
            }
            if (this.followPlayerNameSaveButton != null) {
                this.followPlayerNameSaveButton.f_93623_ = checkbox.selected();
            }
            if (!checkbox.selected()) {
                NetworkMessageHandlerManager.getServerHandler().removeObjective(this.getEasyNPCUUID(), objectiveDataEntry);
            } else if (!this.followPlayerName.m_94155_().isEmpty()) {
                NetworkMessageHandlerManager.getServerHandler().addOrUpdateObjective(this.getEasyNPCUUID(), objectiveDataEntry);
            }
        }));
        this.followOwnerCheckbox.f_93623_ = ownerData.hasOwner();
        this.followPlayerName = (EditBox)this.m_142416_((GuiEventListener)new TextField(this.f_96547_, objectiveEntriesSecondColumn, objectiveEntriesTop, 125));
        this.followPlayerName.m_94186_(this.objectiveDataSet.hasObjective(ObjectiveType.FOLLOW_PLAYER));
        this.followPlayerName.m_94151_(value -> {
            if (this.followPlayerNameSaveButton != null) {
                this.followPlayerNameSaveButton.f_93623_ = value != null && !value.isEmpty();
            }
        });
        this.followPlayerName.m_94144_(this.objectiveDataSet.hasObjective(ObjectiveType.FOLLOW_PLAYER) ? this.objectiveDataSet.getObjective(ObjectiveType.FOLLOW_PLAYER).getTargetPlayerName() : "");
        this.followPlayerNameSaveButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.followPlayerName.f_93620_ + this.followPlayerName.m_5711_() + 5, objectiveEntriesTop - 1, onPress -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.FOLLOW_PLAYER);
            objectiveDataEntry.setTargetPlayerName(this.followPlayerName.m_94155_());
            NetworkMessageHandlerManager.getServerHandler().addOrUpdateObjective(this.getEasyNPCUUID(), objectiveDataEntry);
        }));
        this.followEntityCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(objectiveEntriesFirstColumn, objectiveEntriesTop += 20, ObjectiveType.FOLLOW_ENTITY_BY_UUID.getObjectiveName(), this.objectiveDataSet.hasObjective(ObjectiveType.FOLLOW_ENTITY_BY_UUID), checkbox -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.FOLLOW_ENTITY_BY_UUID, 7);
            if (this.followEntityUUID != null) {
                if (!this.followEntityUUID.m_94155_().isEmpty()) {
                    UUID entityUUID = null;
                    try {
                        entityUUID = UUID.fromString(this.followEntityUUID.m_94155_());
                    }
                    catch (IllegalArgumentException e) {
                        log.error("Unable to parse UUID {} for {}", (Object)this.followEntityUUID.m_94155_(), (Object)this.getEasyNPCUUID());
                    }
                    if (entityUUID != null) {
                        objectiveDataEntry.setTargetEntityUUID(entityUUID);
                    }
                }
                this.followEntityUUID.m_94186_(checkbox.selected());
            }
            if (this.followEntityUUIDSaveButton != null) {
                this.followEntityUUIDSaveButton.f_93623_ = checkbox.selected();
            }
            if (!checkbox.selected()) {
                NetworkMessageHandlerManager.getServerHandler().removeObjective(this.getEasyNPCUUID(), objectiveDataEntry);
            } else if (!this.followEntityUUID.m_94155_().isEmpty()) {
                NetworkMessageHandlerManager.getServerHandler().addOrUpdateObjective(this.getEasyNPCUUID(), objectiveDataEntry);
            }
        }));
        this.followEntityUUID = (EditBox)this.m_142416_((GuiEventListener)new TextField(this.f_96547_, objectiveEntriesSecondColumn, objectiveEntriesTop, 125));
        this.followEntityUUID.m_94199_(36);
        this.followEntityUUID.m_94186_(this.objectiveDataSet.hasObjective(ObjectiveType.FOLLOW_ENTITY_BY_UUID));
        this.followEntityUUID.m_94151_(value -> {
            if (this.followEntityUUIDSaveButton != null) {
                this.followEntityUUIDSaveButton.f_93623_ = value != null && !value.isEmpty();
            }
        });
        this.followEntityUUID.m_94144_(this.objectiveDataSet.hasObjective(ObjectiveType.FOLLOW_ENTITY_BY_UUID) && this.objectiveDataSet.getObjective(ObjectiveType.FOLLOW_ENTITY_BY_UUID).getTargetEntityUUID() != null ? this.objectiveDataSet.getObjective(ObjectiveType.FOLLOW_ENTITY_BY_UUID).getTargetEntityUUID().toString() : "");
        this.followEntityUUIDSaveButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.followEntityUUID.f_93620_ + this.followEntityUUID.m_5711_() + 5, objectiveEntriesTop - 1, onPress -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.FOLLOW_ENTITY_BY_UUID, 7);
            objectiveDataEntry.setTargetEntityUUID(!this.followEntityUUID.m_94155_().isEmpty() ? UUID.fromString(this.followEntityUUID.m_94155_()) : null);
            NetworkMessageHandlerManager.getServerHandler().addOrUpdateObjective(this.getEasyNPCUUID(), objectiveDataEntry);
        }));
    }
}

