/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.model;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.renderer.manager.EntityTypeManager;
import de.markusbordihn.easynpc.client.screen.components.SearchField;
import de.markusbordihn.easynpc.client.screen.components.SkinSelectionButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.configuration.model.ModelConfigurationScreen;
import de.markusbordihn.easynpc.data.render.RenderDataSet;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.Level;

public class CustomModelConfigurationScreen<T extends ConfigurationMenu>
extends ModelConfigurationScreen<T> {
    private static final float SKIN_NAME_SCALING = 0.7f;
    private static final int MAX_SKINS_PER_PAGE = 5;
    private static final int SKIN_PREVIEW_WIDTH = 60;
    private Button skinNextButton = null;
    private Button skinNextPageButton = null;
    private Button skinPreviousButton = null;
    private Button skinPreviousPageButton = null;
    private int lastNumOfSkins = 0;
    private int numOfEntities = 0;
    private int skinStartIndex = 0;
    private List<Button> customModelButtons = new ArrayList<Button>();
    private String searchFilter = null;

    public CustomModelConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.customModelButton.f_93623_ = false;
        this.setDescriptionText("custom_model.text");
        this.defineSkinNavigationButtons(this.contentTopPos + 189, this.contentLeftPos, this.rightPos - 29);
        EditBox modelSearchField = (EditBox)this.m_142416_((GuiEventListener)new SearchField(this.f_96547_, this.contentLeftPos + 100, this.contentTopPos + 190, 100, 14));
        modelSearchField.m_94151_(this::onSearchFieldChanged);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        this.renderDescriptionText(poseStack, this.contentLeftPos + 5, this.contentTopPos + 20);
        if (!this.customModelButtons.isEmpty()) {
            for (Button skinButton : this.customModelButtons) {
                skinButton.m_6305_(poseStack, x, y, partialTicks);
            }
        }
        this.renderCustomModels(poseStack);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.customModelButtons.isEmpty()) {
            for (Button skinButton : this.customModelButtons) {
                skinButton.m_6375_(mouseX, mouseY, button);
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void defineSkinNavigationButtons(int skinButtonTop, int skinButtonLeft, int skinButtonRight) {
        this.skinPreviousPageButton = (Button)this.m_142416_((GuiEventListener)new TextButton(skinButtonLeft, skinButtonTop, 20, "<<", onPress -> {
            this.skinStartIndex = Math.max(this.skinStartIndex - 5, 0);
            this.checkSkinNavigationButtonState();
        }));
        this.skinPreviousButton = (Button)this.m_142416_((GuiEventListener)new TextButton(skinButtonLeft + 20, skinButtonTop, 20, "<", onPress -> {
            if (this.skinStartIndex > 0) {
                --this.skinStartIndex;
            }
            this.checkSkinNavigationButtonState();
        }));
        this.skinNextPageButton = (Button)this.m_142416_((GuiEventListener)new TextButton(skinButtonRight, skinButtonTop, 20, ">>", onPress -> {
            this.skinStartIndex = this.skinStartIndex >= 0 && this.skinStartIndex + 5 < this.numOfEntities ? (this.skinStartIndex += 5) : (this.numOfEntities > 5 ? this.numOfEntities - 5 : this.numOfEntities);
            this.checkSkinNavigationButtonState();
        }));
        this.skinNextButton = (Button)this.m_142416_((GuiEventListener)new TextButton(skinButtonRight - 20, skinButtonTop, 20, ">", onPress -> {
            if (this.skinStartIndex >= 0 && this.skinStartIndex < this.numOfEntities - 5) {
                ++this.skinStartIndex;
            }
            this.checkSkinNavigationButtonState();
        }));
        this.checkSkinNavigationButtonState();
    }

    private void checkSkinNavigationButtonState() {
        if (this.skinPreviousButton != null) {
            boolean bl = this.skinPreviousButton.f_93623_ = this.skinStartIndex > 0;
        }
        if (this.skinNextButton != null) {
            boolean bl = this.skinNextButton.f_93623_ = this.skinStartIndex + 5 < this.numOfEntities;
        }
        if (this.skinPreviousPageButton != null) {
            boolean bl = this.skinPreviousPageButton.f_93623_ = this.skinStartIndex - 5 > 0;
        }
        if (this.skinNextPageButton != null) {
            this.skinNextPageButton.f_93623_ = this.skinStartIndex + 1 + 5 < this.numOfEntities;
        }
    }

    @Override
    protected void renderBg(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(poseStack, partialTicks, mouseX, mouseY);
        this.renderSkinSelectionBackground(poseStack);
    }

    @Override
    protected void updateTick() {
        super.updateTick();
        EntityTypeManager.updateUnknownEntityType((Level)this.minecraftInstance.f_91073_);
    }

    private void renderCustomModels(PoseStack poseStack) {
        if (this.getEasyNPC() == null) {
            return;
        }
        int positionTop = 144;
        int skinPosition = 0;
        this.customModelButtons = new ArrayList<Button>();
        List<EntityType<? extends Entity>> entityKeys = EntityTypeManager.getUnknownAndSupportedEntityTypes();
        if (this.searchFilter != null && !this.searchFilter.isEmpty()) {
            entityKeys.removeIf(entityType -> !Registry.f_122826_.m_7981_(entityType).toString().toLowerCase(Locale.ROOT).contains(this.searchFilter.toLowerCase(Locale.ROOT)));
        }
        this.numOfEntities = entityKeys.size();
        if (this.lastNumOfSkins != this.numOfEntities) {
            this.checkSkinNavigationButtonState();
            this.lastNumOfSkins = this.numOfEntities;
        }
        for (int index = this.skinStartIndex; index < this.numOfEntities && index < this.skinStartIndex + 5; ++index) {
            int left = this.leftPos + 32 + skinPosition * 60;
            int top = this.topPos + 65 + positionTop;
            EntityType<? extends Entity> entityType2 = entityKeys.get(index);
            this.renderCustomModelEntity(left, top, entityType2);
            int topNamePos = Math.round(((float)top - 76.0f) / 0.7f);
            int leftNamePos = Math.round(((float)left - 21.0f) / 0.7f);
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 100.0);
            poseStack.m_85841_(0.7f, 0.7f, 0.7f);
            ResourceLocation entityTypeKey = Registry.f_122826_.m_7981_(entityType2);
            Text.drawString(poseStack, this.f_96547_, TextUtils.normalizeString(entityTypeKey.m_135827_(), 14), leftNamePos, topNamePos, 43520);
            Text.drawString(poseStack, this.f_96547_, TextUtils.normalizeString(entityTypeKey.m_135815_(), 14), leftNamePos, topNamePos + 10, 43520);
            poseStack.m_85849_();
            ++skinPosition;
        }
    }

    private void renderCustomModelEntity(int x, int y, EntityType<? extends Entity> entityType) {
        SkinSelectionButton customModelButton = new SkinSelectionButton(x - 24, y - 81, button -> NetworkMessageHandlerManager.getServerHandler().setRenderEntityType(this.getEasyNPCUUID(), entityType));
        RenderData<?> renderData = this.getEasyNPC().getEasyNPCRenderData();
        RenderDataSet renderDataSet = renderData.getRenderDataSet();
        EntityType<? extends Entity> currentEntityType = renderDataSet.getRenderEntityType();
        customModelButton.f_93623_ = currentEntityType == null || !currentEntityType.equals(entityType);
        float scaleFactor = EntityTypeManager.getScaleFactor(entityType);
        ScreenHelper.renderEntityCustomModel(x + 4, y, Math.round(30.0f / scaleFactor), (float)x - this.xMouse, (float)(y - 40) - this.yMouse, this.getEasyNPC(), entityType);
        this.customModelButtons.add(customModelButton);
    }

    private void renderSkinSelectionBackground(PoseStack poseStack) {
        CustomModelConfigurationScreen.m_93172_((PoseStack)poseStack, (int)this.contentLeftPos, (int)(this.contentTopPos + 104), (int)(this.contentLeftPos + 302), (int)(this.contentTopPos + 190), (int)-16777216);
        CustomModelConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.contentLeftPos + 1), (int)(this.contentTopPos + 105), (int)(this.contentLeftPos + 301), (int)(this.contentTopPos + 189), (int)-5592406);
    }

    private void onSearchFieldChanged(String searchText) {
        if (searchText != null && !searchText.isEmpty()) {
            this.searchFilter = searchText;
            this.skinStartIndex = 0;
            this.checkSkinNavigationButtonState();
        } else {
            this.searchFilter = "";
        }
    }
}

