/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.main;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.components.ColorButton;
import de.markusbordihn.easynpc.client.screen.components.CopyButton;
import de.markusbordihn.easynpc.client.screen.components.DeleteButton;
import de.markusbordihn.easynpc.client.screen.components.ReloadButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.client.screen.components.VisibilityToggleButton;
import de.markusbordihn.easynpc.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.render.RenderDataSet;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationData;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerData;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.DyeColor;

public class MainConfigurationScreen<T extends ConfigurationMenu>
extends ConfigurationScreen<T> {
    public static final int BUTTON_HEIGHT = 18;
    public static final int BUTTON_WIDTH = 97;
    private static final Map<String, ConfigurationType> menuButtons = new LinkedHashMap<String, ConfigurationType>();
    private Button copyUUIDButton;
    private String formerName = "";
    private int formerTextColor = 0xFFFFFF;
    private boolean formerNameVisibility = true;
    private EditBox nameBox;
    private ColorButton nameColorButton;
    private VisibilityToggleButton nameVisibilityButton;
    private Button saveNameButton;
    private int avatarTopPos;

    public MainConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.showCloseButton = true;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.contentTopPos = this.topPos + 15;
        this.avatarTopPos = this.contentTopPos + 1;
        this.homeButton.f_93624_ = false;
        this.defineNameAndColorBox();
        this.defineImportExportButtons();
        this.defineUUIDButton();
        this.defineRespawnButton();
        this.defineDeleteButton();
        this.defineEditSkinButton();
        this.defineChangeModelButton();
        this.defineMenuButtons();
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        BlockPos blockPos;
        NavigationData<?> navigationData;
        super.m_6305_(poseStack, x, y, partialTicks);
        if (this.getEasyNPC() == null) {
            return;
        }
        ScreenHelper.renderScaledEntityAvatar(this.leftPos + 60, this.avatarTopPos + 140, (float)(this.leftPos + 50) - this.xMouse, (float)(this.contentTopPos + 70) - this.yMouse, this.getEasyNPC());
        float scaleEntityTypeText = 0.75f;
        poseStack.m_85836_();
        poseStack.m_85841_(scaleEntityTypeText, scaleEntityTypeText, scaleEntityTypeText);
        Text.drawString(poseStack, this.f_96547_, "UUID: " + this.getEasyNPCEntity().m_142081_(), Math.round((float)(this.contentLeftPos + 1) / scaleEntityTypeText), Math.round((float)(this.buttonTopPos + 1) / scaleEntityTypeText));
        Text.drawString(poseStack, this.f_96547_, this.getEasyNPCEntity().m_6095_().m_20676_(), Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), Math.round((float)(this.avatarTopPos + 4) / scaleEntityTypeText));
        poseStack.m_85837_(0.0, 0.0, 100.0);
        OwnerData<?> ownerData = this.getEasyNPC().getEasyNPCOwnerData();
        if (ownerData != null) {
            Text.drawString(poseStack, this.f_96547_, "Owner: " + (ownerData.hasOwner() ? ownerData.getOwnerName() : "-"), Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), Math.round((float)(this.avatarTopPos + 15) / scaleEntityTypeText));
        }
        if ((navigationData = this.getEasyNPC().getEasyNPCNavigationData()) != null && navigationData.hasHomePosition()) {
            blockPos = navigationData.getHomePosition();
            Text.drawString(poseStack, this.f_96547_, "Home: " + blockPos.m_123341_() + ", " + blockPos.m_123342_() + ", " + blockPos.m_123343_(), Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), Math.round((float)(this.avatarTopPos + 23) / scaleEntityTypeText));
        }
        Text.drawString(poseStack, this.f_96547_, "Team: " + (this.getEasyNPCEntity().m_5647_() != null ? this.getEasyNPCEntity().m_5647_().m_5758_() : "-"), Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), Math.round((float)(this.avatarTopPos + 31) / scaleEntityTypeText));
        Text.drawString(poseStack, this.f_96547_, "HP: " + this.getEasyNPCLivingEntity().m_21223_() + "/" + this.getEasyNPCLivingEntity().m_21233_(), Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), Math.round((float)(this.avatarTopPos + 39) / scaleEntityTypeText));
        blockPos = this.getEasyNPCEntity().m_20097_();
        Text.drawString(poseStack, this.f_96547_, "Pos: " + blockPos.m_123341_() + ", " + blockPos.m_123342_() + ", " + blockPos.m_123343_(), Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), Math.round((float)(this.avatarTopPos + 147) / scaleEntityTypeText));
        poseStack.m_85849_();
    }

    @Override
    protected void renderBg(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(poseStack, partialTicks, mouseX, mouseY);
        MainConfigurationScreen.m_93172_((PoseStack)poseStack, (int)this.contentLeftPos, (int)this.avatarTopPos, (int)(this.leftPos + 117), (int)(this.avatarTopPos + 135), (int)-16777216);
        MainConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.leftPos + 8), (int)(this.avatarTopPos + 1), (int)(this.leftPos + 116), (int)(this.avatarTopPos + 134), (int)-1);
        MainConfigurationScreen.m_93172_((PoseStack)poseStack, (int)this.contentLeftPos, (int)(this.avatarTopPos + 12), (int)(this.leftPos + 117), (int)(this.avatarTopPos + 155), (int)-16777216);
        MainConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.leftPos + 8), (int)(this.avatarTopPos + 13), (int)(this.leftPos + 116), (int)(this.avatarTopPos + 155), (int)-5592406);
    }

    private void defineImportExportButtons() {
        Button importButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.leftPos + 122, this.contentTopPos + 35, 97, "import", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DEFAULT_PRESET_IMPORT)));
        importButton.f_93623_ = true;
        Button exportButton = (Button)this.m_142416_((GuiEventListener)new TextButton(importButton.f_93620_ + importButton.m_5711_() + 5, importButton.f_93621_, 97, "export", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.CUSTOM_PRESET_EXPORT)));
        exportButton.f_93623_ = true;
    }

    private void defineNameAndColorBox() {
        String string;
        Component nameComponent = this.getEasyNPCEntity().m_7755_();
        if (nameComponent instanceof TranslatableComponent) {
            TranslatableComponent translatableComponent = (TranslatableComponent)nameComponent;
            string = translatableComponent.m_131328_();
        } else {
            string = nameComponent.getString();
        }
        this.formerName = string;
        this.nameBox = new TextField(this.f_96547_, this.contentLeftPos + 115, this.contentTopPos + 2, 138);
        this.nameBox.m_94199_(32);
        this.nameBox.m_94144_(this.formerName);
        this.nameBox.m_94151_(consumer -> this.validateName());
        this.m_142416_((GuiEventListener)this.nameBox);
        this.nameColorButton = (ColorButton)this.m_142416_((GuiEventListener)new ColorButton(this.nameBox.f_93620_ + this.nameBox.m_5711_() + 1, this.nameBox.f_93621_ - 1, onPress -> this.validateName()));
        if (this.getEasyNPCEntity().m_8077_() && this.getEasyNPCEntity().m_7770_().m_7383_() != null && this.getEasyNPCEntity().m_7770_().m_7383_().m_131135_() != null) {
            int styleTextColor = this.getEasyNPCEntity().m_7770_().m_7383_().m_131135_().m_131265_();
            for (DyeColor dyeColor : DyeColor.values()) {
                if (dyeColor.m_41071_() != styleTextColor) continue;
                this.nameColorButton.setColor(dyeColor);
                this.formerTextColor = styleTextColor;
                break;
            }
        }
        this.nameVisibilityButton = (VisibilityToggleButton)this.m_142416_((GuiEventListener)new VisibilityToggleButton(this.nameColorButton.f_93620_ + this.nameColorButton.m_5711_() + 2, this.nameColorButton.f_93621_, onPress -> this.validateName()));
        this.nameVisibilityButton.f_93623_ = this.getEasyNPCEntity().m_8077_() && this.getEasyNPCEntity().m_20151_();
        this.formerNameVisibility = this.getEasyNPCEntity().m_20151_();
        this.saveNameButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.nameVisibilityButton.f_93620_ + this.nameVisibilityButton.m_5711_() + 2, this.nameVisibilityButton.f_93621_, onPress -> this.saveName()));
        this.saveNameButton.f_93623_ = false;
    }

    private void defineUUIDButton() {
        this.copyUUIDButton = (Button)this.m_142416_((GuiEventListener)new CopyButton(this.contentLeftPos, this.bottomPos - 27, 90, "copy_uuid", onPress -> {
            Minecraft minecraft = Minecraft.m_91087_();
            minecraft.f_91068_.m_90911_(this.getEasyNPCUUID().toString());
        }));
    }

    private void defineRespawnButton() {
        this.m_142416_((GuiEventListener)new ReloadButton(this.copyUUIDButton.f_93620_ + this.copyUUIDButton.m_5711_() + 4, this.bottomPos - 27, 80, 16, "respawn", onPress -> this.respawnNPC()));
    }

    private void defineDeleteButton() {
        this.m_142416_((GuiEventListener)new DeleteButton(this.rightPos - 70, this.bottomPos - 29, 65, onPress -> this.deleteNPC()));
    }

    protected void defineEditSkinButton() {
        SkinData<?> skinData = this.getEasyNPC().getEasyNPCSkinData();
        if (skinData == null) {
            return;
        }
        Button editSkinButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.contentLeftPos, this.avatarTopPos + 155, 110, 14, "edit_skin", onPress -> {
            SkinType skinType = skinData.getSkinType();
            switch (skinType) {
                case NONE: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.NONE_SKIN);
                    break;
                }
                case PLAYER_SKIN: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.PLAYER_SKIN);
                    break;
                }
                case SECURE_REMOTE_URL: 
                case INSECURE_REMOTE_URL: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.URL_SKIN);
                    break;
                }
                case CUSTOM: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.CUSTOM_SKIN);
                    break;
                }
                default: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DEFAULT_SKIN);
                }
            }
        }));
        editSkinButton.f_93623_ = this.getConfigurationData().supportsConfigurationType(ConfigurationType.SKIN);
    }

    protected void defineChangeModelButton() {
        RenderDataSet renderDataSet = this.getRenderDataSet();
        if (renderDataSet == null) {
            return;
        }
        Button changeModelButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.contentLeftPos, this.avatarTopPos + 168, 110, 14, "change_model", onPress -> {
            switch (renderDataSet.getRenderType()) {
                case CUSTOM_ENTITY: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.CUSTOM_MODEL);
                    break;
                }
                default: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DEFAULT_MODEL);
                }
            }
        }));
        changeModelButton.f_93623_ = this.getConfigurationData().supportsChangeModelConfiguration();
    }

    protected void defineMenuButtons() {
        int buttonTopPos = this.topPos + 75;
        int buttonLeftPos = this.contentLeftPos + 115;
        int buttonIndex = 0;
        for (Map.Entry<String, ConfigurationType> entry : menuButtons.entrySet()) {
            String buttonName = entry.getKey();
            ConfigurationType configurationType = entry.getValue();
            Button button = (Button)this.m_142416_((GuiEventListener)new TextButton(buttonLeftPos + buttonIndex % 2 * 102, buttonTopPos + buttonIndex / 2 * 20, 97, buttonName, onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), configurationType)));
            button.f_93623_ = this.getConfigurationData().supportsConfigurationType(configurationType);
            ++buttonIndex;
        }
    }

    private void respawnNPC() {
        Minecraft minecraft = this.f_96541_;
        if (minecraft == null) {
            return;
        }
        minecraft.m_91152_((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed) {
                NetworkMessageHandlerManager.getServerHandler().respawnNPC(this.getEasyNPCUUID());
                minecraft.m_91152_(null);
            } else {
                minecraft.m_91152_((Screen)this);
            }
        }, (Component)TextComponent.getTranslatedText("respawnNPC.confirmQuestion"), (Component)TextComponent.getTranslatedText("respawnNPC.confirmWarning", this.getEasyNPCEntity().m_5446_()), (Component)TextComponent.getTranslatedText("respawnNPC.respawnButton"), CommonComponents.f_130656_));
    }

    private void deleteNPC() {
        Minecraft minecraft = this.f_96541_;
        if (minecraft == null) {
            return;
        }
        minecraft.m_91152_((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed) {
                NetworkMessageHandlerManager.getServerHandler().removeNPC(this.getEasyNPCUUID());
                minecraft.m_91152_(null);
            } else {
                minecraft.m_91152_((Screen)this);
            }
        }, (Component)TextComponent.getTranslatedText("removeNPC.deleteQuestion"), (Component)TextComponent.getTranslatedText("removeNPC.deleteWarning", this.getEasyNPCEntity().m_5446_()), (Component)TextComponent.getTranslatedText("removeNPC.deleteButton"), CommonComponents.f_130656_));
    }

    private void validateName() {
        String nameValue = this.nameBox.m_94155_();
        int textColorValue = this.nameColorButton.getColorValue();
        boolean nameVisibility = this.nameVisibilityButton.f_93623_;
        this.saveNameButton.f_93623_ = !this.formerName.equals(nameValue) || this.formerTextColor != textColorValue || this.formerNameVisibility != nameVisibility;
    }

    private void saveName() {
        String name = this.nameBox.m_94155_();
        int textColor = 0xFFFFFF;
        if (this.nameColorButton != null) {
            textColor = this.nameColorButton.getColorValue();
        }
        boolean nameVisibility = true;
        if (this.nameVisibilityButton != null) {
            nameVisibility = this.nameVisibilityButton.f_93623_;
        }
        log.debug("Saving name {} with color {} and visibility {} for {}", (Object)name, (Object)textColor, (Object)nameVisibility, this.getEasyNPC());
        NetworkMessageHandlerManager.getServerHandler().changeName(this.getEasyNPC().m_142081_(), name, textColor, nameVisibility);
        this.formerName = name;
        this.formerTextColor = textColor;
        this.formerNameVisibility = nameVisibility;
        this.saveNameButton.f_93623_ = false;
    }

    static {
        menuButtons.put("actions", ConfigurationType.BASIC_ACTION);
        menuButtons.put("attributes", ConfigurationType.ABILITIES_ATTRIBUTE);
        menuButtons.put("dialog", ConfigurationType.DIALOG);
        menuButtons.put("equipment", ConfigurationType.EQUIPMENT);
        menuButtons.put("objective", ConfigurationType.BASIC_OBJECTIVE);
        menuButtons.put("pose", ConfigurationType.POSE);
        menuButtons.put("position", ConfigurationType.DEFAULT_POSITION);
        menuButtons.put("rotation", ConfigurationType.DEFAULT_ROTATION);
        menuButtons.put("scaling", ConfigurationType.SCALING);
        menuButtons.put("trading", ConfigurationType.TRADING);
    }
}

