/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.dialog;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.components.CancelButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.client.screen.configuration.dialog.DialogConfigurationScreen;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.dialog.DialogType;
import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class YesNoDialogConfigurationScreen<T extends ConfigurationMenu>
extends DialogConfigurationScreen<T> {
    private static final String YES_BUTTON_LABEL = "yes_button";
    private static final String NO_BUTTON_LABEL = "no_button";
    protected EditBox mainDialogBox;
    protected Button yesDialogButton;
    protected Button noDialogButton;
    protected EditBox yesDialogBox;
    protected EditBox noDialogBox;
    protected Button saveButton = null;
    protected Button cancelButton = null;
    boolean showSaveNotificationForButtons = false;
    private String noDialogValue = "";
    private String questionDialogValue = "";
    private String yesDialogValue = "";

    public YesNoDialogConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.yesNoDialogButton.f_93623_ = false;
        DialogDataEntry questionDialogData = this.getDialogDataSet().getDialog("question");
        DialogDataEntry yesDialogData = this.getDialogDataSet().getDialog("yes_answer");
        DialogDataEntry noDialogData = this.getDialogDataSet().getDialog("no_answer");
        DialogButtonEntry yesButtonData = questionDialogData == null ? null : questionDialogData.getDialogButton(YES_BUTTON_LABEL);
        DialogButtonEntry noButtonData = questionDialogData == null ? null : questionDialogData.getDialogButton(NO_BUTTON_LABEL);
        String string = this.questionDialogValue = questionDialogData == null ? "" : questionDialogData.getText();
        if (this.questionDialogValue.isEmpty() && this.getDialogDataSet().getDefaultDialog() != null && this.getDialogDataSet().getType() == DialogType.BASIC) {
            this.questionDialogValue = this.getDialogDataSet().getDefaultDialog().getText();
        }
        if (questionDialogData == null) {
            this.showSaveNotificationForButtons = true;
        }
        this.mainDialogBox = new TextField(this.f_96547_, this.contentLeftPos, this.topPos + 50, 300);
        this.mainDialogBox.m_94199_(512);
        this.mainDialogBox.m_94144_(this.questionDialogValue);
        this.m_142416_((GuiEventListener)this.mainDialogBox);
        this.yesDialogButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.contentLeftPos, this.topPos + 85, 145, (Component)(yesButtonData == null ? TextComponent.getText("Yes Button") : yesButtonData.getButtonName(20)), onPress -> {
            UUID yesButtonId;
            UUID uUID = yesButtonId = yesButtonData == null ? null : yesButtonData.id();
            if (questionDialogData != null) {
                if (yesButtonId != null) {
                    NetworkMessageHandlerManager.getServerHandler().openDialogButtonEditor(this.getEasyNPCUUID(), questionDialogData.getId(), yesButtonId);
                } else {
                    NetworkMessageHandlerManager.getServerHandler().openDialogButtonEditor(this.getEasyNPCUUID(), questionDialogData.getId());
                }
            }
        }));
        this.noDialogButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.contentLeftPos + 155, this.topPos + 85, 145, (Component)(noButtonData == null ? TextComponent.getText("No Button") : noButtonData.getButtonName(20)), onPress -> {
            UUID noButtonId;
            UUID uUID = noButtonId = noButtonData == null ? null : noButtonData.id();
            if (questionDialogData != null) {
                if (noButtonId != null) {
                    NetworkMessageHandlerManager.getServerHandler().openDialogButtonEditor(this.getEasyNPCUUID(), questionDialogData.getId(), noButtonId);
                } else {
                    NetworkMessageHandlerManager.getServerHandler().openDialogButtonEditor(this.getEasyNPCUUID(), questionDialogData.getId());
                }
            }
        }));
        this.yesDialogValue = yesDialogData == null ? "" : yesDialogData.getText();
        this.yesDialogBox = new TextField(this.f_96547_, this.contentLeftPos, this.topPos + 130, 300);
        this.yesDialogBox.m_94199_(255);
        this.yesDialogBox.m_94144_(this.yesDialogValue);
        this.m_142416_((GuiEventListener)this.yesDialogBox);
        this.noDialogValue = noDialogData == null ? "" : noDialogData.getText();
        this.noDialogBox = new TextField(this.f_96547_, this.contentLeftPos, this.topPos + 170, 300);
        this.noDialogBox.m_94199_(255);
        this.noDialogBox.m_94144_(this.noDialogValue);
        this.m_142416_((GuiEventListener)this.noDialogBox);
        this.saveButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.contentLeftPos + 26, this.bottomPos - 40, "save", onPress -> {
            DialogDataSet dialogDataSet = DialogUtils.getYesNoDialog(this.mainDialogBox.m_94155_(), "Yes", "No", this.yesDialogBox.m_94155_(), this.noDialogBox.m_94155_());
            if (questionDialogData != null) {
                Set<DialogButtonEntry> dialogButtonEntrySet = questionDialogData.getDialogButtons();
                if (!questionDialogData.hasDialogButton(YES_BUTTON_LABEL)) {
                    dialogButtonEntrySet.add(dialogDataSet.getDialog("question").getDialogButton(YES_BUTTON_LABEL));
                }
                if (!questionDialogData.hasDialogButton(NO_BUTTON_LABEL)) {
                    dialogButtonEntrySet.add(dialogDataSet.getDialog("question").getDialogButton(NO_BUTTON_LABEL));
                }
                dialogDataSet.getDialog("question").setDialogButtons(dialogButtonEntrySet);
            }
            this.questionDialogValue = this.mainDialogBox.m_94155_();
            this.yesDialogValue = this.yesDialogBox.m_94155_();
            this.noDialogValue = this.noDialogBox.m_94155_();
            NetworkMessageHandlerManager.getServerHandler().saveDialogSet(this.getEasyNPCUUID(), dialogDataSet);
            NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.YES_NO_DIALOG);
        }));
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)new CancelButton(this.rightPos - 130, this.bottomPos - 40, "cancel", onPress -> this.showMainScreen()));
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        Text.drawConfigString(poseStack, this.f_96547_, "question", this.contentLeftPos, this.topPos + 40);
        Text.drawConfigString(poseStack, this.f_96547_, "edit_yes_button", this.contentLeftPos, this.topPos + 75);
        Text.drawConfigString(poseStack, this.f_96547_, "edit_no_button", this.contentLeftPos + 155, this.topPos + 75);
        if (this.yesDialogBox != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "yes_answer", this.contentLeftPos, this.yesDialogBox.f_93621_ - 12);
        }
        if (this.noDialogBox != null) {
            Text.drawConfigString(poseStack, this.f_96547_, "no_answer", this.contentLeftPos, this.noDialogBox.f_93621_ - 12);
        }
        if (this.showSaveNotificationForButtons) {
            Text.drawConfigString(poseStack, this.f_96547_, "save_before_edit_buttons", this.contentLeftPos + 65, this.topPos + 105, 0xFF5555);
        }
    }

    @Override
    public void updateTick() {
        super.updateTick();
        if (this.saveButton != null) {
            boolean bl = this.saveButton.f_93623_ = !this.mainDialogBox.m_94155_().equals(this.questionDialogValue) || !this.yesDialogBox.m_94155_().equals(this.yesDialogValue) || !this.noDialogBox.m_94155_().equals(this.noDialogValue);
        }
        if (this.yesDialogButton != null && this.getDialogDataSet() != null) {
            boolean bl = this.yesDialogButton.f_93623_ = this.getDialogDataSet().hasDialog("question") && this.getDialogDataSet().getDialog("question").hasDialogButton(YES_BUTTON_LABEL);
        }
        if (this.noDialogButton != null && this.getDialogDataSet() != null) {
            this.noDialogButton.f_93623_ = this.getDialogDataSet().hasDialog("question") && this.getDialogDataSet().getDialog("question").hasDialogButton(NO_BUTTON_LABEL);
        }
    }
}

