/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.dialog;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.screen.components.AddButton;
import de.markusbordihn.easynpc.client.screen.components.CopyButton;
import de.markusbordihn.easynpc.client.screen.components.EditButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextEditButton;
import de.markusbordihn.easynpc.client.screen.configuration.dialog.AdvancedDialogConfigurationScreen;
import de.markusbordihn.easynpc.client.screen.configuration.dialog.DialogConfigurationScreen;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class AdvancedDialogConfigurationScreen<T extends ConfigurationMenu>
extends DialogConfigurationScreen<T> {
    Button newDialogButton;
    DialogList dialogList;

    public AdvancedDialogConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.advancedDialogButton.f_93623_ = false;
        this.newDialogButton = (Button)this.m_142416_((GuiEventListener)new AddButton(this.contentLeftPos + 2, this.contentTopPos + 193, 300, "dialog.add", onPress -> NetworkMessageHandlerManager.getServerHandler().openDialogEditor(this.getEasyNPCUUID())));
        this.dialogList = new DialogList();
        this.m_7787_((GuiEventListener)this.dialogList);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        super.m_6305_(poseStack, x, y, partialTicks);
        AdvancedDialogConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.leftPos + 5), (int)(this.contentTopPos + 20), (int)(this.leftPos + 324), (int)(this.contentTopPos + 210), (int)-1118482);
        AdvancedDialogConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.leftPos + 109), (int)(this.contentTopPos + 20), (int)(this.leftPos + 110), (int)(this.contentTopPos + 190), (int)-4473925);
        AdvancedDialogConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.leftPos + 208), (int)(this.contentTopPos + 20), (int)(this.leftPos + 209), (int)(this.contentTopPos + 190), (int)-4473925);
        if (this.dialogList != null) {
            this.dialogList.m_6305_(poseStack, x, y, partialTicks);
        }
        AdvancedDialogConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.leftPos + 5), (int)this.contentTopPos, (int)(this.leftPos + 324), (int)(this.contentTopPos + 18), (int)-5592406);
        AdvancedDialogConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.leftPos + 5), (int)(this.contentTopPos + 191), (int)(this.leftPos + 324), (int)(this.contentTopPos + 211), (int)-3750202);
        int headerLeft = this.leftPos + 10;
        Text.drawConfigString(poseStack, this.f_96547_, "label_id", headerLeft, this.contentTopPos + 5, 0);
        Text.drawString(poseStack, this.f_96547_, "Name", headerLeft + 103, this.contentTopPos + 5, 0);
        Text.drawString(poseStack, this.f_96547_, "Text", headerLeft + 201, this.contentTopPos + 5, 0);
        AdvancedDialogConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.leftPos + 109), (int)this.contentTopPos, (int)(this.leftPos + 110), (int)(this.contentTopPos + 18), (int)-10066330);
        AdvancedDialogConfigurationScreen.m_93172_((PoseStack)poseStack, (int)(this.leftPos + 208), (int)this.contentTopPos, (int)(this.leftPos + 209), (int)(this.contentTopPos + 18), (int)-10066330);
        if (this.newDialogButton != null) {
            this.newDialogButton.m_6305_(poseStack, x, y, partialTicks);
        }
    }

    class DialogList
    extends ObjectSelectionList<de.markusbordihn.easynpc.client.screen.configuration.dialog.AdvancedDialogConfigurationScreen$DialogList.Entry> {
        DialogList() {
            super(AdvancedDialogConfigurationScreen.this.f_96541_, AdvancedDialogConfigurationScreen.this.f_96543_ + 50, AdvancedDialogConfigurationScreen.this.f_96544_ - 60, AdvancedDialogConfigurationScreen.this.contentTopPos + 15, AdvancedDialogConfigurationScreen.this.contentTopPos + 195, 19);
            this.m_93473_(false, 0);
            this.m_93488_(false);
            this.m_93496_(false);
            for (DialogDataEntry dialogData : AdvancedDialogConfigurationScreen.this.getDialogDataSet().getDialogsByLabel()) {
                if (dialogData == null || dialogData.getId() == null) continue;
                this.m_7085_((AbstractSelectionList.Entry)new Entry(dialogData));
            }
        }

        public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
            if (this.m_5773_() > 0) {
                super.m_6305_(poseStack, x, y, partialTicks);
            }
        }

        class Entry
        extends ObjectSelectionList.Entry<de.markusbordihn.easynpc.client.screen.configuration.dialog.AdvancedDialogConfigurationScreen$DialogList.Entry> {
            final DialogDataEntry dialogData;
            final EditButton editButton;
            final CopyButton copyLabelButton;
            final TextEditButton textEditButton;
            final String defaultDialogLabel;

            public Entry(DialogDataEntry dialogData) {
                this.dialogData = dialogData;
                this.editButton = new EditButton(0, 0, onPress -> NetworkMessageHandlerManager.getServerHandler().openDialogEditor(AdvancedDialogConfigurationScreen.this.getEasyNPCUUID(), this.dialogData.getId()));
                this.copyLabelButton = new CopyButton(0, 0, onPress -> {
                    Minecraft minecraft = Minecraft.m_91087_();
                    minecraft.f_91068_.m_90911_(dialogData.getLabel());
                });
                this.textEditButton = new TextEditButton(0, 0, onPress -> NetworkMessageHandlerManager.getServerHandler().openDialogTextEditor(AdvancedDialogConfigurationScreen.this.getEasyNPCUUID(), this.dialogData.getId()));
                this.defaultDialogLabel = AdvancedDialogConfigurationScreen.this.getDialogDataSet().getDefaultDialogLabel();
            }

            public Component m_142172_() {
                return TextComponent.getTextComponent(this.dialogData.getName());
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                super.m_6375_(mouseX, mouseY, button);
                this.copyLabelButton.m_6375_(mouseX, mouseY, button);
                this.editButton.m_6375_(mouseX, mouseY, button);
                this.textEditButton.m_6375_(mouseX, mouseY, button);
                return button == 0;
            }

            public void m_6311_(PoseStack poseStack, int entryId, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
                int leftPos = left - 75;
                this.editButton.f_93620_ = leftPos + 71;
                this.editButton.f_93621_ = top;
                this.editButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
                if (this.editButton.isHovered()) {
                    AdvancedDialogConfigurationScreen.this.m_96602_(poseStack, (Component)TextComponent.getTranslatedConfigText("dialog.edit_dialog", this.dialogData.getName()), mouseX, mouseY);
                }
                this.copyLabelButton.f_93620_ = this.editButton.f_93620_ + this.editButton.m_5711_();
                this.copyLabelButton.f_93621_ = top;
                this.copyLabelButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
                if (this.copyLabelButton.isHovered()) {
                    AdvancedDialogConfigurationScreen.this.m_96602_(poseStack, (Component)TextComponent.getTranslatedConfigText("dialog.copy_dialog_label", this.dialogData.getLabel()), mouseX, mouseY);
                }
                this.textEditButton.f_93620_ = leftPos + 203;
                this.textEditButton.f_93621_ = top;
                this.textEditButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
                if (this.textEditButton.isHovered()) {
                    AdvancedDialogConfigurationScreen.this.m_96602_(poseStack, (Component)TextComponent.getTranslatedConfigText("dialog.edit_dialog_text", this.dialogData.getText()), mouseX, mouseY);
                }
                float dialogDataScale = 0.75f;
                int dialogDataTopPos = Math.round((float)(top + 5) / dialogDataScale);
                int fontColor = this.dialogData.getLabel().equals(this.defaultDialogLabel) ? 43520 : 0;
                poseStack.m_85836_();
                poseStack.m_85841_(dialogDataScale, dialogDataScale, dialogDataScale);
                Text.drawString(poseStack, AdvancedDialogConfigurationScreen.this.f_96547_, this.dialogData.getLabel(16), Math.round((float)(leftPos + 4) / dialogDataScale), dialogDataTopPos, fontColor);
                Text.drawString(poseStack, AdvancedDialogConfigurationScreen.this.f_96547_, this.dialogData.getName(21), Math.round((float)(leftPos + 109) / dialogDataScale), dialogDataTopPos, fontColor);
                Text.drawString(poseStack, AdvancedDialogConfigurationScreen.this.f_96547_, this.dialogData.getText(21), Math.round((float)(leftPos + 221) / dialogDataScale), dialogDataTopPos, fontColor);
                poseStack.m_85849_();
                GuiComponent.m_93172_((PoseStack)poseStack, (int)(AdvancedDialogConfigurationScreen.this.leftPos + 5), (int)(top + 17), (int)(AdvancedDialogConfigurationScreen.this.leftPos + 324), (int)(top + 18), (int)-5592406);
            }
        }
    }
}

