/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.config;

import com.sonicether.soundphysics.SoundPhysics;
import com.sonicether.soundphysics.SoundPhysicsMod;
import com.sonicether.soundphysics.config.SoundTypes;
import com.sonicether.soundphysics.configbuilder.PropertyConfig;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.block.SoundType;

public class ReflectivityConfig
extends PropertyConfig {
    private Map<SoundType, Double> reflectivity;

    public ReflectivityConfig(Path path) {
        super(path);
        this.save();
    }

    @Override
    public void load() throws IOException {
        super.load();
        this.reflectivity = this.createDefaultMap();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            double value;
            String key = (String)entry.getKey();
            try {
                value = Double.parseDouble((String)entry.getValue());
            }
            catch (NumberFormatException e) {
                SoundPhysics.LOGGER.warn("Failed to parse reflectivity of {}", (Object)key);
                continue;
            }
            SoundType soundType = SoundTypes.getSoundType(key);
            if (soundType == null) {
                SoundPhysics.LOGGER.warn("Sound type {} not found", (Object)key);
                continue;
            }
            this.reflectivity.put(soundType, value);
        }
    }

    @Override
    public void saveSync() {
        this.properties.clear();
        for (Map.Entry<SoundType, Double> entry : this.reflectivity.entrySet()) {
            this.properties.put(SoundTypes.getName(entry.getKey()), String.valueOf(entry.getValue()));
        }
        super.saveSync();
    }

    public Map<SoundType, Double> getReflectivities() {
        return this.reflectivity;
    }

    public double getReflectivity(SoundType soundType) {
        return this.reflectivity.getOrDefault(soundType, SoundPhysicsMod.CONFIG.defaultBlockReflectivity.get());
    }

    public ReflectivityConfig setReflectivity(SoundType soundType, double value) {
        this.reflectivity.put(soundType, value);
        return this;
    }

    public Map<SoundType, Double> createDefaultMap() {
        HashMap<SoundType, Double> map = new HashMap<SoundType, Double>();
        for (SoundType type : SoundTypes.getTranslationMap().keySet()) {
            map.put(type, SoundPhysicsMod.CONFIG.defaultBlockReflectivity.get());
        }
        map.put(SoundType.f_56742_, 1.5);
        map.put(SoundType.f_56725_, 1.5);
        map.put(SoundType.f_154659_, 1.5);
        map.put(SoundType.f_154654_, 1.5);
        map.put(SoundType.f_56718_, 1.5);
        map.put(SoundType.f_154660_, 1.5);
        map.put(SoundType.f_56724_, 1.5);
        map.put(SoundType.f_154663_, 1.25);
        map.put(SoundType.f_154677_, 1.5);
        map.put(SoundType.f_154678_, 1.5);
        map.put(SoundType.f_154679_, 1.5);
        map.put(SoundType.f_154680_, 1.5);
        map.put(SoundType.f_56721_, 1.5);
        map.put(SoundType.f_56720_, 1.1);
        map.put(SoundType.f_56729_, 1.1);
        map.put(SoundType.f_56723_, 1.1);
        map.put(SoundType.f_56763_, 0.4);
        map.put(SoundType.f_56745_, 0.1);
        map.put(SoundType.f_56751_, 0.1);
        map.put(SoundType.f_154669_, 0.1);
        map.put(SoundType.f_56716_, 0.2);
        map.put(SoundType.f_56717_, 0.2);
        map.put(SoundType.f_56753_, 0.2);
        map.put(SoundType.f_56743_, 1.25);
        map.put(SoundType.f_56736_, 0.4);
        map.put(SoundType.f_56739_, 0.3);
        map.put(SoundType.f_56740_, 0.3);
        map.put(SoundType.f_56744_, 0.75);
        map.put(SoundType.f_56746_, 0.2);
        map.put(SoundType.f_56747_, 0.15);
        return map;
    }
}

