/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.mixins;

import brightspark.asynclocator.AsyncLocator;
import brightspark.asynclocator.AsyncLocatorMod;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ConfiguredStructureTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Dolphin;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(targets={"net.minecraft.world.entity.animal.Dolphin$DolphinSwimToTreasureGoal"})
public class DolphinSwimToTreasureGoalMixin {
    @Final
    @Shadow
    private Dolphin f_28399_;
    @Shadow
    private boolean f_28400_;
    private AsyncLocator.LocateTask<BlockPos> locateTask = null;

    @Inject(method={"start"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;findNearestMapFeature(Lnet/minecraft/tags/TagKey;Lnet/minecraft/core/BlockPos;IZ)Lnet/minecraft/core/BlockPos;")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void findTreasureAsync(CallbackInfo ci, ServerLevel level, BlockPos blockpos) {
        AsyncLocatorMod.logDebug("Intercepted DolphinSwimToTreasureGoal#start call", new Object[0]);
        this.handleFindTreasureAsync(level, blockpos);
        ci.cancel();
    }

    @Inject(method={"canContinueToUse"}, at={@At(value="HEAD")}, cancellable=true)
    public void continueToUseIfLocatingTreasure(CallbackInfoReturnable<Boolean> cir) {
        if (this.locateTask != null) {
            AsyncLocatorMod.logDebug("Locating task ongoing - returning true for continueToUse()", new Object[0]);
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"stop"}, at={@At(value="HEAD")})
    public void stopLocatingTreasure(CallbackInfo ci) {
        if (this.locateTask != null) {
            AsyncLocatorMod.logDebug("Locating task ongoing - cancelling during stop()", new Object[0]);
            this.locateTask.cancel();
            this.locateTask = null;
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    public void skipTickingIfLocatingTreasure(CallbackInfo ci) {
        if (this.locateTask != null) {
            AsyncLocatorMod.logDebug("Locating task ongoing - skipping tick()", new Object[0]);
            ci.cancel();
        }
    }

    private void handleFindTreasureAsync(ServerLevel level, BlockPos blockPos) {
        this.locateTask = AsyncLocator.locate(level, ConfiguredStructureTags.f_207633_, blockPos, 50, false).thenOnServerThread(pos -> this.handleLocationFound(level, (BlockPos)pos));
    }

    private void handleLocationFound(ServerLevel level, BlockPos pos) {
        this.locateTask = null;
        if (pos != null) {
            AsyncLocatorMod.logInfo("Location found - updating dolphin treasure pos", new Object[0]);
            this.f_28399_.m_28384_(pos);
            level.m_7605_((Entity)this.f_28399_, (byte)38);
        } else {
            AsyncLocatorMod.logInfo("No location found - marking dolphin as stuck", new Object[0]);
            this.f_28400_ = true;
        }
    }
}

