/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.logic;

import brightspark.asynclocator.AsyncLocator;
import brightspark.asynclocator.AsyncLocatorConfig;
import brightspark.asynclocator.AsyncLocatorMod;
import brightspark.asynclocator.logic.CommonLogic;
import brightspark.asynclocator.mixins.MerchantOfferAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.saveddata.maps.MapDecoration;

public class MerchantLogic {
    private MerchantLogic() {
    }

    @Deprecated(since="1.1.0", forRemoval=true)
    public static ItemStack createEmptyMap() {
        return CommonLogic.createEmptyMap();
    }

    public static void invalidateMap(AbstractVillager merchant, ItemStack mapStack) {
        mapStack.m_41714_((Component)new TranslatableComponent("asynclocator.map.none"));
        merchant.m_6616_().stream().filter(offer -> offer.m_45368_() == mapStack).findFirst().ifPresentOrElse(offer -> MerchantLogic.removeOffer(merchant, offer), () -> AsyncLocatorMod.logWarn("Failed to find merchant offer for map", new Object[0]));
    }

    public static void removeOffer(AbstractVillager merchant, MerchantOffer offer) {
        if (((Boolean)AsyncLocatorConfig.REMOVE_OFFER.get()).booleanValue()) {
            if (merchant.m_6616_().remove((Object)offer)) {
                AsyncLocatorMod.logInfo("Removed merchant map offer", new Object[0]);
            } else {
                AsyncLocatorMod.logWarn("Failed to remove merchant map offer", new Object[0]);
            }
        } else {
            ((MerchantOfferAccess)offer).setMaxUses(0);
            offer.m_45381_();
            AsyncLocatorMod.logInfo("Marked merchant map offer as out of stock", new Object[0]);
        }
    }

    @Deprecated(since="1.1.0", forRemoval=true)
    public static void updateMap(ItemStack mapStack, ServerLevel level, BlockPos pos, String displayName, MapDecoration.Type destinationType) {
        CommonLogic.updateMap(mapStack, level, pos, 2, destinationType, displayName);
    }

    public static void handleLocationFound(ServerLevel level, AbstractVillager merchant, ItemStack mapStack, String displayName, MapDecoration.Type destinationType, BlockPos pos) {
        if (pos == null) {
            AsyncLocatorMod.logInfo("No location found - invalidating merchant offer", new Object[0]);
            MerchantLogic.invalidateMap(merchant, mapStack);
        } else {
            AsyncLocatorMod.logInfo("Location found - updating treasure map in merchant offer", new Object[0]);
            CommonLogic.updateMap(mapStack, level, pos, 2, destinationType, displayName);
        }
        Player player = merchant.m_7962_();
        if (player instanceof ServerPlayer) {
            int n;
            ServerPlayer tradingPlayer = (ServerPlayer)player;
            AsyncLocatorMod.logInfo("Player {} currently trading - updating merchant offers", tradingPlayer);
            int n2 = tradingPlayer.f_36096_.f_38840_;
            MerchantOffers merchantOffers = merchant.m_6616_();
            if (merchant instanceof Villager) {
                Villager villager = (Villager)merchant;
                n = villager.m_7141_().m_35576_();
            } else {
                n = 1;
            }
            tradingPlayer.m_7662_(n2, merchantOffers, n, merchant.m_7809_(), merchant.m_7826_(), merchant.m_7862_());
        }
    }

    public static MerchantOffer updateMapAsync(Entity pTrader, int emeraldCost, String displayName, MapDecoration.Type destinationType, int maxUses, int villagerXp, TagKey<ConfiguredStructureFeature<?, ?>> destination) {
        return MerchantLogic.updateMapAsyncInternal(pTrader, emeraldCost, maxUses, villagerXp, (level, merchant, mapStack) -> AsyncLocator.locate(level, destination, merchant.m_142538_(), 100, true).thenOnServerThread(pos -> MerchantLogic.handleLocationFound(level, merchant, mapStack, displayName, destinationType, pos)));
    }

    public static MerchantOffer updateMapAsync(Entity pTrader, int emeraldCost, String displayName, MapDecoration.Type destinationType, int maxUses, int villagerXp, HolderSet<ConfiguredStructureFeature<?, ?>> structureSet) {
        return MerchantLogic.updateMapAsyncInternal(pTrader, emeraldCost, maxUses, villagerXp, (level, merchant, mapStack) -> AsyncLocator.locate(level, structureSet, merchant.m_142538_(), 100, true).thenOnServerThread(pair -> MerchantLogic.handleLocationFound(level, merchant, mapStack, displayName, destinationType, (BlockPos)pair.getFirst())));
    }

    private static MerchantOffer updateMapAsyncInternal(Entity trader, int emeraldCost, int maxUses, int villagerXp, MapUpdateTask task) {
        if (trader instanceof AbstractVillager) {
            AbstractVillager merchant = (AbstractVillager)trader;
            ItemStack mapStack = CommonLogic.createEmptyMap();
            task.apply((ServerLevel)trader.f_19853_, merchant, mapStack);
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, emeraldCost), new ItemStack((ItemLike)Items.f_42522_), mapStack, maxUses, villagerXp, 0.2f);
        }
        AsyncLocatorMod.logInfo("Merchant is not of type {} - not running async logic", AbstractVillager.class.getSimpleName());
        return null;
    }

    public static interface MapUpdateTask {
        public void apply(ServerLevel var1, AbstractVillager var2, ItemStack var3);
    }
}

