/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.logic;

import brightspark.asynclocator.AsyncLocator;
import brightspark.asynclocator.AsyncLocatorMod;
import brightspark.asynclocator.logic.CommonLogic;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ExplorationMapFunctionLogic {
    private ExplorationMapFunctionLogic() {
    }

    public static void invalidateMap(ItemStack mapStack, ServerLevel level, BlockPos pos) {
        ExplorationMapFunctionLogic.handleUpdateMapInChest(mapStack, level, pos, (handler, slot) -> {
            if (handler instanceof IItemHandlerModifiable) {
                IItemHandlerModifiable modifiableHandler = (IItemHandlerModifiable)handler;
                modifiableHandler.setStackInSlot(slot.intValue(), new ItemStack((ItemLike)Items.f_42676_));
            } else {
                handler.extractItem(slot.intValue(), 64, false);
                handler.insertItem(slot.intValue(), new ItemStack((ItemLike)Items.f_42676_), false);
            }
        });
    }

    public static void updateMap(ItemStack mapStack, ServerLevel level, BlockPos pos, int scale, MapDecoration.Type destinationType, BlockPos invPos) {
        CommonLogic.updateMap(mapStack, level, pos, scale, destinationType);
        ExplorationMapFunctionLogic.handleUpdateMapInChest(mapStack, level, invPos, (handler, slot) -> {});
    }

    public static void handleUpdateMapInChest(ItemStack mapStack, ServerLevel level, BlockPos invPos, BiConsumer<IItemHandler, Integer> handleSlotFound) {
        BlockEntity be = level.m_7702_(invPos);
        if (be != null) {
            be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().ifPresentOrElse(itemHandler -> {
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack slotStack = itemHandler.getStackInSlot(i);
                    if (slotStack != mapStack) continue;
                    handleSlotFound.accept((IItemHandler)itemHandler, i);
                    CommonLogic.broadcastChestChanges(level, be);
                    return;
                }
            }, () -> AsyncLocatorMod.logWarn("Couldn't find item handler capability on chest {} at {}", be.getClass().getSimpleName(), invPos));
        } else {
            AsyncLocatorMod.logWarn("Couldn't find block entity on chest {} at {}", level.m_8055_(invPos), invPos);
        }
    }

    public static void handleLocationFound(ItemStack mapStack, ServerLevel level, BlockPos pos, int scale, MapDecoration.Type destinationType, BlockPos invPos) {
        if (pos == null) {
            AsyncLocatorMod.logInfo("No location found - invalidating map stack", new Object[0]);
            ExplorationMapFunctionLogic.invalidateMap(mapStack, level, invPos);
        } else {
            AsyncLocatorMod.logInfo("Location found - updating treasure map in chest", new Object[0]);
            ExplorationMapFunctionLogic.updateMap(mapStack, level, pos, scale, destinationType, invPos);
        }
    }

    public static ItemStack updateMapAsync(ServerLevel level, BlockPos blockPos, int scale, int searchRadius, boolean skipKnownStructures, MapDecoration.Type destinationType, TagKey<ConfiguredStructureFeature<?, ?>> destination) {
        ItemStack mapStack = CommonLogic.createEmptyMap();
        AsyncLocator.locate(level, destination, blockPos, searchRadius, skipKnownStructures).thenOnServerThread(pos -> ExplorationMapFunctionLogic.handleLocationFound(mapStack, level, pos, scale, destinationType, blockPos));
        return mapStack;
    }
}

