/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator;

import net.minecraftforge.common.ForgeConfigSpec;

public class AsyncLocatorConfig {
    public static ForgeConfigSpec SPEC = (ForgeConfigSpec)new ForgeConfigSpec.Builder().configure(builder -> {
        LOCATOR_THREADS = builder.worldRestart().comment(new String[]{"The maximum number of threads in the async locator thread pool.", "There's no upper bound to this, however this should only be increased if you're experiencing", "simultaneous location lookups causing issues AND you have the hardware capable of handling", "the extra possible threads.", "The default of 1 should be suitable for most users."}).defineInRange("asyncLocatorThreads", 1, 1, Integer.MAX_VALUE);
        REMOVE_OFFER = builder.comment(new String[]{"When a merchant's treasure map offer ends up not finding a feature location,", "whether the offer should be removed or marked as out of stock."}).define("removeMerchantInvalidMapOffer", false);
        return null;
    }).getValue();
    public static ForgeConfigSpec.ConfigValue<Integer> LOCATOR_THREADS;
    public static ForgeConfigSpec.ConfigValue<Boolean> REMOVE_OFFER;

    private AsyncLocatorConfig() {
    }
}

