/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator;

import brightspark.asynclocator.AsyncLocatorConfig;
import brightspark.asynclocator.AsyncLocatorMod;
import com.mojang.datafixers.util.Pair;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import org.jetbrains.annotations.NotNull;

public class AsyncLocator {
    private static ExecutorService LOCATING_EXECUTOR_SERVICE = null;

    private AsyncLocator() {
    }

    private static void setupExecutorService() {
        AsyncLocator.shutdownExecutorService();
        int threads = (Integer)AsyncLocatorConfig.LOCATOR_THREADS.get();
        AsyncLocatorMod.logInfo("Starting locating executor service with thread pool size of {}", threads);
        LOCATING_EXECUTOR_SERVICE = Executors.newFixedThreadPool(threads, new ThreadFactory(){
            private static final AtomicInteger poolNum = new AtomicInteger(1);
            private final AtomicInteger threadNum = new AtomicInteger(1);
            private final String namePrefix = "asynclocator-" + poolNum.getAndIncrement() + "-thread-";

            @Override
            public Thread newThread(@NotNull Runnable r) {
                return new Thread((ThreadGroup)SidedThreadGroups.SERVER, r, this.namePrefix + this.threadNum.getAndIncrement());
            }
        });
    }

    private static void shutdownExecutorService() {
        if (LOCATING_EXECUTOR_SERVICE != null) {
            AsyncLocatorMod.logInfo("Shutting down locating executor service", new Object[0]);
            LOCATING_EXECUTOR_SERVICE.shutdown();
        }
    }

    static void handleServerAboutToStartEvent(ServerAboutToStartEvent ignoredEvent) {
        AsyncLocator.setupExecutorService();
    }

    static void handleServerStoppingEvent(ServerStoppingEvent ignoredEvent) {
        AsyncLocator.shutdownExecutorService();
    }

    public static LocateTask<BlockPos> locate(ServerLevel level, TagKey<ConfiguredStructureFeature<?, ?>> structureTag, BlockPos pos, int searchRadius, boolean skipKnownStructures) {
        AsyncLocatorMod.logDebug("Creating locate task for {} in {} around {} within {} chunks", structureTag, level, pos, searchRadius);
        CompletableFuture completableFuture = new CompletableFuture();
        Future<?> future = LOCATING_EXECUTOR_SERVICE.submit(() -> AsyncLocator.doLocateLevel(completableFuture, level, structureTag, pos, searchRadius, skipKnownStructures));
        return new LocateTask<BlockPos>(level.m_142572_(), completableFuture, future);
    }

    public static LocateTask<Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>>> locate(ServerLevel level, HolderSet<ConfiguredStructureFeature<?, ?>> structureSet, BlockPos pos, int searchRadius, boolean skipKnownStructures) {
        AsyncLocatorMod.logDebug("Creating locate task for {} in {} around {} within {} chunks", structureSet, level, pos, searchRadius);
        CompletableFuture completableFuture = new CompletableFuture();
        Future<?> future = LOCATING_EXECUTOR_SERVICE.submit(() -> AsyncLocator.doLocateChunkGenerator(completableFuture, level, structureSet, pos, searchRadius, skipKnownStructures));
        return new LocateTask(level.m_142572_(), completableFuture, future);
    }

    private static void doLocateLevel(CompletableFuture<BlockPos> completableFuture, ServerLevel level, TagKey<ConfiguredStructureFeature<?, ?>> structureTag, BlockPos pos, int searchRadius, boolean skipExistingChunks) {
        AsyncLocatorMod.logInfo("Trying to locate {} in {} around {} within {} chunks", structureTag, level, pos, searchRadius);
        BlockPos foundPos = level.m_207561_(structureTag, pos, searchRadius, skipExistingChunks);
        if (foundPos == null) {
            AsyncLocatorMod.logInfo("No {} found", structureTag);
        } else {
            AsyncLocatorMod.logInfo("Found {} at {}", structureTag, foundPos);
        }
        completableFuture.complete(foundPos);
    }

    private static void doLocateChunkGenerator(CompletableFuture<Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>>> completableFuture, ServerLevel level, HolderSet<ConfiguredStructureFeature<?, ?>> structureSet, BlockPos pos, int searchRadius, boolean skipExistingChunks) {
        AsyncLocatorMod.logInfo("Trying to locate {} in {} around {} within {} chunks", structureSet, level, pos, searchRadius);
        Pair foundPair = level.m_7726_().m_8481_().m_207970_(level, structureSet, pos, searchRadius, skipExistingChunks);
        if (foundPair == null) {
            AsyncLocatorMod.logInfo("No {} found", structureSet);
        } else {
            AsyncLocatorMod.logInfo("Found {} at {}", ((Holder)foundPair.getSecond()).m_203334_(), foundPair.getFirst());
        }
        completableFuture.complete(foundPair);
    }

    public record LocateTask<T>(MinecraftServer server, CompletableFuture<T> completableFuture, Future<?> taskFuture) {
        public LocateTask<T> then(Consumer<T> action) {
            this.completableFuture.thenAccept((Consumer)action);
            return this;
        }

        public LocateTask<T> thenOnServerThread(Consumer<T> action) {
            this.completableFuture.thenAccept(pos -> this.server.m_18707_(() -> action.accept(pos)));
            return this;
        }

        public void cancel() {
            this.taskFuture.cancel(true);
            this.completableFuture.cancel(false);
        }
    }
}

