/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.data;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vectorwing.farmersdelight.FarmersDelight;
import vectorwing.farmersdelight.common.registry.ModItems;

public class ItemModels
extends ItemModelProvider {
    public static final String GENERATED = "item/generated";
    public static final String HANDHELD = "item/handheld";
    public static final ResourceLocation MUG = new ResourceLocation("farmersdelight", "item/mug");

    public ItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "farmersdelight", existingFileHelper);
    }

    protected void registerModels() {
        Set<Item> items = ForgeRegistries.ITEMS.getValues().stream().filter(i -> "farmersdelight".equals(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)i).m_135827_())).collect(Collectors.toSet());
        items.remove(ModItems.SKILLET.get());
        this.itemGeneratedModel((Item)ModItems.WILD_RICE.get(), this.resourceBlock(this.itemName((Item)ModItems.WILD_RICE.get()) + "_top"));
        items.remove(ModItems.WILD_RICE.get());
        this.itemGeneratedModel((Item)ModItems.BROWN_MUSHROOM_COLONY.get(), this.resourceBlock(this.itemName((Item)ModItems.BROWN_MUSHROOM_COLONY.get()) + "_stage3"));
        items.remove(ModItems.BROWN_MUSHROOM_COLONY.get());
        this.itemGeneratedModel((Item)ModItems.RED_MUSHROOM_COLONY.get(), this.resourceBlock(this.itemName((Item)ModItems.RED_MUSHROOM_COLONY.get()) + "_stage3"));
        items.remove(ModItems.RED_MUSHROOM_COLONY.get());
        this.blockBasedModel((Item)ModItems.TATAMI.get(), "_half");
        items.remove(ModItems.TATAMI.get());
        this.blockBasedModel((Item)ModItems.ORGANIC_COMPOST.get(), "_0");
        items.remove(ModItems.ORGANIC_COMPOST.get());
        HashSet mugItems = Sets.newHashSet((Object[])new Item[]{(Item)ModItems.HOT_COCOA.get(), (Item)ModItems.APPLE_CIDER.get(), (Item)ModItems.MELON_JUICE.get()});
        ItemModels.takeAll(items, mugItems.toArray(new Item[0])).forEach(item -> this.itemMugModel((Item)item, this.resourceItem(this.itemName((Item)item))));
        HashSet spriteBlockItems = Sets.newHashSet((Object[])new Item[]{(Item)ModItems.FULL_TATAMI_MAT.get(), (Item)ModItems.HALF_TATAMI_MAT.get(), (Item)ModItems.ROPE.get(), (Item)ModItems.CANVAS_SIGN.get(), (Item)ModItems.WHITE_CANVAS_SIGN.get(), (Item)ModItems.ORANGE_CANVAS_SIGN.get(), (Item)ModItems.MAGENTA_CANVAS_SIGN.get(), (Item)ModItems.LIGHT_BLUE_CANVAS_SIGN.get(), (Item)ModItems.YELLOW_CANVAS_SIGN.get(), (Item)ModItems.LIME_CANVAS_SIGN.get(), (Item)ModItems.PINK_CANVAS_SIGN.get(), (Item)ModItems.GRAY_CANVAS_SIGN.get(), (Item)ModItems.LIGHT_GRAY_CANVAS_SIGN.get(), (Item)ModItems.CYAN_CANVAS_SIGN.get(), (Item)ModItems.PURPLE_CANVAS_SIGN.get(), (Item)ModItems.BLUE_CANVAS_SIGN.get(), (Item)ModItems.BROWN_CANVAS_SIGN.get(), (Item)ModItems.GREEN_CANVAS_SIGN.get(), (Item)ModItems.RED_CANVAS_SIGN.get(), (Item)ModItems.BLACK_CANVAS_SIGN.get(), (Item)ModItems.APPLE_PIE.get(), (Item)ModItems.SWEET_BERRY_CHEESECAKE.get(), (Item)ModItems.CHOCOLATE_PIE.get(), (Item)ModItems.CABBAGE_SEEDS.get(), (Item)ModItems.TOMATO_SEEDS.get(), (Item)ModItems.ONION.get(), (Item)ModItems.RICE.get(), (Item)ModItems.ROAST_CHICKEN_BLOCK.get(), (Item)ModItems.STUFFED_PUMPKIN_BLOCK.get(), (Item)ModItems.HONEY_GLAZED_HAM_BLOCK.get(), (Item)ModItems.SHEPHERDS_PIE_BLOCK.get(), (Item)ModItems.RICE_ROLL_MEDLEY_BLOCK.get()});
        ItemModels.takeAll(items, spriteBlockItems.toArray(new Item[0])).forEach(item -> ((ItemModelBuilder)this.withExistingParent(this.itemName((Item)item), GENERATED)).texture("layer0", this.resourceItem(this.itemName((Item)item))));
        HashSet flatBlockItems = Sets.newHashSet((Object[])new Item[]{(Item)ModItems.SAFETY_NET.get(), (Item)ModItems.SANDY_SHRUB.get(), (Item)ModItems.WILD_BEETROOTS.get(), (Item)ModItems.WILD_CABBAGES.get(), (Item)ModItems.WILD_CARROTS.get(), (Item)ModItems.WILD_ONIONS.get(), (Item)ModItems.WILD_POTATOES.get(), (Item)ModItems.WILD_TOMATOES.get()});
        ItemModels.takeAll(items, flatBlockItems.toArray(new Item[0])).forEach(item -> this.itemGeneratedModel((Item)item, this.resourceBlock(this.itemName((Item)item))));
        ItemModels.takeAll(items, i -> i instanceof BlockItem).forEach(item -> this.blockBasedModel((Item)item, ""));
        HashSet handheldItems = Sets.newHashSet((Object[])new Item[]{(Item)ModItems.BARBECUE_STICK.get(), (Item)ModItems.HAM.get(), (Item)ModItems.SMOKED_HAM.get(), (Item)ModItems.FLINT_KNIFE.get(), (Item)ModItems.IRON_KNIFE.get(), (Item)ModItems.DIAMOND_KNIFE.get(), (Item)ModItems.GOLDEN_KNIFE.get(), (Item)ModItems.NETHERITE_KNIFE.get()});
        ItemModels.takeAll(items, handheldItems.toArray(new Item[0])).forEach(item -> this.itemHandheldModel((Item)item, this.resourceItem(this.itemName((Item)item))));
        items.forEach(item -> this.itemGeneratedModel((Item)item, this.resourceItem(this.itemName((Item)item))));
    }

    public void blockBasedModel(Item item, String suffix) {
        this.withExistingParent(this.itemName(item), this.resourceBlock(this.itemName(item) + suffix));
    }

    public void itemHandheldModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), HANDHELD)).texture("layer0", texture);
    }

    public void itemGeneratedModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), GENERATED)).texture("layer0", texture);
    }

    public void itemMugModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), MUG)).texture("layer0", texture);
    }

    private String itemName(Item item) {
        return item.getRegistryName().m_135815_();
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("farmersdelight", "block/" + path);
    }

    public ResourceLocation resourceItem(String path) {
        return new ResourceLocation("farmersdelight", "item/" + path);
    }

    @SafeVarargs
    public static <T> Collection<T> takeAll(Set<? extends T> src, T ... items) {
        List<T> ret = Arrays.asList(items);
        for (T item : items) {
            if (src.contains(item)) continue;
            FarmersDelight.LOGGER.warn("Item {} not found in set", item);
        }
        if (!src.removeAll(ret)) {
            FarmersDelight.LOGGER.warn("takeAll array didn't yield anything ({})", (Object)Arrays.toString(items));
        }
        return ret;
    }

    public static <T> Collection<T> takeAll(Set<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!pred.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            FarmersDelight.LOGGER.warn("takeAll predicate yielded nothing", new Throwable());
        }
        return ret;
    }
}

