/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vectorwing.farmersdelight.common.block.entity.SkilletBlockEntity;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.tag.ModTags;

public class SkilletBlock
extends BaseEntityBlock {
    public static final int MINIMUM_COOKING_TIME = 60;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty SUPPORT = BooleanProperty.m_61465_((String)"support");
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0);
    protected static final VoxelShape SHAPE_WITH_TRAY = Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)-1.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0));

    public SkilletBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SUPPORT, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof SkilletBlockEntity) {
            SkilletBlockEntity skilletEntity = (SkilletBlockEntity)tileEntity;
            if (!level.f_46443_) {
                EquipmentSlot heldSlot;
                ItemStack heldStack = player.m_21120_(hand);
                EquipmentSlot equipmentSlot = heldSlot = hand.equals((Object)InteractionHand.MAIN_HAND) ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
                if (heldStack.m_41619_()) {
                    ItemStack extractedStack = skilletEntity.removeItem();
                    if (!player.m_7500_()) {
                        player.m_8061_(heldSlot, extractedStack);
                    }
                    return InteractionResult.SUCCESS;
                }
                ItemStack remainderStack = skilletEntity.addItemToCook(heldStack, player);
                if (remainderStack.m_41613_() != heldStack.m_41613_()) {
                    if (!player.m_7500_()) {
                        player.m_8061_(heldSlot, remainderStack);
                    }
                    level.m_5594_(null, pos, SoundEvents.f_12028_, SoundSource.BLOCKS, 0.7f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof SkilletBlockEntity) {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)((SkilletBlockEntity)tileEntity).getInventory().getStackInSlot(0));
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((Boolean)state.m_61143_((Property)SUPPORT)).equals(true) ? SHAPE_WITH_TRAY : SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)SUPPORT, (Comparable)Boolean.valueOf(this.getTrayState((LevelAccessor)context.m_43725_(), context.m_8083_())));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (facing.m_122434_().equals((Object)Direction.Axis.Y)) {
            return (BlockState)state.m_61124_((Property)SUPPORT, (Comparable)Boolean.valueOf(this.getTrayState(world, currentPos)));
        }
        return state;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack stack = super.m_7397_(level, pos, state);
        SkilletBlockEntity skilletEntity = (SkilletBlockEntity)level.m_7702_(pos);
        CompoundTag nbt = new CompoundTag();
        if (skilletEntity != null) {
            skilletEntity.writeSkilletItem(nbt);
        }
        if (!nbt.m_128456_()) {
            stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Skillet"));
        }
        return stack;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SUPPORT});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level level, BlockPos pos, Random rand) {
        SkilletBlockEntity skilletEntity;
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof SkilletBlockEntity && (skilletEntity = (SkilletBlockEntity)tileEntity).isCooking()) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.5;
            if (rand.nextInt(10) == 0) {
                level.m_7785_(x, y, z, (SoundEvent)ModSounds.BLOCK_SKILLET_SIZZLE.get(), SoundSource.BLOCKS, 0.4f, rand.nextFloat() * 0.2f + 0.9f, false);
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntityTypes.SKILLET.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        if (level.f_46443_) {
            return SkilletBlock.m_152132_(blockEntity, (BlockEntityType)((BlockEntityType)ModBlockEntityTypes.SKILLET.get()), SkilletBlockEntity::animationTick);
        }
        return SkilletBlock.m_152132_(blockEntity, (BlockEntityType)((BlockEntityType)ModBlockEntityTypes.SKILLET.get()), SkilletBlockEntity::cookingTick);
    }

    private boolean getTrayState(LevelAccessor world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_204336_(ModTags.TRAY_HEAT_SOURCES);
    }

    public static int getSkilletCookingTime(int originalCookingTime, int fireAspectLevel) {
        int cookingTime = originalCookingTime > 0 ? originalCookingTime : 600;
        int cookingSeconds = cookingTime / 20;
        float cookingTimeReduction = 0.2f;
        if (fireAspectLevel > 0) {
            cookingTimeReduction = (float)((double)cookingTimeReduction - (double)fireAspectLevel * 0.05);
        }
        int result = (int)((float)cookingSeconds * cookingTimeReduction) * 20;
        return Mth.m_14045_((int)result, (int)60, (int)originalCookingTime);
    }
}

