/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;
import vectorwing.farmersdelight.common.tag.ModTags;

public class MushroomColonyBlock
extends BushBlock
implements BonemealableBlock {
    public static final int PLACING_LIGHT_LEVEL = 13;
    public final Supplier<Item> mushroomType;
    public static final IntegerProperty COLONY_AGE = BlockStateProperties.f_61407_;
    protected static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0)};

    public MushroomColonyBlock(BlockBehaviour.Properties properties, Supplier<Item> mushroomType) {
        super(properties);
        this.mushroomType = mushroomType;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)COLONY_AGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)this.getAgeProperty())];
    }

    public IntegerProperty getAgeProperty() {
        return COLONY_AGE;
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_60804_(level, pos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos floorPos = pos.m_7495_();
        BlockState floorState = level.m_8055_(floorPos);
        if (floorState.m_204336_(BlockTags.f_13057_)) {
            return true;
        }
        return level.m_45524_(pos, 0) < 13 && floorState.canSustainPlant((BlockGetter)level, floorPos, Direction.UP, (IPlantable)this);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int age = (Integer)state.m_61143_((Property)COLONY_AGE);
        ItemStack heldStack = player.m_21120_(hand);
        if (age > 0 && heldStack.m_204117_(Tags.Items.SHEARS)) {
            MushroomColonyBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)this.m_7397_((BlockGetter)level, pos, state));
            level.m_5594_(null, pos, SoundEvents.f_12075_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)COLONY_AGE, (Comparable)Integer.valueOf(age - 1)), 2);
            if (!level.f_46443_) {
                heldStack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(hand));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public int getMaxAge() {
        return 3;
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        int age = (Integer)state.m_61143_((Property)COLONY_AGE);
        BlockState groundState = level.m_8055_(pos.m_7495_());
        if (age < this.getMaxAge() && groundState.m_204336_(ModTags.MUSHROOM_COLONY_GROWABLE_ON) && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (rand.nextInt(4) == 0 ? 1 : 0) != 0)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)COLONY_AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.mushroomType.get());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{COLONY_AGE});
    }

    public boolean m_7370_(BlockGetter level, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty()) < this.getMaxAge();
    }

    public boolean m_5491_(Level level, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    protected int getBonemealAgeIncrease(Level level) {
        return Mth.m_14072_((Random)level.f_46441_, (int)1, (int)2);
    }

    public void m_7719_(ServerLevel level, Random rand, BlockPos pos, BlockState state) {
        int age = Math.min(this.getMaxAge(), (Integer)state.m_61143_((Property)COLONY_AGE) + this.getBonemealAgeIncrease((Level)level));
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)COLONY_AGE, (Comparable)Integer.valueOf(age)), 2);
    }
}

