/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class ServerModConfig {
    public static final Path CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("do_a_barrel_roll-server.json");
    public static ServerModConfig INSTANCE;
    private static final Gson GSON;
    public boolean allowThrusting = true;

    public static void load() {
        INSTANCE = ServerModConfig.loadConfigFile(CONFIG_FILE);
    }

    public void save() {
        this.saveConfigFile(CONFIG_FILE);
    }

    private static ServerModConfig loadConfigFile(Path file) {
        ServerModConfig config = null;
        if (Files.exists(file, new LinkOption[0])) {
            try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file.toFile()), StandardCharsets.UTF_8));){
                config = (ServerModConfig)GSON.fromJson((Reader)fileReader, ServerModConfig.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Problem occurred when trying to load config: ", e);
            }
        }
        if (config == null) {
            config = new ServerModConfig();
        }
        config.saveConfigFile(file);
        return config;
    }

    private void saveConfigFile(Path file) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file.toFile()), StandardCharsets.UTF_8);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ServerModConfig fromJson(String json) {
        return (ServerModConfig)GSON.fromJson(json, ServerModConfig.class);
    }

    public String toJson() {
        return GSON.toJson((Object)this);
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
    }
}

