/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.api.net;

import com.google.gson.JsonSyntaxException;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import nl.enjarai.doabarrelroll.DoABarrelRoll;

public class HandshakeClient<T> {
    private final Function<String, T> configDeserializer;
    private final Consumer<T> updateCallback;
    private T serverConfig = null;

    public HandshakeClient(Function<String, T> configDeserializer, Consumer<T> updateCallback) {
        this.configDeserializer = configDeserializer;
        this.updateCallback = updateCallback;
    }

    public Optional<T> getConfig() {
        return Optional.ofNullable(this.serverConfig);
    }

    public FriendlyByteBuf handleConfigSync(FriendlyByteBuf buf) {
        try {
            this.serverConfig = this.configDeserializer.apply(buf.m_130277_());
            DoABarrelRoll.LOGGER.info("Successfully received and applied server config.");
        }
        catch (JsonSyntaxException e) {
            this.serverConfig = null;
            DoABarrelRoll.LOGGER.error("Received invalid config from server", (Throwable)e);
        }
        if (this.serverConfig != null) {
            this.updateCallback.accept(this.serverConfig);
        }
        FriendlyByteBuf returnBuf = new FriendlyByteBuf(Unpooled.buffer());
        returnBuf.writeBoolean(this.serverConfig != null);
        return returnBuf;
    }

    public void reset() {
        this.serverConfig = null;
    }
}

