/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.api.event;

import nl.enjarai.doabarrelroll.api.event.Event;
import nl.enjarai.doabarrelroll.flight.util.RotationInstant;

public interface RollEvents {
    public static final Event<ShouldRollCheckEvent> SHOULD_ROLL_CHECK = new Event();
    public static final Event<CameraModifiersEvent> EARLY_CAMERA_MODIFIERS = new Event();
    public static final Event<CameraModifiersEvent> LATE_CAMERA_MODIFIERS = new Event();

    public static boolean shouldRoll() {
        for (ShouldRollCheckEvent listener : SHOULD_ROLL_CHECK.getListeners()) {
            if (!listener.shouldRoll()) continue;
            return true;
        }
        return false;
    }

    public static RotationInstant earlyCameraModifiers(RotationInstant rotationDelta, RotationInstant currentRotation) {
        for (CameraModifiersEvent listener : EARLY_CAMERA_MODIFIERS.getListeners()) {
            rotationDelta = listener.applyCameraModifiers(rotationDelta, currentRotation);
        }
        return rotationDelta;
    }

    public static RotationInstant lateCameraModifiers(RotationInstant rotationDelta, RotationInstant currentRotation) {
        for (CameraModifiersEvent listener : LATE_CAMERA_MODIFIERS.getListeners()) {
            rotationDelta = listener.applyCameraModifiers(rotationDelta, currentRotation);
        }
        return rotationDelta;
    }

    public static interface ShouldRollCheckEvent {
        public boolean shouldRoll();
    }

    public static interface CameraModifiersEvent {
        public RotationInstant applyCameraModifiers(RotationInstant var1, RotationInstant var2);
    }
}

