/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.world.phys.shapes;

import java.util.stream.Stream;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelUtils {
    public static Vec3[] scaleDown(Vec3[] edges) {
        return VoxelUtils.scale(edges, 0.0625);
    }

    public static Vec3[] scale(Vec3[] edges, double amount) {
        return (Vec3[])Stream.of(edges).map(edge -> edge.m_82490_(amount)).toArray(Vec3[]::new);
    }

    public static Vec3[] flipX(Vec3[] edges) {
        return (Vec3[])Stream.of(edges).map(edge -> new Vec3(16.0 - edge.f_82479_, edge.f_82480_, edge.f_82481_)).toArray(Vec3[]::new);
    }

    public static Vec3[] flipZ(Vec3[] edges) {
        return (Vec3[])Stream.of(edges).map(edge -> new Vec3(edge.f_82479_, edge.f_82480_, 16.0 - edge.f_82481_)).toArray(Vec3[]::new);
    }

    public static Vec3[] mirror(Vec3[] edges) {
        return VoxelUtils.flipZ(VoxelUtils.flipX(edges));
    }

    public static Vec3[] ortho(Vec3[] edges) {
        return (Vec3[])Stream.of(edges).map(edge -> new Vec3(edge.f_82481_, edge.f_82480_, edge.f_82479_)).toArray(Vec3[]::new);
    }

    public static VoxelShape makeCuboidShape(Vec3[] outline) {
        Vec3 start = outline[0];
        Vec3 end = outline[1];
        double startX = Math.min(start.f_82479_, end.f_82479_);
        double startY = Math.min(start.f_82480_, end.f_82480_);
        double startZ = Math.min(start.f_82481_, end.f_82481_);
        double endX = Math.max(start.f_82479_, end.f_82479_);
        double endY = Math.max(start.f_82480_, end.f_82480_);
        double endZ = Math.max(start.f_82481_, end.f_82481_);
        return Block.m_49796_((double)startX, (double)startY, (double)startZ, (double)endX, (double)endY, (double)endZ);
    }

    public static Vec3[] createVectorArray(Float ... values) {
        return VoxelUtils.createVectorArray((Double[])Stream.of(values).map(Float::doubleValue).toArray(Double[]::new));
    }

    public static Vec3[] createVectorArray(Double ... values) {
        if (values.length % 3 != 0) {
            throw new IllegalStateException("Unable to create proper number of vectors");
        }
        Vec3[] array = new Vec3[values.length / 3];
        for (int i = 0; i < array.length; ++i) {
            int index = 3 * i;
            array[i] = new Vec3(values[index].doubleValue(), values[index + 1].doubleValue(), values[index + 2].doubleValue());
        }
        return array;
    }

    public static Vec3[] create12Edges(Vec3[] corners) {
        if (corners.length != 8) {
            throw new IllegalStateException("Amount of corners must be 8");
        }
        return new Vec3[]{corners[0], corners[1], corners[1], corners[3], corners[3], corners[2], corners[2], corners[0], corners[0], corners[4], corners[1], corners[5], corners[2], corners[6], corners[3], corners[7], corners[4], corners[5], corners[5], corners[7], corners[7], corners[6], corners[6], corners[4]};
    }
}

