/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.client.model;

import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;

public class QuadUtils {
    private static final float ROTATION_ANGLE = -45.0f;
    private static final float SCALE_ROTATION_45 = 1.0f / (float)Math.cos(0.7853981633974483) - 1.0f;
    private static final Vector3f ROTATION_ORIGIN = new Vector3f(0.5f, 0.5f, 0.5f);
    private static final Matrix4f ROTATION_MATRIX = new Matrix4f(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), -45.0f, true));

    public static BakedQuad duplicateQuad(BakedQuad quad) {
        int[] vertexData = new int[quad.m_111303_().length];
        System.arraycopy(quad.m_111303_(), 0, vertexData, 0, vertexData.length);
        return new BakedQuad(vertexData, quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), quad.m_111307_());
    }

    public static void rotateQuad(BakedQuad quad, Direction dir) {
        Vector3f scaleMult = new Vector3f((float)Math.abs(dir.m_122429_()), 1.0f, (float)Math.abs(dir.m_122431_()));
        Vector3f scaleVec = new Vector3f(1.0f, 0.0f, 1.0f);
        scaleVec.m_122261_(SCALE_ROTATION_45);
        scaleVec.m_122263_(scaleMult.m_122239_(), scaleMult.m_122260_(), scaleMult.m_122269_());
        scaleVec.m_122272_(1.0f, 1.0f, 1.0f);
        int[] vertexData = quad.m_111303_();
        float[][] pos = QuadUtils.unpackQuadPosition(vertexData);
        for (int i = 0; i < 4; ++i) {
            Vector4f vector4f = new Vector4f(pos[i][0] - ROTATION_ORIGIN.m_122239_(), pos[i][1] - ROTATION_ORIGIN.m_122260_(), pos[i][2] - ROTATION_ORIGIN.m_122269_(), 1.0f);
            vector4f.m_123611_(scaleVec);
            vector4f.m_123607_(ROTATION_MATRIX);
            pos[i][0] = vector4f.m_123601_() + ROTATION_ORIGIN.m_122239_();
            pos[i][1] = vector4f.m_123615_() + ROTATION_ORIGIN.m_122260_();
            pos[i][2] = vector4f.m_123616_() + ROTATION_ORIGIN.m_122269_();
        }
        QuadUtils.packQuadPositions(vertexData, pos);
        QuadUtils.fillNormal(vertexData, pos);
    }

    public static float[][] unpackQuadPosition(int[] vertexData) {
        float[][] pos = new float[4][3];
        int step = vertexData.length / 4;
        for (int i = 0; i < 4; ++i) {
            int offset = i * step;
            pos[i][0] = Float.intBitsToFloat(vertexData[offset]);
            pos[i][1] = Float.intBitsToFloat(vertexData[offset + 1]);
            pos[i][2] = Float.intBitsToFloat(vertexData[offset + 2]);
        }
        return pos;
    }

    public static void packQuadPositions(int[] vertexData, float[][] pos) {
        int step = vertexData.length / 4;
        for (int i = 0; i < 4; ++i) {
            int offset = i * step;
            vertexData[offset] = Float.floatToIntBits(pos[i][0]);
            vertexData[offset + 1] = Float.floatToIntBits(pos[i][1]);
            vertexData[offset + 2] = Float.floatToIntBits(pos[i][2]);
        }
    }

    public static void fillNormal(int[] vertexData, float[][] pos) {
        Vector3f v1 = new Vector3f(pos[3][0], pos[3][1], pos[3][2]);
        Vector3f t1 = new Vector3f(pos[1][0], pos[1][1], pos[1][2]);
        Vector3f v2 = new Vector3f(pos[2][0], pos[2][1], pos[2][2]);
        Vector3f t2 = new Vector3f(pos[0][0], pos[0][1], pos[0][2]);
        v1.m_122267_(t1);
        v2.m_122267_(t2);
        v2.m_122279_(v1);
        v2.m_122278_();
        int x = (byte)Math.round(v2.m_122239_() * 127.0f) & 0xFF;
        int y = (byte)Math.round(v2.m_122260_() * 127.0f) & 0xFF;
        int z = (byte)Math.round(v2.m_122269_() * 127.0f) & 0xFF;
        int normal = x | y << 8 | z << 16;
        int step = vertexData.length / 4;
        for (int vert = 0; vert < 4; ++vert) {
            vertexData[vert * step + 7] = normal;
        }
    }
}

