/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.client.model;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fuzs.diagonalfences.DiagonalFences;
import fuzs.diagonalfences.api.world.level.block.DiagonalBlock;
import fuzs.diagonalfences.api.world.level.block.EightWayDirection;
import fuzs.diagonalfences.client.core.ClientAbstractions;
import fuzs.diagonalfences.client.model.QuadUtils;
import fuzs.diagonalfences.client.model.RotatedVariant;
import fuzs.diagonalfences.mixin.client.accessor.AndConditionAccessor;
import fuzs.diagonalfences.mixin.client.accessor.KeyValueConditionAccessor;
import fuzs.diagonalfences.mixin.client.accessor.ModelBakeryAccessor;
import fuzs.diagonalfences.mixin.client.accessor.OrConditionAccessor;
import fuzs.diagonalfences.mixin.client.accessor.SelectorAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.MultiVariant;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.block.model.multipart.AndCondition;
import net.minecraft.client.renderer.block.model.multipart.Condition;
import net.minecraft.client.renderer.block.model.multipart.KeyValueCondition;
import net.minecraft.client.renderer.block.model.multipart.MultiPart;
import net.minecraft.client.renderer.block.model.multipart.OrCondition;
import net.minecraft.client.renderer.block.model.multipart.Selector;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.util.BiConsumer;
import org.jetbrains.annotations.Nullable;

public class MultipartAppender {
    public static void onPrepareModelBaking(ModelBakery modelBakery) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Registry.f_122824_.m_123024_().filter(block -> {
            DiagonalBlock diagonalBlock;
            return (block instanceof FenceBlock || block instanceof IronBarsBlock) && block instanceof DiagonalBlock && (diagonalBlock = (DiagonalBlock)block).hasProperties();
        }).map(block -> (BlockState)block.m_49965_().m_61090_()).forEach(state -> {
            UnbakedModel patt2076$temp = modelBakery.m_119341_((ResourceLocation)BlockModelShaper.m_110895_((BlockState)state));
            if (patt2076$temp instanceof MultiPart) {
                MultiPart multiPart = (MultiPart)patt2076$temp;
                MultipartAppender.appendDiagonalSelectors((BiConsumer<ResourceLocation, UnbakedModel>)((BiConsumer)((ModelBakeryAccessor)modelBakery)::diagonalfences$callCacheAndQueueDependencies), multiPart, state.m_60734_() instanceof IronBarsBlock);
            } else {
                DiagonalFences.LOGGER.warn("Block '{}' is not using multipart models, diagonal connections will not be visible!", (Object)state.m_60734_());
            }
        });
        DiagonalFences.LOGGER.info("Constructing diagonal block models took {} milliseconds", (Object)stopwatch.stop().elapsed().toMillis());
    }

    public static void appendDiagonalSelectors(BiConsumer<ResourceLocation, UnbakedModel> modelBakery, MultiPart multiPart, boolean rotateCenter) {
        List selectors = multiPart.m_111967_();
        ArrayList newSelectors = Lists.newArrayList();
        ListIterator<Selector> iterator = selectors.listIterator();
        while (iterator.hasNext()) {
            Selector selector = (Selector)iterator.next();
            Condition condition = ((SelectorAccessor)selector).diagonalfences$getCondition();
            ConditionFactoryPair conditionFactoryPair = MultipartAppender.findKeyValueCondition(condition, keyValueCondition -> EightWayDirection.byName(((KeyValueConditionAccessor)keyValueCondition).diagonalfences$getKey()) != null);
            if (conditionFactoryPair != null) {
                Condition newCondition;
                EightWayDirection direction = EightWayDirection.byName(((KeyValueConditionAccessor)conditionFactoryPair.condition()).diagonalfences$getKey());
                if (direction == null) continue;
                if (direction.isIntercardinal()) {
                    return;
                }
                if (Objects.equals(((KeyValueConditionAccessor)conditionFactoryPair.condition()).diagonalfences$getValue(), "true")) {
                    newCondition = new KeyValueCondition(direction.rotateClockWise().m_7912_(), "true");
                    MultipartAppender.appendNewSelector(modelBakery, (Condition)conditionFactoryPair.factory().apply(newCondition), selector, direction, newSelectors);
                    continue;
                }
                newCondition = MultipartAppender.negateCondition((Condition)new OrCondition(MultipartAppender.rotateCenterConditions().values()));
                Selector newSelector = new Selector((Condition)new AndCondition((Iterable)Lists.newArrayList((Object[])new Condition[]{condition, newCondition})), selector.m_112020_());
                iterator.set(newSelector);
                Condition otherNewCondition = MultipartAppender.getAndCondition(direction.rotateCounterClockWise(), direction.rotateCounterClockWise().opposite());
                MultipartAppender.appendNewSelector(modelBakery, otherNewCondition, selector, direction.rotateClockWise().rotateClockWise(), newSelectors);
                continue;
            }
            if (!rotateCenter || condition != Condition.f_111922_) continue;
            Map<EightWayDirection, Condition> conditions = MultipartAppender.rotateCenterConditions();
            for (Map.Entry<EightWayDirection, Condition> entry : conditions.entrySet()) {
                MultipartAppender.appendNewSelector(modelBakery, entry.getValue(), selector, entry.getKey(), newSelectors);
            }
            Selector newSelector = new Selector(MultipartAppender.negateCondition((Condition)new OrCondition(conditions.values())), selector.m_112020_());
            iterator.set(newSelector);
        }
        selectors.addAll(newSelectors);
    }

    @Nullable
    private static ConditionFactoryPair findKeyValueCondition(Condition condition, Predicate<KeyValueCondition> filter) {
        block4: {
            block3: {
                if (condition instanceof KeyValueCondition) {
                    KeyValueCondition keyValueCondition = (KeyValueCondition)condition;
                    return filter.test(keyValueCondition) ? new ConditionFactoryPair(keyValueCondition, UnaryOperator.identity()) : null;
                }
                if (!(condition instanceof AndCondition)) break block3;
                ArrayList conditions = Lists.newArrayList(((AndConditionAccessor)condition).diagonalfences$getConditions());
                for (int i = 0; i < conditions.size(); ++i) {
                    ConditionFactoryPair conditionFactoryPair = MultipartAppender.findKeyValueCondition((Condition)conditions.get(i), filter);
                    if (conditionFactoryPair == null) continue;
                    conditions.remove(conditionFactoryPair.condition());
                    return new ConditionFactoryPair(conditionFactoryPair.condition(), condition1 -> {
                        conditions.add((Condition)conditionFactoryPair.factory().apply((Condition)condition1));
                        return new AndCondition((Iterable)conditions);
                    });
                }
                break block4;
            }
            if (!(condition instanceof OrCondition)) break block4;
            ArrayList conditions = Lists.newArrayList(((OrConditionAccessor)condition).diagonalfences$getConditions());
            for (int i = 0; i < conditions.size(); ++i) {
                ConditionFactoryPair conditionFactoryPair = MultipartAppender.findKeyValueCondition((Condition)conditions.get(i), filter);
                if (conditionFactoryPair == null) continue;
                conditions.remove(conditionFactoryPair.condition());
                return new ConditionFactoryPair(conditionFactoryPair.condition(), condition1 -> {
                    conditions.add((Condition)conditionFactoryPair.factory().apply((Condition)condition1));
                    return new OrCondition((Iterable)conditions);
                });
            }
        }
        return null;
    }

    private static Map<EightWayDirection, Condition> rotateCenterConditions() {
        HashMap conditions = Maps.newHashMap();
        for (EightWayDirection direction : EightWayDirection.getCardinalDirections()) {
            if (direction.getX() != 1 && direction.getZ() != 1) continue;
            EightWayDirection interDirection = direction.rotateClockWise();
            Condition newCondition = MultipartAppender.getAndCondition(interDirection, interDirection.opposite());
            conditions.put(direction, newCondition);
        }
        return conditions;
    }

    private static Condition negateCondition(Condition condition) {
        return stateDefinition -> condition.m_7289_(stateDefinition).negate();
    }

    private static Condition getAndCondition(EightWayDirection ... directions) {
        ArrayList conditions = Lists.newArrayList();
        for (EightWayDirection direction : EightWayDirection.values()) {
            String value = ArrayUtils.contains((Object[])directions, (Object)((Object)direction)) ? "true" : "false";
            conditions.add(new KeyValueCondition(direction.m_7912_(), value));
        }
        return new AndCondition((Iterable)conditions);
    }

    private static void appendNewSelector(BiConsumer<ResourceLocation, UnbakedModel> modelBakery, Condition newCondition, Selector selector, EightWayDirection direction, List<Selector> newSelectors) {
        EightWayDirection interDirection = direction.rotateClockWise();
        List variants = selector.m_112020_().m_111848_();
        ArrayList newVariants = Lists.newArrayList();
        for (Variant variant : variants) {
            ModelResourceLocation location = new ModelResourceLocation(variant.m_111883_(), interDirection.m_7912_());
            modelBakery.accept((Object)location, (Object)new RotatedVariant(variant, direction.toDirection()));
            newVariants.add(new Variant((ResourceLocation)location, variant.m_6189_(), variant.m_7538_(), variant.m_111886_()));
        }
        newSelectors.add(new Selector(newCondition, new MultiVariant((List)newVariants)));
    }

    public static BakedModel rotateMultipartSegment(@Nullable BlockState state, BakedModel segmentModel, Direction armDir) {
        HashMap<Direction, List<BakedQuad>> quadMap = new HashMap<Direction, List<BakedQuad>>();
        MultipartAppender.rotateQuads(quadMap, state, segmentModel, null, armDir);
        for (Direction cullFace : Direction.values()) {
            MultipartAppender.rotateQuads(quadMap, state, segmentModel, cullFace, armDir);
        }
        return ClientAbstractions.INSTANCE.createWrappedBakedModel(segmentModel, quadMap);
    }

    private static void rotateQuads(Map<Direction, List<BakedQuad>> quadMap, @Nullable BlockState state, BakedModel segmentModel, Direction cullFace, Direction segmentDir) {
        List quads = segmentModel.m_6840_(state, cullFace, new Random());
        ArrayList newQuads = Lists.newArrayList();
        for (BakedQuad quad : quads) {
            BakedQuad copy = QuadUtils.duplicateQuad(quad);
            QuadUtils.rotateQuad(copy, segmentDir);
            newQuads.add(copy);
        }
        quadMap.put(cullFace, newQuads);
    }

    private record ConditionFactoryPair(KeyValueCondition condition, UnaryOperator<Condition> factory) {
    }
}

