/*
 * Decompiled with CFR 0.152.
 */
package com.kesselot.dragonmeal;

import com.kesselot.dragonmeal.DragonFood;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="dragon_meal")
public class dragonMeal {
    public static final String MODID = "dragon_meal";
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"dragon_meal");
    public static final RegistryObject<Item> DRAGON_FEED = ITEMS.register("dragon_feed", () -> new DragonFood(120, new Item.Properties().m_41491_(CreativeModeTab.f_40755_).m_41487_(64)));
    public static final RegistryObject<Item> DRAGON_FRUIT = ITEMS.register("dragon_fruit", () -> new DragonFood(2400, new Item.Properties().m_41491_(CreativeModeTab.f_40755_).m_41487_(64)));

    public dragonMeal() {
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new DragonInteractionHandler());
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName().equals((Object)new ResourceLocation("minecraft", "blocks/wheat"))) {
            LootTable table = event.getTable();
            LootPool feedPool = LootPool.m_79043_().name("dragon_feed_pool").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)DRAGON_FEED.get()))).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)Blocks.f_50092_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStateProperties.f_61409_, 7))).m_6509_(LootItemRandomChanceCondition.m_81927_((float)0.1f)).m_79082_();
            LootPool fruitPool = LootPool.m_79043_().name("dragon_fruit_pool").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)DRAGON_FRUIT.get()))).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)Blocks.f_50092_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockStateProperties.f_61409_, 7))).m_6509_(LootItemRandomChanceCondition.m_81927_((float)0.01f)).m_79082_();
            table.addPool(feedPool);
            table.addPool(fruitPool);
        }
    }

    private static class DragonInteractionHandler {
        private DragonInteractionHandler() {
        }

        @SubscribeEvent
        public void growDragon(PlayerInteractEvent.EntityInteractSpecific event) {
            if (event.getWorld().m_5776_()) {
                return;
            }
            Player player = event.getPlayer();
            Item usedItem = event.getItemStack().m_41720_();
            if (!(usedItem instanceof DragonFood)) {
                return;
            }
            DragonFood food = (DragonFood)usedItem;
            Entity entity = event.getTarget();
            if (!(entity instanceof AgeableMob)) {
                return;
            }
            AgeableMob ageableMob = (AgeableMob)entity;
            if (!food.acceptableTarget(ageableMob, player)) {
                return;
            }
            ageableMob.m_146758_(food.getGrowthAmount());
            if (!event.getPlayer().m_150110_().f_35937_) {
                event.getItemStack().m_41774_(1);
            }
            event.setCanceled(true);
        }
    }
}

