/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.client;

import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.client.BetterCombatClient;
import net.bettercombat.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.bettercombat.logic.WeaponRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;

public class WeaponAttributeTooltip {
    public static void initialize() {
        ItemTooltipCallback.EVENT.register((itemStack, context, lines) -> {
            WeaponAttributes attributes = WeaponRegistry.getAttributes(itemStack);
            if (attributes != null) {
                int lastAttributeLine = 0;
                int firstHandLine = 0;
                Integer lastGreenAttributeIndex = null;
                String attributePrefix = "attribute.modifier";
                String attributeEqualsPrefix = "attribute.modifier.equals.0";
                String handPrefix = "item.modifiers";
                for (int i = 0; i < lines.size(); ++i) {
                    Component line = (Component)lines.get(i);
                    if (line instanceof TranslatableComponent) {
                        TranslatableComponent translatableText = (TranslatableComponent)line;
                        String key = translatableText.m_131328_();
                        if (key.startsWith(attributePrefix)) {
                            lastAttributeLine = i;
                        }
                        if (firstHandLine != 0 || !key.startsWith(handPrefix)) continue;
                        firstHandLine = i;
                        continue;
                    }
                    for (Component part : line.m_7360_()) {
                        if (!(part instanceof TranslatableComponent)) continue;
                        TranslatableComponent translatableText = (TranslatableComponent)part;
                        if (translatableText.m_131328_().contains(attributeEqualsPrefix)) {
                            lastGreenAttributeIndex = i;
                        }
                        if (!translatableText.m_131328_().startsWith(attributePrefix)) continue;
                        lastAttributeLine = i;
                    }
                }
                if (BetterCombatClient.config.isTooltipAttackRangeEnabled) {
                    int operationId = AttributeModifier.Operation.ADDITION.m_22235_();
                    String rangeTranslationKey = "attribute.name.generic.attack_range";
                    double rangeValue = attributes.attackRange();
                    MutableComponent rangeLine = new TextComponent(" ").m_7220_((Component)new TranslatableComponent("attribute.modifier.equals." + operationId, new Object[]{ItemStack.f_41584_.format(rangeValue), new TranslatableComponent(rangeTranslationKey)})).m_130940_(ChatFormatting.DARK_GREEN);
                    int index = lastGreenAttributeIndex != null ? lastGreenAttributeIndex : lastAttributeLine;
                    lines.add(index + 1, rangeLine);
                }
                if (attributes.isTwoHanded() && firstHandLine > 0) {
                    MutableComponent handLine = new TranslatableComponent("item.modifiers.two_handed").m_130940_(ChatFormatting.GRAY);
                    lines.add(firstHandLine, handLine);
                }
            }
        });
    }
}

