/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.world.gen;

import com.GACMD.isleofberk.config.ModConfigs;
import com.GACMD.isleofberk.config.util.SpawnDataStorage;
import com.GACMD.isleofberk.registery.ModEntities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class ModSpawnRegistration {
    private static final List<SpawnDataStorage> dragonEntries = new ArrayList<SpawnDataStorage>();

    public static void onEntitySpawn(BiomeLoadingEvent event) {
        if (dragonEntries.isEmpty()) {
            for (String string : ModConfigs.spawnConfig.stingerData.get()) {
                ModSpawnRegistration.addToCacheOrSkip((EntityType)ModEntities.STINGER.get(), string);
            }
            for (String string : ModConfigs.spawnConfig.terribleTerrorData.get()) {
                ModSpawnRegistration.addToCacheOrSkip((EntityType)ModEntities.TERRIBLE_TERROR.get(), string);
            }
            for (String string : ModConfigs.spawnConfig.deadlyNadderData.get()) {
                ModSpawnRegistration.addToCacheOrSkip((EntityType)ModEntities.DEADLY_NADDER.get(), string);
            }
            for (String string : ModConfigs.spawnConfig.gronckleData.get()) {
                ModSpawnRegistration.addToCacheOrSkip((EntityType)ModEntities.GRONCKLE.get(), string);
            }
            for (String string : ModConfigs.spawnConfig.zipplebackData.get()) {
                ModSpawnRegistration.addToCacheOrSkip((EntityType)ModEntities.ZIPPLEBACK.get(), string);
            }
            for (String string : ModConfigs.spawnConfig.lightFuryData.get()) {
                ModSpawnRegistration.addToCacheOrSkip((EntityType)ModEntities.LIGHT_FURY.get(), string);
            }
            for (String string : ModConfigs.spawnConfig.nightFuryData.get()) {
                ModSpawnRegistration.addToCacheOrSkip((EntityType)ModEntities.NIGHT_FURY.get(), string);
            }
            for (String string : ModConfigs.spawnConfig.nightFuryData.get()) {
                ModSpawnRegistration.addToCacheOrSkip((EntityType)ModEntities.SKRILL.get(), string);
            }
            for (String string : ModConfigs.spawnConfig.nightmareData.get()) {
                ModSpawnRegistration.addToCacheOrSkip((EntityType)ModEntities.MONSTROUS_NIGHTMARE.get(), string);
            }
            for (String string : ModConfigs.spawnConfig.tripleStrykeData.get()) {
                ModSpawnRegistration.addToCacheOrSkip((EntityType)ModEntities.TRIPLE_STRYKE.get(), string);
            }
            for (String string : ModConfigs.spawnConfig.skrillData.get()) {
                ModSpawnRegistration.addToCacheOrSkip((EntityType)ModEntities.SKRILL.get(), string);
            }
        }
        ModSpawnRegistration.addDragonSpawns(event);
    }

    private static void addDragonSpawns(BiomeLoadingEvent event) {
        dragonEntries.forEach(storage -> {
            if (event.getName() != null && storage.getBiomes().contains(event.getName().toString())) {
                event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(storage.getDragon(), storage.getWeight(), storage.getMinCount(), storage.getMaxCount()));
            }
        });
    }

    private static void addToCacheOrSkip(EntityType<?> dragon, String entry) {
        int maxCount;
        int minCount;
        int weight;
        String trimmed = entry.replaceAll(" ", "");
        String[] array = trimmed.split("\\|");
        if (array.length < 4) {
            System.err.println("Isle of Berk spawn config found less than 4 arguments:");
            System.err.println("Dragon: " + dragon.getRegistryName().m_135815_());
            System.err.println("Entry: " + entry + "\nSkipping...");
            return;
        }
        if (array.length > 4) {
            System.err.println("Isle of Berk spawn config found more than 4 arguments:");
            System.err.println("Dragon: " + dragon.getRegistryName().m_135815_());
            System.err.println("Entry: " + entry + "\nSkipping...");
            return;
        }
        try {
            weight = Integer.parseInt(array[0]);
            minCount = Integer.parseInt(array[1]);
            maxCount = Integer.parseInt(array[2]);
        }
        catch (Exception ignored) {
            System.err.println("Isle of Berk spawn config found a value that isn't an integer:");
            System.err.println("Dragon: " + dragon.getRegistryName().m_135815_());
            System.err.println("Entry: " + entry + "\nSkipping...");
            return;
        }
        if (minCount >= maxCount) {
            System.err.println("Isle of Berk spawn config found Min value that is smaller than Max:");
            System.err.println("Dragon: " + dragon.getRegistryName().m_135815_());
            System.err.println("Entry: " + entry + "\nSkipping...");
            return;
        }
        if (weight <= 0 || minCount <= -1) {
            System.err.println("Isle of Berk spawn config found a value that is smaller than 0:");
            System.err.println("Dragon: " + dragon.getRegistryName().m_135815_());
            System.err.println("Entry: " + entry + "\nSkipping...");
            return;
        }
        for (String biome : array[3].split(",")) {
            if (biome.split(":").length == 2) continue;
            System.err.println("Isle of Berk spawn config found an invalid Biome:");
            System.err.println("Dragon: " + dragon.getRegistryName().m_135815_());
            System.err.println("Biome: " + biome + "\nSkipping...");
            return;
        }
        dragonEntries.add(new SpawnDataStorage(dragon, weight, minCount, maxCount, Arrays.asList(array[3].split(","))));
    }
}

