/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FireCoatParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final int rotation;
    private final boolean isFlipped;

    FireCoatParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pQuadSizeMulitiplier, SpriteSet pSprites) {
        super(pLevel, pX, pY, pZ, 0.0, 0.0, 0.0);
        this.f_107225_ = 10 + this.f_107223_.nextInt(5);
        this.f_107663_ = 0.6f * (1.0f - (float)pQuadSizeMulitiplier * 0.3f);
        this.sprites = pSprites;
        this.m_108335_(pSprites);
        Random random = new Random();
        this.rotation = random.nextInt(4) * 90;
        this.isFlipped = random.nextInt(2) == 0;
        this.f_107226_ = 3.0E-6f;
    }

    public float m_5902_(float pScaleFactor) {
        float f = ((float)this.f_107224_ + pScaleFactor) / (float)this.f_107225_;
        return this.f_107663_ * (1.0f - f * f * 0.9f);
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Quaternion quaternion;
        Vector3f[] cornerVectors = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float posX = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - renderInfo.m_90583_().m_7096_());
        float posY = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - renderInfo.m_90583_().m_7098_());
        float posZ = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - renderInfo.m_90583_().m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternion = renderInfo.m_90591_();
        } else {
            quaternion = new Quaternion(renderInfo.m_90591_());
            quaternion.m_80148_(Vector3f.f_122227_.m_122270_(Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_)));
        }
        if (this.rotation != 0) {
            quaternion.m_80148_(Vector3f.f_122227_.m_122240_((float)this.rotation));
        }
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = cornerVectors[i];
            vector3f.m_122251_(quaternion);
            vector3f.m_122261_(this.m_5902_(partialTicks));
            vector3f.m_122272_(posX, posY, posZ);
        }
        buffer.m_5483_((double)cornerVectors[0].m_122239_(), (double)cornerVectors[0].m_122260_(), (double)cornerVectors[0].m_122269_()).m_7421_(this.isFlipped ? this.m_5970_() : this.m_5952_(), this.m_5950_()).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        buffer.m_5483_((double)cornerVectors[1].m_122239_(), (double)cornerVectors[1].m_122260_(), (double)cornerVectors[1].m_122269_()).m_7421_(this.isFlipped ? this.m_5970_() : this.m_5952_(), this.m_5951_()).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        buffer.m_5483_((double)cornerVectors[2].m_122239_(), (double)cornerVectors[2].m_122260_(), (double)cornerVectors[2].m_122269_()).m_7421_(this.isFlipped ? this.m_5952_() : this.m_5970_(), this.m_5951_()).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        buffer.m_5483_((double)cornerVectors[3].m_122239_(), (double)cornerVectors[3].m_122260_(), (double)cornerVectors[3].m_122269_()).m_7421_(this.isFlipped ? this.m_5952_() : this.m_5970_(), this.m_5950_()).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ < this.f_107225_) {
            this.f_107215_ += (double)(this.f_107223_.nextFloat() / 5000.0f * (float)(this.f_107223_.nextBoolean() ? 1 : -1));
            this.f_107217_ += (double)(this.f_107223_.nextFloat() / 5000.0f * (float)(this.f_107223_.nextBoolean() ? 1 : -1));
            this.f_107216_ -= (double)this.f_107226_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        } else {
            this.m_107274_();
        }
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107432_;
    }

    public static class FireCoatParticleProvider
    implements ParticleProvider<SimpleParticleType> {
        SpriteSet spriteSet;

        public FireCoatParticleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new FireCoatParticle(pLevel, pX, pY, pZ, pXSpeed, this.spriteSet);
        }
    }
}

