/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.network.message;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideable;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class MessageDragonFlapSounds {
    boolean shouldPlayFlapSounds;
    int dragonId;

    public MessageDragonFlapSounds() {
    }

    public MessageDragonFlapSounds(boolean shouldPlayFlapSounds, int dragonId) {
        this.shouldPlayFlapSounds = shouldPlayFlapSounds;
        this.dragonId = dragonId;
    }

    public static void encode(MessageDragonFlapSounds message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.shouldPlayFlapSounds);
        buffer.writeInt(message.dragonId);
    }

    public static MessageDragonFlapSounds decode(FriendlyByteBuf buffer) {
        return new MessageDragonFlapSounds(buffer.readBoolean(), buffer.readInt());
    }

    public static void handle(MessageDragonFlapSounds message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity entity;
            ServerPlayer player = context.getSender();
            if (player != null && (entity = player.f_19853_.m_6815_(message.dragonId)) instanceof ADragonBaseFlyingRideable) {
                ADragonBaseFlyingRideable dragon = (ADragonBaseFlyingRideable)entity;
                dragon.setShouldPlayFlapping(message.shouldPlayFlapSounds);
            }
        });
        context.setPacketHandled(true);
    }
}

