/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.network.message;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.gui.DragonContainerMenu;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class ClientMessageGuiDragon {
    int entityId;

    public ClientMessageGuiDragon(int entityId) {
        this.entityId = entityId;
    }

    public static void encode(ClientMessageGuiDragon message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entityId);
    }

    public static ClientMessageGuiDragon decode(FriendlyByteBuf buffer) {
        return new ClientMessageGuiDragon(buffer.readInt());
    }

    public static void handle(ClientMessageGuiDragon message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        if (player != null) {
            ADragonBase dragon = (ADragonBase)player.f_19853_.m_6815_(message.entityId);
            if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
                context.enqueueWork(() -> {
                    if (dragon != null && !player.f_19853_.m_5776_() && player.m_20159_() && player.m_20202_() instanceof ADragonBase) {
                        final Component dragonName = dragon.m_7755_();
                        final int id = dragon.m_142049_();
                        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new MenuProvider(){

                            @NotNull
                            public Component m_5446_() {
                                return dragonName;
                            }

                            @NotNull
                            public AbstractContainerMenu m_7208_(int i, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
                                return new DragonContainerMenu(i, playerInventory, id);
                            }
                        }, buf -> buf.writeInt(id));
                    }
                });
                context.setPacketHandled(true);
            }
        }
    }
}

