/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.eggs.entity.eggs;

import com.GACMD.isleofberk.config.ModConfigs;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.eggs.entity.base.ADragonEggBase;
import com.GACMD.isleofberk.entity.eggs.entity.base.medium.ADragonMediumEggBase;
import com.GACMD.isleofberk.items.DragonEggItem;
import com.GACMD.isleofberk.registery.ModEntities;
import com.GACMD.isleofberk.registery.ModItems;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib3.core.IAnimatable;

public class GronkleEgg
extends ADragonMediumEggBase
implements IAnimatable {
    public static final ResourceLocation TEXTURE = new ResourceLocation("isleofberk:textures/egg/gronkle/egg_gronk.png");
    private final int hatchTime;

    public GronkleEgg(EntityType<? extends ADragonEggBase> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.hatchTime = ModConfigs.hatchTimeConfig.gronckle.get();
    }

    @Override
    public ResourceLocation getTextureLocation(ADragonEggBase dragonBase) {
        return TEXTURE;
    }

    public boolean m_5829_() {
        return true;
    }

    @Override
    protected ADragonBase getDragonEggResult() {
        return (ADragonBase)((EntityType)ModEntities.GRONCKLE.get()).m_20615_(this.f_19853_);
    }

    @Override
    protected DragonEggItem getItemVersion() {
        return (DragonEggItem)((Object)ModItems.GRONCKLE_EGG.get());
    }

    @Override
    public Block getBlockParticle() {
        return Blocks.f_50377_;
    }

    @Override
    protected void hatch() {
        boolean mobGriefing = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this);
        if (!this.f_19853_.m_5776_()) {
            this.explode((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3.0f, mobGriefing, mobGriefing ? Explosion.BlockInteraction.BREAK : Explosion.BlockInteraction.NONE);
        }
        super.hatch();
    }

    public GronckleExplosion explode(@Nullable Entity pEntity, double pX, double pY, double pZ, float pExplosionRadius, Explosion.BlockInteraction pMode) {
        return this.explode(pEntity, null, null, pX, pY, pZ, pExplosionRadius, false, pMode);
    }

    public GronckleExplosion explode(@Nullable Entity pEntity, double pX, double pY, double pZ, float pExplosionRadius, boolean pCausesFire, Explosion.BlockInteraction pMode) {
        return this.explode(pEntity, null, null, pX, pY, pZ, pExplosionRadius, pCausesFire, pMode);
    }

    public GronckleExplosion explode(@Nullable Entity pExploder, @Nullable DamageSource pDamageSource, @Nullable ExplosionDamageCalculator pContext, double pX, double pY, double pZ, float pSize, boolean pCausesFire, Explosion.BlockInteraction pMode) {
        GronckleExplosion explosion = new GronckleExplosion(this.f_19853_, pExploder, pDamageSource, pContext, pX, pY, pZ, pSize, pCausesFire, pMode);
        if (ForgeEventFactory.onExplosionStart((Level)this.f_19853_, (Explosion)explosion)) {
            return explosion;
        }
        explosion.m_46061_();
        explosion.m_46075_(true);
        return explosion;
    }

    @Override
    protected int getHatchTime() {
        return this.hatchTime;
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ModItems.GRONCKLE_EGG.get());
    }

    private static class GronckleExplosion
    extends Explosion {
        public GronckleExplosion(Level pLevel, @Nullable Entity pSource, @Nullable DamageSource pDamageSource, @Nullable ExplosionDamageCalculator pDamageCalculator, double pToBlowX, double pToBlowY, double pToBlowZ, float pRadius, boolean pFire, Explosion.BlockInteraction pBlockInteraction) {
            super(pLevel, pSource, pDamageSource, pDamageCalculator, pToBlowX, pToBlowY, pToBlowZ, pRadius, pFire, pBlockInteraction);
        }

        public void m_46061_() {
            this.f_46012_.m_142346_(this.f_46016_, GameEvent.f_157812_, new BlockPos(this.f_46013_, this.f_46014_, this.f_46015_));
            HashSet set = Sets.newHashSet();
            int i = 16;
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    block2: for (int l = 0; l < 16; ++l) {
                        if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                        double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                        double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                        double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                        d0 /= d3;
                        d1 /= d3;
                        d2 /= d3;
                        double d4 = this.f_46013_;
                        double d6 = this.f_46014_;
                        double d8 = this.f_46015_;
                        float f1 = 0.3f;
                        for (float f = this.f_46017_ * (0.7f + this.f_46012_.f_46441_.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                            BlockPos blockpos = new BlockPos(d4, d6, d8);
                            BlockState blockstate = this.f_46012_.m_8055_(blockpos);
                            FluidState fluidstate = this.f_46012_.m_6425_(blockpos);
                            if (!this.f_46012_.m_46739_(blockpos)) continue block2;
                            Optional optional = this.f_46019_.m_6617_((Explosion)this, (BlockGetter)this.f_46012_, blockpos, blockstate, fluidstate);
                            if (optional.isPresent()) {
                                f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                            }
                            if (f > 0.0f && this.f_46019_.m_6714_((Explosion)this, (BlockGetter)this.f_46012_, blockpos, blockstate, f)) {
                                set.add(blockpos);
                            }
                            d4 += d0 * (double)0.3f;
                            d6 += d1 * (double)0.3f;
                            d8 += d2 * (double)0.3f;
                        }
                    }
                }
            }
            this.f_46020_.addAll(set);
        }

        public void m_46075_(boolean pSpawnParticles) {
            boolean flag;
            if (this.f_46012_.f_46443_) {
                this.f_46012_.m_7785_(this.f_46013_, this.f_46014_, this.f_46015_, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.f_46012_.f_46441_.nextFloat() - this.f_46012_.f_46441_.nextFloat()) * 0.2f) * 0.7f, false);
            }
            boolean bl = flag = this.f_46010_ != Explosion.BlockInteraction.NONE;
            if (pSpawnParticles) {
                if (!(this.f_46017_ < 2.0f) && flag) {
                    this.f_46012_.m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.f_46013_, this.f_46014_, this.f_46015_, 1.0, 0.0, 0.0);
                } else {
                    this.f_46012_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.f_46013_, this.f_46014_, this.f_46015_, 1.0, 0.0, 0.0);
                }
            }
            if (flag) {
                ObjectArrayList objectarraylist = new ObjectArrayList();
                Collections.shuffle(this.f_46020_, this.f_46012_.f_46441_);
                for (BlockPos blockpos : this.f_46020_) {
                    BlockState blockstate = this.f_46012_.m_8055_(blockpos);
                    Block block = blockstate.m_60734_();
                    if (blockstate.m_60795_()) continue;
                    BlockPos blockpos1 = blockpos.m_7949_();
                    this.f_46012_.m_46473_().m_6180_("explosion_blocks");
                    if (blockstate.canDropFromExplosion((BlockGetter)this.f_46012_, blockpos, (Explosion)this) && this.f_46012_ instanceof ServerLevel) {
                        BlockEntity blockentity = blockstate.m_155947_() ? this.f_46012_.m_7702_(blockpos) : null;
                        LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)this.f_46012_).m_78977_(this.f_46012_.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78984_(LootContextParams.f_81462_, (Object)blockentity).m_78984_(LootContextParams.f_81455_, (Object)this.f_46016_);
                        if (this.f_46010_ == Explosion.BlockInteraction.DESTROY) {
                            lootcontext$builder.m_78972_(LootContextParams.f_81464_, (Object)Float.valueOf(this.f_46017_));
                        }
                        blockstate.m_60724_(lootcontext$builder).forEach(p_46074_ -> GronckleExplosion.m_46067_((ObjectArrayList)objectarraylist, (ItemStack)p_46074_, (BlockPos)blockpos1));
                    }
                    blockstate.onBlockExploded(this.f_46012_, blockpos, (Explosion)this);
                    this.f_46012_.m_46473_().m_7238_();
                }
                for (Pair pair : objectarraylist) {
                    Block.m_49840_((Level)this.f_46012_, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
                }
            }
            if (this.f_46009_) {
                for (BlockPos blockpos2 : this.f_46020_) {
                    List entity = this.f_46012_.m_45971_(ADragonEggBase.class, TargetingConditions.f_26872_, Objects.requireNonNull(this.m_46079_()), new AABB(blockpos2));
                    if (this.f_46011_.nextInt(3) != 0 || !this.f_46012_.m_8055_(blockpos2).m_60795_() || !this.f_46012_.m_8055_(blockpos2.m_7495_()).m_60804_((BlockGetter)this.f_46012_, blockpos2.m_7495_())) continue;
                    this.f_46012_.m_46597_(blockpos2, BaseFireBlock.m_49245_((BlockGetter)this.f_46012_, (BlockPos)blockpos2));
                }
            }
        }
    }
}

