/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.eggs.entity.base;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.items.DragonEggItem;
import com.GACMD.isleofberk.registery.ModEntities;
import com.GACMD.isleofberk.registery.ModItems;
import com.google.common.collect.ImmutableList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class ADragonEggBase
extends AgeableMob
implements IAnimatable {
    private static final EntityDataAccessor<Integer> DRAGON_VARIANT = SynchedEntityData.m_135353_(ADragonEggBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TICK_HATCH_TIME = SynchedEntityData.m_135353_(ADragonEggBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CAN_HATCH = SynchedEntityData.m_135353_(ADragonEggBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected ADragonBase dragonResult;
    public int displayProgressTicks = 0;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    protected boolean canHatch;

    public ADragonEggBase(EntityType<? extends ADragonEggBase> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setTicksToHatch(0);
    }

    public ADragonEggBase(EntityType<? extends ADragonEggBase> pEntityType, Level pLevel, boolean canHatch) {
        this(pEntityType, pLevel);
        this.setCanHatch(canHatch);
        this.setTicksToHatch(0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22277_, 0.5);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @javax.annotation.Nullable SpawnGroupData pSpawnData, @javax.annotation.Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (pReason == MobSpawnType.STRUCTURE) {
            this.setCanHatch(false);
        } else {
            this.setCanHatch(true);
        }
        return pSpawnData;
    }

    public boolean m_142668_() {
        return false;
    }

    public void m_20219_(Vec3 pVec) {
        super.m_20219_(pVec);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DRAGON_VARIANT, (Object)0);
        this.f_19804_.m_135372_(TICK_HATCH_TIME, (Object)0);
        this.f_19804_.m_135372_(CAN_HATCH, (Object)true);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("dragonVariant", this.getDragonVariant());
        pCompound.m_128405_("daysToHatch", this.getTicksToHatch());
        pCompound.m_128379_("canHatch", this.canHatch());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setDragonVariant(pCompound.m_128451_("dragonVariant"));
        this.setTicksToHatch(pCompound.m_128451_("daysToHatch"));
        this.setCanHatch(pCompound.m_128471_("canHatch"));
    }

    public boolean m_6673_(@NotNull DamageSource pSource) {
        if (pSource == DamageSource.f_19305_ || pSource == DamageSource.f_19307_ || pSource == DamageSource.f_19315_ || pSource == DamageSource.f_19308_ || pSource == DamageSource.f_19310_ || pSource == DamageSource.f_19311_ || pSource == DamageSource.f_19316_ || pSource == DamageSource.f_19314_ || pSource == DamageSource.m_19373_((LivingEntity)null)) {
            return true;
        }
        return super.m_6673_(pSource);
    }

    public Iterable<ItemStack> m_6168_() {
        return ImmutableList.of();
    }

    public ItemStack m_6844_(EquipmentSlot pSlot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public int getDragonVariant() {
        return (Integer)this.f_19804_.m_135370_(DRAGON_VARIANT);
    }

    public void setDragonVariant(int dragonVariant) {
        this.f_19804_.m_135381_(DRAGON_VARIANT, (Object)dragonVariant);
    }

    public int getTicksToHatch() {
        return (Integer)this.f_19804_.m_135370_(TICK_HATCH_TIME);
    }

    public void setTicksToHatch(int hatch_time) {
        this.f_19804_.m_135381_(TICK_HATCH_TIME, (Object)hatch_time);
    }

    public boolean canHatch() {
        return (Boolean)this.f_19804_.m_135370_(CAN_HATCH);
    }

    public void setCanHatch(boolean canHatch) {
        this.f_19804_.m_135381_(CAN_HATCH, (Object)canHatch);
    }

    public ResourceLocation getTextureLocation(ADragonEggBase dragonBase) {
        return null;
    }

    public ResourceLocation getModelLocation(ADragonEggBase dragonBase) {
        return null;
    }

    public void registerControllers(AnimationData data) {
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @NotNull
    public InteractionResult m_7111_(Player pPlayer, Vec3 pVec, InteractionHand pHand) {
        InteractionResult ret;
        ItemStack stack = pPlayer.m_21205_();
        if (pPlayer.m_7500_()) {
            if (stack.m_150930_(Items.f_42398_)) {
                this.setCanHatch(!this.canHatch());
                if (!this.f_19853_.m_5776_()) {
                    pPlayer.m_5661_((Component)new TextComponent("canHatch: " + this.canHatch()), false);
                }
            } else {
                this.hatch();
            }
        } else {
            String s = "egg.warm.toHatch";
            String s1 = "egg.cold.toHatch";
            if (!this.isCold()) {
                pPlayer.m_5661_((Component)new TranslatableComponent(s), true);
                if (this.f_19853_.m_5776_()) {
                    this.displayProgressTicks = 100;
                }
            } else {
                pPlayer.m_5661_((Component)new TranslatableComponent(s1), true);
            }
        }
        if ((ret = super.m_6096_(pPlayer, pHand)).m_19077_()) {
            return ret;
        }
        return InteractionResult.SUCCESS;
    }

    protected int getHatchTime() {
        return 100;
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_8023_() {
        return true;
    }

    public boolean isCold() {
        BlockPos pos = new BlockPos(this.m_20185_(), this.m_20186_(), this.m_20189_());
        int i5 = this.f_19853_.m_5518_().m_75814_(LightLayer.BLOCK).m_7768_(pos);
        return i5 < 10;
    }

    protected boolean hatchParameters() {
        return this.getTicksToHatch() >= this.getHatchTime();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.displayProgressTicks > 0) {
            --this.displayProgressTicks;
        }
        if (!this.f_19853_.m_5776_() && this.f_19797_ % 20 == 0) {
            if (!this.isCold() && this.getTicksToHatch() <= this.getHatchTime()) {
                this.setTicksToHatch(this.getTicksToHatch() + 1);
            } else if (this.isCold() && this.getTicksToHatch() > 0) {
                this.setTicksToHatch(this.getTicksToHatch() - 1);
            }
        }
        if (this.hatchParameters()) {
            this.hatch();
        }
    }

    protected void hatch() {
        ADragonBase dragonResult = this.getDragonEggResult();
        assert (dragonResult != null);
        dragonResult.m_146762_(-100000);
        dragonResult.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
        dragonResult.setFoodTameLimiterBar(40);
        dragonResult.setDragonVariant(this.f_19796_.nextInt(dragonResult.getMaxAmountOfVariants()));
        this.f_19853_.m_7967_((Entity)dragonResult);
        this.m_146870_();
        if (this.f_19853_ instanceof ServerLevel) {
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.getBlockParticle().m_49966_()), this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), this.particleEggShellCount(), (double)(this.m_20205_() / 3.0f), (double)(this.m_20206_() / 3.0f), (double)(this.m_20205_() / 3.0f), 0.1);
        }
        if (this.f_19853_.f_46443_) {
            this.f_19853_.m_7785_(this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), SoundEvents.f_12535_, SoundSource.NEUTRAL, 1.0f, 1.0f, false);
        }
    }

    protected int particleEggShellCount() {
        return 55;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!this.m_146910_() && !this.f_19853_.m_5776_()) {
            DragonEggItem item = this.getItemVersion();
            this.m_19998_((ItemLike)item);
            this.m_146870_();
            return true;
        }
        return false;
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6060_() {
        return false;
    }

    protected DragonEggItem getItemVersion() {
        return (DragonEggItem)((Object)ModItems.SPEED_STINGER_EGG.get());
    }

    protected ADragonBase getDragonEggResult() {
        return (ADragonBase)((EntityType)ModEntities.STINGER.get()).m_20615_(this.f_19853_);
    }

    public Block getBlockParticle() {
        return Blocks.f_50080_;
    }

    public float scale() {
        return 1.0f;
    }

    public int getHatchProgress() {
        return (int)Math.floor((float)this.getTicksToHatch() / (float)this.getHatchTime() * 100.0f);
    }
}

