/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.dragons.zippleback;

import com.GACMD.isleofberk.entity.AI.taming.T4DragonPotionRequirement;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideable;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideableBreathUser;
import com.GACMD.isleofberk.entity.eggs.entity.base.ADragonEggBase;
import com.GACMD.isleofberk.entity.eggs.entity.eggs.ZippleBackEgg;
import com.GACMD.isleofberk.entity.projectile.breath_user.poison.ZipBreathProjectile;
import com.GACMD.isleofberk.entity.projectile.breath_user.poison.ZippleBackAOECloud;
import com.GACMD.isleofberk.registery.ModEntities;
import com.GACMD.isleofberk.registery.ModSounds;
import com.GACMD.isleofberk.registery.ModTags;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class ZippleBack
extends ADragonBaseFlyingRideableBreathUser {
    private int ticksUsingSecondAbility;

    private <E extends IAnimatable> PlayState basicMovementController(AnimationEvent<E> event) {
        if (this.isFlying()) {
            if (this.isDragonMoving()) {
                if (this.m_20160_()) {
                    if (this.m_146909_() < 8.0f || this.isGoingUp() || this.m_20197_().size() > 2) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        this.setShouldPlayFlapping(true);
                    }
                    if (this.m_146909_() >= 8.0f && this.m_146909_() < 33.0f && !this.isGoingUp()) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.glide", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        this.setShouldPlayFlapping(false);
                    }
                    if (this.m_146909_() >= 33.0f && !this.isGoingUp()) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.dive", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        this.setShouldPlayFlapping(false);
                    }
                    return PlayState.CONTINUE;
                }
                if (this.isDragonFollowing() && this.m_142480_() != null && this.m_142480_().m_21255_()) {
                    LivingEntity owner = this.m_142480_();
                    float dist = this.m_20270_((Entity)owner);
                    double ydist = this.m_20186_() - owner.m_20186_();
                    if (ydist < 10.0 || dist > 15.0f) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    } else {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.dive", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    }
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    this.setShouldPlayFlapping(true);
                }
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.hover", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                this.setShouldPlayFlapping(true);
            }
        } else {
            if (this.isDragonSitting() && !this.isDragonSleeping()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.sit", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.isDragonSleeping()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.sleep", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.isDragonMoving() && !this.shouldStopMovingIndependently()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState attackController(AnimationEvent<E> event) {
        if (this.getTicksSinceLastAttack() >= 0 && this.getTicksSinceLastAttack() < 12 && this.getCurrentAttackType() == 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.bite_right", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isUsingAbility()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.breath", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState attackControllerLeft(AnimationEvent<E> event) {
        if (this.getTicksSinceLastAttack() >= 0 && this.getTicksSinceLastAttack() < 12 && this.getCurrentAttackType() == 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.bite_left", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isUsingSECONDAbility()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.breath_ignite"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState turnController(AnimationEvent<E> event) {
        int turnState = this.getRotationState();
        if (turnState != 0 && this.m_6688_() instanceof Player) {
            if (this.isFlying()) {
                boolean diving;
                boolean bl = diving = this.m_146909_() >= 32.0f && this.isDragonMoving();
                if (this.isGoingUp() || diving) {
                    event.getController().setAnimationSpeed(4.0);
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.tailrot0", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
                if (turnState == 1) {
                    event.getController().setAnimationSpeed(4.0);
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.lefttailrot1f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
                if (turnState == 2) {
                    event.getController().setAnimationSpeed(4.0);
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.lefttailrot2f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
                if (turnState == -1) {
                    event.getController().setAnimationSpeed(4.0);
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.righttailrot1f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
                if (turnState == -2) {
                    event.getController().setAnimationSpeed(4.0);
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.righttailrot2f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
            } else {
                if (turnState == 1) {
                    event.getController().setAnimationSpeed(4.0);
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.lefttailrot1", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
                if (turnState == 2) {
                    event.getController().setAnimationSpeed(4.0);
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.lefttailrot2", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
                if (turnState == -1) {
                    event.getController().setAnimationSpeed(4.0);
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.righttailrot1", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
                if (turnState == -2) {
                    event.getController().setAnimationSpeed(4.0);
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.righttailrot2", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
            }
        } else {
            event.getController().setAnimationSpeed(4.0);
            event.getController().setAnimation(new AnimationBuilder().addAnimation("zippleback.tailrot0", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "basic_MovementController", (float)this.getTransitionTicks(), this::basicMovementController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attack_Controller", 0.0f, this::attackController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attack_Controller_Left", 0.0f, this::attackControllerLeft));
        data.addAnimationController(new AnimationController((IAnimatable)this, "turnController", 35.0f, this::turnController));
    }

    public ZippleBack(EntityType<? extends ADragonBaseFlyingRideable> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected boolean canCarryCargo() {
        return true;
    }

    @Override
    protected double extraRidersYOffset() {
        return 1.3;
    }

    @Override
    protected int getMaxPassengerCapacity() {
        return 3;
    }

    @Override
    protected double rider1YOffSet() {
        return 1.3;
    }

    @Override
    public float getRideCameraDistanceBack() {
        if (!this.isFlying()) {
            return 5.0f;
        }
        return 12.0f;
    }

    @Override
    public float getRideCameraDistanceFront() {
        if (this.isFlying()) {
            return 7.0f;
        }
        return 4.0f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22279_, (double)0.4f).m_22268_(Attributes.f_22280_, (double)0.14f).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), (double)0.8f);
    }

    @Override
    public Vec3 getThroatPos(ADragonBase entity) {
        Vec3 bodyOrigin = this.m_20182_();
        float angle = (float)((double)((float)Math.PI / 180 * this.f_20883_) + 0.17453292519943295);
        double x = Math.sin(Math.PI + (double)angle) * 6.0;
        double y = 2.0;
        double z = Math.cos(angle) * 6.0;
        float scale = this.m_6162_() ? 0.2f : 1.0f;
        Vec3 throatPos = bodyOrigin.m_82549_(new Vec3(x * (double)scale, y * (double)scale, z * (double)scale));
        return throatPos;
    }

    public Vec3 get2ndHeadThroatPos(ADragonBase entity) {
        Vec3 bodyOrigin = this.m_20182_();
        float angle = (float)((double)((float)Math.PI / 180 * this.f_20883_) - 0.17453292519943295);
        double x = Math.sin(Math.PI + (double)angle) * 4.0;
        double y = 3.8;
        double z = Math.cos(angle) * 4.0;
        float scale = this.m_6162_() ? 0.2f : 1.0f;
        Vec3 throatPos = bodyOrigin.m_82549_(new Vec3(x * (double)scale, y * (double)scale, z * (double)scale));
        return throatPos;
    }

    @javax.annotation.Nullable
    public <T extends ZippleBackAOECloud> T getNearestGasCloud(List<? extends T> pEntities, @javax.annotation.Nullable LivingEntity attacker, double pX, double pY, double pZ) {
        double d0 = -1.0;
        ZippleBackAOECloud t = null;
        for (ZippleBackAOECloud t1 : pEntities) {
            if (!this.test(attacker, t1, 17.0, 3.0, 3.0)) continue;
            double d1 = t1.m_20275_(pX, pY, pZ);
            if (d0 != -1.0 && !(d1 < d0)) continue;
            d0 = d1;
            t = t1;
        }
        return (T)((Object)t);
    }

    public boolean test(@javax.annotation.Nullable LivingEntity pAttacker, ZippleBackAOECloud pTarget, double yRange, double xRange, double zRange) {
        if (pAttacker != null) {
            if (yRange > 0.0 || xRange > 0.0 || zRange > 0.0) {
                double d1 = Math.max(yRange, 1.0);
                double d2 = Math.max(xRange, 1.5);
                double d3 = Math.max(zRange, 1.5);
                double x = this.m_20185_() - pTarget.m_20185_();
                double y = this.m_20186_() - pTarget.m_20186_();
                double z = this.m_20189_() - pTarget.m_20189_();
                if (y > d1 * d1 || y < -2.0) {
                    return false;
                }
                if (x > d2 * d2) {
                    return false;
                }
                if (z > d3 * d3) {
                    return false;
                }
            }
            return this.m_21574_().m_148306_((Entity)pTarget);
        }
        return true;
    }

    @Override
    public void m_8119_() {
        String s1;
        String s;
        super.m_8119_();
        Vec3 t = this.getThroatPos(this);
        Vec3 t1 = this.get2ndHeadThroatPos(this);
        if (this.isUsingSECONDAbility()) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123756_, t1.f_82479_, t1.f_82480_, t1.f_82481_, 1.0, 1.0, 1.0);
            ++this.ticksUsingSecondAbility;
        } else {
            this.ticksUsingSecondAbility = 0;
        }
        if (this.isUsingSECONDAbility()) {
            this.modifySecondaryFuel(-1);
        }
        Object zipCloud = this.getNearestGasCloud(this.f_19853_.m_45976_(ZippleBackAOECloud.class, this.getTargetSearchArea(this.getFollowDistance())), (LivingEntity)this, this.m_20185_(), this.m_20188_(), this.m_20189_());
        if (this.isUsingSECONDAbility() && this.f_19796_.nextInt(7) == 1) {
            this.m_5496_(SoundEvents.f_11942_, 15.0f, 1.0f);
        }
        if (zipCloud != null) {
            if (this.ticksUsingSecondAbility > 2) {
                ((ZippleBackAOECloud)((Object)zipCloud)).m_6469_(DamageSource.f_19305_, 1.0f);
            }
            if (this.m_6688_() == null && !this.m_21824_()) {
                if (this.f_19796_.nextInt(50) == 1) {
                    this.ticksUsingSecondAbility = 4;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123756_, t1.f_82479_, t1.f_82480_, t1.f_82481_, 1.0, 1.0, 1.0);
                } else {
                    this.ticksUsingSecondAbility = 0;
                }
            }
        }
        if (this.m_21124_(MobEffects.f_19614_) != null) {
            this.m_21195_(MobEffects.f_19614_);
        }
        if ((s = ChatFormatting.m_126649_((String)this.m_7755_().getString())) != null && (s.equals("Barf and Belch") || s.equals("barf and belch") || s.equals("Barf & Belch") || s.equals("barf & belch") || s.equals("Barf n Belch") || s.equals("barf n belch"))) {
            this.setDragonVariant(0);
        }
        if ((s1 = ChatFormatting.m_126649_((String)this.m_7755_().getString())) != null && (s1.equals("Kandy and Kane") || s1.equals("kandy and kane") || s1.equals("Kandy & Kane") || s1.equals("kandy & kane") || s1.equals("Kandy n Kane") || s1.equals("kandy n kane"))) {
            this.setDragonVariant(10);
        }
    }

    @Override
    public void firePrimary(Vec3 riderLook, Vec3 throat) {
        if (this.f_19796_.nextInt(3) == 1) {
            ZipBreathProjectile fireProj = new ZipBreathProjectile(this, throat, riderLook, this.f_19853_);
            fireProj.shoot(riderLook, 1.0f, 5.0);
            this.f_19853_.m_7967_((Entity)fireProj);
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @javax.annotation.Nullable SpawnGroupData pSpawnData, @javax.annotation.Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (this.f_19796_.nextInt(10) == 1) {
            this.setDragonVariant(9);
        } else {
            this.setDragonVariant(this.f_19796_.nextInt(this.getMaxAmountOfVariants()));
        }
        return pSpawnData;
    }

    @Override
    public int getMaxFuel() {
        return 60;
    }

    @Override
    public int getMaxAmountOfVariants() {
        return 9;
    }

    @Override
    protected int breathBarRegenSpeed() {
        return 20;
    }

    @Override
    protected int breathBarRegenAmount() {
        return 2;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new T4DragonPotionRequirement(this, 1.0));
    }

    @Override
    @Nullable
    public ADragonEggBase getBreedEggResult(ServerLevel level, @NotNull AgeableMob parent) {
        ZippleBackEgg dragon = (ZippleBackEgg)((EntityType)ModEntities.ZIPPLEBACK_EGG.get()).m_20615_((Level)level);
        return dragon;
    }

    @Override
    protected int getAggressionType() {
        return 2;
    }

    @Override
    protected int getInLoveCoolDownInMCDays() {
        return 4;
    }

    protected SoundEvent m_7515_() {
        if (this.isDragonSleeping()) {
            return (SoundEvent)ModSounds.HIDEOUS_ZIPPLEBACK_SLEEP.get();
        }
        return (SoundEvent)ModSounds.HIDEOUS_ZIPPLEBACK_GROWL.get();
    }

    @Override
    protected SoundEvent getTameSound() {
        return (SoundEvent)ModSounds.HIDEOUS_ZIPPLEBACK_TAME.get();
    }

    @Override
    protected SoundEvent getProjectileSound() {
        return (SoundEvent)ModSounds.HIDEOUS_ZIPPLEBACK_POISON_BREATH.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.HIDEOUS_ZIPPLEBACK_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.HIDEOUS_ZIPPLEBACK_DEATH.get();
    }

    @Override
    protected SoundEvent get1stAttackSound() {
        return (SoundEvent)ModSounds.HIDEOUS_ZIPPLEBACK_BITE.get();
    }

    @Override
    protected boolean isItemStackForTaming(ItemStack stack) {
        return Ingredient.m_204132_(ModTags.Items.ZIPPLEBACK_TAME_FOOD).test(stack);
    }

    @Override
    public boolean isBreedingFood(ItemStack pStack) {
        return Ingredient.m_204132_(ModTags.Items.ZIPPLEBACK_BREED_FOOD).test(pStack);
    }
}

