/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.dragons.triple_stryke;

import com.GACMD.isleofberk.entity.AI.taming.T3DragonWeakenAndFeedTamingGoal;
import com.GACMD.isleofberk.entity.AI.target.DragonMeleeAttackGoal;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideable;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideableProjUser;
import com.GACMD.isleofberk.entity.eggs.entity.base.ADragonEggBase;
import com.GACMD.isleofberk.entity.eggs.entity.eggs.TripleStrykeEgg;
import com.GACMD.isleofberk.entity.projectile.abase.BaseLinearFlightProjectile;
import com.GACMD.isleofberk.particles.ScalableParticleType;
import com.GACMD.isleofberk.registery.ModEntities;
import com.GACMD.isleofberk.registery.ModSounds;
import com.GACMD.isleofberk.registery.ModTags;
import com.GACMD.isleofberk.util.Util;
import com.GACMD.isleofberk.util.math.MathX;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddMobPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.entity.PartEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class TripleStryke
extends ADragonBaseFlyingRideableProjUser {
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    protected int ticksSinceLastBiteAttack = 0;
    protected int ticksSinceLastClawAttack = 0;
    protected int ticksSinceLastStingAttackAI = 0;
    protected int ticksSinceLastStingAttackPlayer = 0;
    protected static final EntityDataAccessor<Integer> TICKS_SINCE_LAST_STING = SynchedEntityData.m_135353_(TripleStryke.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    ADragonBase.DragonPart[] subParts;
    ADragonBase.DragonPart TSStingArea = new ADragonBase.DragonPart(this, "TSStingArea", 1.8f, 1.8f);
    boolean stingAttack;

    private <E extends IAnimatable> PlayState basicMovementController(AnimationEvent<E> event) {
        if (this.isFlying() && !this.isDragonIncapacitated()) {
            if (this.isDragonMoving()) {
                if (this.m_20160_()) {
                    if (this.m_146909_() < 8.0f || this.isGoingUp() || this.m_20197_().size() > 2) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.flap", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        this.setShouldPlayFlapping(true);
                    }
                    if (this.m_146909_() >= 8.0f && this.m_146909_() < 33.0f && !this.isGoingUp()) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.glide", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        this.setShouldPlayFlapping(false);
                    }
                    if (this.m_146909_() >= 33.0f && !this.isGoingUp()) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.dive", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        this.setShouldPlayFlapping(false);
                    }
                    return PlayState.CONTINUE;
                }
                if (this.isDragonFollowing() && this.m_142480_() != null && this.m_142480_().m_21255_()) {
                    LivingEntity owner = this.m_142480_();
                    float dist = this.m_20270_((Entity)owner);
                    double ydist = this.m_20186_() - owner.m_20186_();
                    if (ydist < 10.0 || dist > 15.0f) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.flap", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    } else {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.dive", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    }
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.flap", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    this.setShouldPlayFlapping(true);
                }
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.hover", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                this.setShouldPlayFlapping(true);
            }
        } else {
            if (this.isDragonSitting() && !this.isDragonSleeping() && !this.isDragonIncapacitated()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.sit", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.isDragonSleeping() && !this.isDragonIncapacitated()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.sleep", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.isDragonMoving() && !this.shouldStopMovingIndependently() && !this.isDragonIncapacitated()) {
                if (this.m_5448_() != null && !this.m_5448_().m_21224_() && this.m_20270_((Entity)this.m_5448_()) < 14.0f || this.m_20160_()) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                }
                return PlayState.CONTINUE;
            }
            if (this.isDragonIncapacitated()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.surrender", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState attackController(AnimationEvent<E> event) {
        if (this.getTicksSinceLastAttack() >= 0 && this.getTicksSinceLastAttack() < 12) {
            if (this.getCurrentAttackType() == 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.claw_left"));
                return PlayState.CONTINUE;
            }
            if (this.getCurrentAttackType() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.bite", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
        }
        if (this.isMarkFired()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.breath"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState stingAttackController(AnimationEvent<E> event) {
        if (this.getAbilityDisturbTicks() > 1 && this.isDragonOnGround() && this.getCurrentAttackType() != 2 && this.ticksSinceLastStingAttackPlayer == 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.sting_ready", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.getCurrentAttackType() == 2 && this.m_5448_() != null && this.m_20270_((Entity)this.m_5448_()) < 10.0f) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.bite", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.ticksSinceLastStingAttackPlayer > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.sting", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState turnController(AnimationEvent<E> event) {
        int turnState = this.getRotationState();
        if (turnState != 0 && this.m_6688_() instanceof Player) {
            if (this.isFlying()) {
                boolean diving;
                boolean bl = diving = this.m_146909_() >= 32.0f && this.isDragonMoving();
                if (this.isGoingUp() || diving) {
                    event.getController().setAnimationSpeed(4.0);
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.tailrot0", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
                if (turnState == 1) {
                    event.getController().setAnimationSpeed(4.0);
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.lefttailrot1f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
                if (turnState == 2) {
                    event.getController().setAnimationSpeed(4.0);
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.lefttailrot2f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
                if (turnState == -1) {
                    event.getController().setAnimationSpeed(4.0);
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.righttailrot1f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
                if (turnState == -2) {
                    event.getController().setAnimationSpeed(4.0);
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.righttailrot2f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
            } else {
                if (turnState == 1) {
                    event.getController().setAnimationSpeed(4.0);
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.lefttailrot1", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
                if (turnState == 2) {
                    event.getController().setAnimationSpeed(4.0);
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.lefttailrot2", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
                if (turnState == -1) {
                    event.getController().setAnimationSpeed(4.0);
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.righttailrot1", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
                if (turnState == -2) {
                    event.getController().setAnimationSpeed(4.0);
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.righttailrot2", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
            }
        } else {
            event.getController().setAnimationSpeed(4.0);
            event.getController().setAnimation(new AnimationBuilder().addAnimation("triple_stryke.tailrot0", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "basic_MovementController", (float)this.getTransitionTicks(), this::basicMovementController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attack_Controller", 0.0f, this::attackController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "stingAttackController", 0.0f, this::stingAttackController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "turn_Controller", 35.0f, this::turnController));
    }

    public TripleStryke(EntityType<? extends TripleStryke> entityType, Level level) {
        super((EntityType<? extends ADragonBaseFlyingRideable>)entityType, level);
        this.subParts = new ADragonBase.DragonPart[]{this.TSStingArea};
    }

    public PartEntity<?>[] getParts() {
        return this.subParts;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new T3DragonWeakenAndFeedTamingGoal(this, 1.0));
    }

    public void m_142223_(@NotNull ClientboundAddMobPacket mobPacket) {
        super.m_142223_(mobPacket);
        PartEntity<?>[] part = this.getParts();
        for (int i = 0; i < Objects.requireNonNull(part).length; ++i) {
            part[i].m_20234_(i + mobPacket.m_131552_());
        }
    }

    @NotNull
    public Packet<?> m_5654_() {
        return new ClientboundAddMobPacket((LivingEntity)this);
    }

    private void tickPart(ADragonBase.DragonPart pPart, double pOffsetX, double pOffsetY, double pOffsetZ) {
        Vec3 lastPos = new Vec3(pPart.m_20185_(), pPart.m_20186_(), pPart.m_20189_());
        pPart.m_6034_(this.m_20185_() + pOffsetX, this.m_20186_() + pOffsetY, this.m_20189_() + pOffsetZ);
        pPart.f_19854_ = lastPos.f_82479_;
        pPart.f_19855_ = lastPos.f_82480_;
        pPart.f_19856_ = lastPos.f_82481_;
        pPart.f_19790_ = lastPos.f_82479_;
        pPart.f_19791_ = lastPos.f_82480_;
        pPart.f_19792_ = lastPos.f_82481_;
    }

    public boolean isMultipartEntity() {
        return !this.m_6162_();
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        float yRotRadians = MathX.toRadians(this.m_146908_());
        float sinY = Mth.m_14031_((float)yRotRadians);
        float cosY = Mth.m_14089_((float)yRotRadians);
        this.tickPart(this.TSStingArea, 3.0f * -sinY * 1.0f, 0.4, 3.0f * cosY * 1.0f);
        this.ticksSinceLastStingAttackPlayer = this.isUsingSECONDAbility() && this.getTicksSinceLastSting() == 0 ? 46 : (this.ticksSinceLastStingAttackPlayer > 0 ? --this.ticksSinceLastStingAttackPlayer : 0);
        if (this.ticksSinceLastStingAttackPlayer == 40) {
            this.setTicksSinceLastSting(Util.secondsToTicks(2));
            this.knockBack(this.f_19853_.m_6249_((Entity)this, this.TSStingArea.m_142469_().m_82377_(0.4, 0.4, 0.4).m_82386_(0.0, -0.3, 0.0), EntitySelector.f_20406_));
            if (!this.f_19853_.m_5776_()) {
                this.hurt(this.f_19853_.m_6249_((Entity)this, this.TSStingArea.m_142469_().m_82400_(1.0), EntitySelector.f_20406_));
            }
        }
        if (this.ticksSinceLastStingAttackPlayer == 44) {
            this.m_5496_((SoundEvent)ModSounds.TRIPLE_STRYKE_STING.get(), 5.0f, 1.0f);
        }
    }

    private void knockBack(List<Entity> pEntities) {
        double d0 = (this.TSStingArea.m_142469_().f_82288_ + this.TSStingArea.m_142469_().f_82291_) / 2.0;
        double d1 = (this.TSStingArea.m_142469_().f_82290_ + this.TSStingArea.m_142469_().f_82293_) / 2.0;
        for (Entity entity : pEntities) {
            if (!(entity instanceof LivingEntity) || entity == this.m_20197_() || entity.f_19790_ != entity.m_20185_() && entity.f_19792_ != entity.m_20189_()) continue;
            double d2 = entity.m_20185_() - d0;
            double d3 = entity.m_20189_() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.m_5997_(d2 / d4 * 0.5, (double)0.2f, d3 / d4 * 2.0);
            entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 5.0f);
            this.m_19970_((LivingEntity)this, entity);
        }
    }

    private void hurt(List<Entity> pEntities) {
        for (Entity entity : pEntities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.m_20197_().contains(livingEntity)) continue;
            this.m_5496_(SoundEvents.f_11908_, 3.0f, 1.0f);
            livingEntity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 36.0f);
            this.m_19970_((LivingEntity)this, (Entity)livingEntity);
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, Util.secondsToTicks(20)));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, Util.secondsToTicks(4)));
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TICKS_SINCE_LAST_STING, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("ticksSting", this.getTicksSinceLastSting());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setTicksSinceLastSting(pCompound.m_128451_("ticksSting"));
    }

    public int getTicksSinceLastSting() {
        return (Integer)this.f_19804_.m_135370_(TICKS_SINCE_LAST_STING);
    }

    public void setTicksSinceLastSting(int pType) {
        this.f_19804_.m_135381_(TICKS_SINCE_LAST_STING, (Object)pType);
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return pPose == Pose.SLEEPING ? 0.2f : pSize.f_20378_ * 1.2f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 70.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22279_, (double)0.4f).m_22268_(Attributes.f_22280_, (double)0.1f).m_22268_(Attributes.f_22281_, 6.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), (double)0.55f);
    }

    @Override
    public boolean m_7327_(Entity pEntity) {
        Player player;
        boolean flag;
        int i;
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (float)this.m_21133_(Attributes.f_22282_);
        if (pEntity instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)pEntity).m_6336_());
            f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
            pEntity.m_20254_(i * 4);
        }
        if (flag = pEntity.m_6469_(DamageSource.m_19370_((LivingEntity)this), pEntity instanceof Player && (player = (Player)pEntity).m_21230_() > 0 ? f / 2.0f : f)) {
            if (f1 > 0.0f && pEntity instanceof LivingEntity) {
                ((LivingEntity)pEntity).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            if (pEntity instanceof Player) {
                player = (Player)pEntity;
                this.maybeDisableShield(player, this.m_21205_(), player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_);
            }
            this.m_19970_((LivingEntity)this, pEntity);
            this.m_21335_(pEntity);
        }
        this.playAttackSound();
        return flag;
    }

    @Override
    protected void playAttackSound() {
        if (this.getCurrentAttackType() == 0) {
            this.m_5496_(this.get1stAttackSound(), 3.0f, 1.0f);
        }
        if (this.getCurrentAttackType() == 1) {
            this.m_5496_(this.get2ndAttackSound(), 3.0f, 1.0f);
        }
        if (this.getCurrentAttackType() == 2) {
            this.m_5496_(SoundEvents.f_12344_, 3.0f, 1.0f);
        }
    }

    private void maybeDisableShield(Player pPlayer, ItemStack pMobItemStack, ItemStack pPlayerItemStack) {
        if (!pMobItemStack.m_41619_() && !pPlayerItemStack.m_41619_() && pMobItemStack.m_41720_() instanceof AxeItem && pPlayerItemStack.m_150930_(Items.f_42740_)) {
            float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
            if (this.f_19796_.nextFloat() < f) {
                pPlayer.m_36335_().m_41524_(Items.f_42740_, 100);
                this.f_19853_.m_7605_((Entity)pPlayer, (byte)30);
            }
        }
    }

    @Override
    public DragonMeleeAttackGoal getMeleeAttackGoal() {
        return new TripleStrykeCustomMeleeAttackGoal(this, 1.0, false);
    }

    @Override
    public float getRideCameraDistanceFront() {
        return 6.0f;
    }

    @Override
    public float getRideCameraDistanceVert() {
        return 1.3f;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @javax.annotation.Nullable SpawnGroupData pSpawnData, @javax.annotation.Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (this.f_19796_.nextInt(1000) == 1) {
            this.setDragonVariant(9);
        } else if (this.f_19796_.nextInt(50) == 1) {
            this.setDragonVariant(8);
        } else if (this.f_19796_.nextInt(50) == 1) {
            this.setDragonVariant(7);
        } else if (this.f_19796_.nextInt(50) == 1) {
            this.setDragonVariant(6);
        } else if (this.f_19796_.nextInt(50) == 1) {
            this.setDragonVariant(5);
        } else {
            this.setDragonVariant(this.f_19796_.nextInt(this.getMaxAmountOfVariants()));
        }
        return pSpawnData;
    }

    @Override
    public int getMaxAmountOfVariants() {
        return 6;
    }

    @Override
    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    protected int getAggressionType() {
        return 3;
    }

    @Override
    public void m_6674_(InteractionHand pHand) {
        Random random = new Random();
        int random1 = random.nextInt(300);
        if (random1 > 1) {
            this.ticksSinceLastBiteAttack = Util.secondsToTicks(3);
            this.ticksSinceLastStingAttackAI = 0;
            this.ticksSinceLastClawAttack = 0;
        }
        if (random1 > 120) {
            this.ticksSinceLastStingAttackAI = Util.secondsToTicks(3);
            this.ticksSinceLastClawAttack = 0;
            this.ticksSinceLastBiteAttack = 0;
        }
        if (random1 > 210) {
            this.ticksSinceLastClawAttack = Util.secondsToTicks(3);
            this.ticksSinceLastStingAttackAI = 0;
            this.ticksSinceLastBiteAttack = 0;
        }
        super.m_6674_(pHand);
    }

    private void playerStingAttack() {
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.ticksSinceLastBiteAttack >= 0) {
            --this.ticksSinceLastBiteAttack;
        }
        if (this.ticksSinceLastClawAttack >= 0) {
            --this.ticksSinceLastClawAttack;
        }
        if (this.ticksSinceLastStingAttackAI >= 0) {
            --this.ticksSinceLastStingAttackAI;
        }
        if (this.ticksSinceLastStingAttackPlayer > 0) {
            --this.ticksSinceLastStingAttackPlayer;
        }
        if (this.getTicksSinceLastSting() > 0) {
            this.setTicksSinceLastSting(this.getTicksSinceLastSting() - 1);
        }
        if (this.ticksSinceLastClawAttack >= 0) {
            this.setCurrentAttackType(0);
        } else if (this.ticksSinceLastBiteAttack >= 0) {
            this.setCurrentAttackType(1);
        } else if (this.ticksSinceLastStingAttackAI >= 0) {
            this.setCurrentAttackType(2);
        }
        if (this.m_21023_(MobEffects.f_19614_)) {
            this.m_21195_(MobEffects.f_19614_);
        }
        if (this.tier1()) {
            this.setProjsSize(0);
            this.setExplosionStrength(0);
        } else if (this.tier2()) {
            this.setProjsSize(1);
            this.setExplosionStrength(1);
        } else if (this.tier3()) {
            this.setProjsSize(2);
            this.setExplosionStrength(2);
        } else if (this.tier4()) {
            this.setProjsSize(3);
            this.setExplosionStrength(3);
        }
        this.performInCapacitate();
    }

    @Override
    public float getProjectileDamage(ADragonBase dragon, Entity entity, BaseLinearFlightProjectile projectile) {
        if (projectile.getDamageTier() == 1) {
            float f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = (float)Math.floor(livingEntity.m_21233_() * 0.1f);
            } else {
                f = 0.0f;
            }
            return 10.0f + f;
        }
        if (projectile.getDamageTier() == 2) {
            float f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = (float)Math.floor(livingEntity.m_21233_() * 0.1f);
            } else {
                f = 0.0f;
            }
            return 12.0f + f;
        }
        if (projectile.getDamageTier() == 3) {
            float f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = (float)Math.floor(livingEntity.m_21233_() * 0.1f);
            } else {
                f = 0.0f;
            }
            return 14.0f + f;
        }
        if (projectile.getDamageTier() == 4) {
            float f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = (float)Math.floor(livingEntity.m_21233_() * 0.1f);
            } else {
                f = 0.0f;
            }
            return 16.0f + f;
        }
        return 10.0f;
    }

    @Override
    public boolean tier1() {
        return (double)this.getPlayerBoltBlastPendingScale() >= (double)this.getMaxPlayerBoltBlast() * 0.2 && (double)this.getPlayerBoltBlastPendingScale() < (double)this.getMaxPlayerBoltBlast() * 0.5;
    }

    @Override
    public boolean tier2() {
        return (double)this.getPlayerBoltBlastPendingScale() >= (double)this.getMaxPlayerBoltBlast() * 0.5 && (double)this.getPlayerBoltBlastPendingScale() < (double)this.getMaxPlayerBoltBlast() * 0.75;
    }

    @Override
    public boolean tier3() {
        return (double)this.getPlayerBoltBlastPendingScale() >= (double)this.getMaxPlayerBoltBlast() * 0.75 && (double)this.getPlayerBoltBlastPendingScale() < (double)this.getMaxPlayerBoltBlast() * 0.92;
    }

    @Override
    public boolean tier4() {
        return (double)this.getPlayerBoltBlastPendingScale() >= (double)this.getMaxPlayerBoltBlast() * 0.92;
    }

    @Override
    protected boolean isItemStackForTaming(ItemStack stack) {
        return Ingredient.m_204132_(ModTags.Items.TRIPLE_STRYKE_TAME_FOOD).test(stack);
    }

    @Override
    public boolean isBreedingFood(ItemStack pStack) {
        return Ingredient.m_204132_(ModTags.Items.TRIPLE_STRYKE_BREED_FOOD).test(pStack);
    }

    @Override
    @Nullable
    public ADragonEggBase getBreedEggResult(ServerLevel level, @NotNull AgeableMob parent) {
        TripleStrykeEgg dragon = (TripleStrykeEgg)((EntityType)ModEntities.TRIPLE_STRYKE_EGG.get()).m_20615_((Level)level);
        return dragon;
    }

    @Override
    protected boolean canCarryCargo() {
        return true;
    }

    @Override
    protected double rider1YOffSet() {
        return 1.55;
    }

    @Override
    protected double extraRidersYOffset() {
        return 1.8;
    }

    public void scaleParticleSize(ScalableParticleType scalableParticleType, BaseLinearFlightProjectile projectile) {
        int scale = 0;
        if (projectile.getDamageTier() == 1) {
            scale = (int)((float)scale + 0.55f);
        } else if (projectile.getDamageTier() == 2) {
            scale = (int)((float)scale + 0.65f);
        } else if (projectile.getDamageTier() == 3) {
            scale = (int)((float)scale + 0.75f);
        } else if (projectile.getDamageTier() == 4) {
            scale = (int)((float)scale + 0.95f);
        }
        scalableParticleType.setScale(scale);
    }

    @Override
    public int getMaxPlayerBoltBlast() {
        return 82;
    }

    @Override
    protected int getInLoveCoolDownInMCDays() {
        return 3;
    }

    @Override
    protected SoundEvent getProjectileSound() {
        return (SoundEvent)ModSounds.GRONCKLE_FIRE.get();
    }

    protected SoundEvent m_7515_() {
        if (this.isDragonSleeping()) {
            return (SoundEvent)ModSounds.STINGER_SLEEP.get();
        }
        return (SoundEvent)ModSounds.STINGER_GROWL.get();
    }

    @Override
    protected SoundEvent getTameSound() {
        return (SoundEvent)ModSounds.STINGER_TAME.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.STINGER_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.STINGER_DEATH.get();
    }

    @Override
    protected SoundEvent get1stAttackSound() {
        return (SoundEvent)ModSounds.DEADLY_NADDER_BITE.get();
    }

    @Override
    protected int getMaxPassengerCapacity() {
        return 3;
    }

    public static class TripleStrykeCustomMeleeAttackGoal
    extends DragonMeleeAttackGoal {
        TripleStryke dragon;

        public TripleStrykeCustomMeleeAttackGoal(TripleStryke pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.dragon = pMob;
        }

        @Override
        protected void checkAndPerformAttack(LivingEntity pEnemy, double pDistToEnemySqr) {
            super.checkAndPerformAttack(pEnemy, pDistToEnemySqr);
            if (this.dragon.getCurrentAttackType() == 2 && this.dragon.m_5448_() != null && this.dragon.m_5448_().m_20096_() && this.dragon.m_20270_((Entity)this.dragon.m_5448_()) < 5.0f) {
                this.playParticles();
                AreaEffectCloud areaEffectCloud = new AreaEffectCloud(this.dragon.f_19853_, pEnemy.m_20185_(), pEnemy.m_20186_(), pEnemy.m_20189_());
                this.dragon.f_19853_.m_7967_((Entity)areaEffectCloud);
                if (this.dragon != null) {
                    areaEffectCloud.m_19718_((LivingEntity)this.dragon);
                }
                areaEffectCloud.m_19722_(Potions.f_43584_);
                areaEffectCloud.m_19716_(new MobEffectInstance(MobEffects.f_19614_, Util.secondsToTicks(4)));
                areaEffectCloud.m_19712_(1.5f);
                areaEffectCloud.m_19732_(-0.5f);
                areaEffectCloud.m_19740_(10);
                areaEffectCloud.m_19738_(-areaEffectCloud.m_19743_() / (float)areaEffectCloud.m_19748_());
            }
        }

        public float getColorR(int color) {
            return (float)(color >> 16 & 0xFF) / 255.0f;
        }

        public float getColorG(int color) {
            return (float)(color >> 8 & 0xFF) / 255.0f;
        }

        public float getColorB(int color) {
            return (float)(color & 0xFF) / 255.0f;
        }

        public void playParticles() {
            int colorGreen = 5147438;
            for (int i = 0; i < 1; ++i) {
                Vec3 vec3 = this.dragon.m_20184_();
                double deltaX = vec3.f_82479_;
                double deltaY = vec3.f_82480_;
                double deltaZ = vec3.f_82481_;
                double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 6.0);
                for (double j = 0.0; j < dist; j += 1.0) {
                    SimpleParticleType particleOptions;
                    LevelRenderer levelRenderer;
                    Particle particle;
                    double coeff = j / dist;
                    if (!this.dragon.f_19853_.m_5776_() || (particle = (levelRenderer = Minecraft.m_91087_().f_91060_).m_109795_((ParticleOptions)(particleOptions = ParticleTypes.f_123751_), particleOptions.m_6012_().m_123742_(), this.dragon.f_19854_ + deltaX * coeff, this.dragon.f_19855_ + deltaY * coeff + 3.0, this.dragon.f_19856_ + deltaZ * coeff, (double)(0.0525f * (this.dragon.f_19796_.nextFloat() - 0.5f)), (double)(0.0525f * (this.dragon.f_19796_.nextFloat() - 0.5f)), (double)(0.0525f * (this.dragon.f_19796_.nextFloat() - 0.5f)))) == null) continue;
                    double d23 = this.dragon.f_19796_.nextDouble() * 4.0;
                    particle.m_107253_(this.getColorR(colorGreen), this.getColorG(colorGreen), this.getColorB(colorGreen));
                    particle.m_107268_((float)d23);
                }
            }
        }
    }
}

