/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.dragons.terrible_terror;

import com.GACMD.isleofberk.entity.AI.breed.DragonBreedGoal;
import com.GACMD.isleofberk.entity.AI.flight.own.AIDragonLand;
import com.GACMD.isleofberk.entity.AI.flight.own.DragonFlyAndAttackAirbourneTargetGoal;
import com.GACMD.isleofberk.entity.AI.flight.player.DragonFollowPlayerFlying;
import com.GACMD.isleofberk.entity.AI.goal.IOBLookAtPlayerGoal;
import com.GACMD.isleofberk.entity.AI.ground.DragonWaterAvoidingRandomStrollGoal;
import com.GACMD.isleofberk.entity.AI.target.DragonHurtByTargetGoal;
import com.GACMD.isleofberk.entity.AI.target.DragonOwnerHurtTargetGoal;
import com.GACMD.isleofberk.entity.AI.water.DragonFloatGoal;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideable;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideableBreathUser;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideableProjUser;
import com.GACMD.isleofberk.entity.eggs.entity.base.ADragonEggBase;
import com.GACMD.isleofberk.entity.eggs.entity.eggs.TerribleTerrorEgg;
import com.GACMD.isleofberk.entity.projectile.abase.BaseLinearFlightProjectile;
import com.GACMD.isleofberk.entity.projectile.breath_user.firebreaths.FireBreathSmallProjectile;
import com.GACMD.isleofberk.network.ControlNetwork;
import com.GACMD.isleofberk.network.message.ControlMessageJumping;
import com.GACMD.isleofberk.network.message.ControlMessageSECONDAbility;
import com.GACMD.isleofberk.network.message.ControlMessageTerribleTerrorAbility;
import com.GACMD.isleofberk.network.message.DragonRideMessage;
import com.GACMD.isleofberk.registery.ModEntities;
import com.GACMD.isleofberk.registery.ModKeyBinds;
import com.GACMD.isleofberk.registery.ModSounds;
import com.GACMD.isleofberk.registery.ModTags;
import com.GACMD.isleofberk.util.Util;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class TerribleTerror
extends ADragonBaseFlyingRideableBreathUser
implements IAnimatable,
NeutralMob {
    private int ticksSinceEaten;
    protected static final EntityDataAccessor<Optional<UUID>> LAST_PLAYER_MOUNTED = SynchedEntityData.m_135353_(TerribleTerror.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final Ingredient TEMPT_INGREDIENT = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42526_, Items.f_42527_, Items.f_42581_, Items.f_42485_, Items.f_42579_, Items.f_42658_});
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(TerribleTerror.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    @Nullable
    private UUID persistentAngerTarget;
    public static final Predicate<LivingEntity> PREY_SELECTOR = p_30437_ -> {
        EntityType entitytype = p_30437_.m_6095_();
        return entitytype == EntityType.f_20489_ || entitytype == EntityType.f_20516_ || entitytype == EntityType.f_20556_ || entitytype == EntityType.f_20519_ || entitytype == EntityType.f_20517_ || entitytype == EntityType.f_20555_;
    };
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    static final Predicate<ItemEntity> ALLOWED_ITEMS = stack -> !stack.m_32063_() && stack.m_6084_();

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_20159_()) {
            Entity vehicle = this.m_20202_();
            if (vehicle instanceof Player) {
                Player player = (Player)vehicle;
                if (player.m_20096_() || player.m_20069_() || player.m_20077_()) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("PlayerHeadIdle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
                if (player.m_21255_()) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("Flap", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
                if (!player.m_20096_()) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("PlayerHeadFlying", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    return PlayState.CONTINUE;
                }
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("Sit", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
        }
        if (this.isFlying() && !this.isDragonMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("Hover", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isDragonMoving() && !this.shouldStopMovingIndependently()) {
            if (!this.isDragonOnGround()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("Flap", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.shouldPlayFlapping()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("Hover", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (!this.isDragonSitting()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("Walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
        }
        if (this.isDragonSitting() && !this.isDragonSleeping()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("Sit", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isDragonSleeping()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("Sleep", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("Idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState attackController(AnimationEvent<E> event) {
        if (this.getTicksSinceLastAttack() >= 0 && this.getTicksSinceLastAttack() < 12 && this.getCurrentAttackType() == 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("HeadBite", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isUsingAbility()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("HeadBreath"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public TerribleTerror(EntityType<? extends TerribleTerror> animal, Level world) {
        super((EntityType<? extends ADragonBaseFlyingRideable>)animal, world);
        this.m_21553_(true);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LAST_PLAYER_MOUNTED, Optional.empty());
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128403_("last_mount")) {
            UUID uuid = pCompound.m_128342_("last_mount");
            this.setLastMountedPlayerUUID(uuid);
        }
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.getLastMountedPlayerUUID() != null) {
            pCompound.m_128362_("last_mount", this.getLastMountedPlayerUUID());
        }
    }

    @Override
    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "terrible_terror_controller", (float)this.getTransitionTicks(), this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attack_Controller", 0.0f, this::attackController));
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        this.setDragonVariant(this.m_21187_().nextInt(this.getMaxAmountOfVariants()));
        return pSpawnData;
    }

    @Override
    public int getMaxAmountOfVariants() {
        return 8;
    }

    @Nullable
    public UUID getLastMountedPlayerUUID() {
        return ((Optional)this.f_19804_.m_135370_(LAST_PLAYER_MOUNTED)).orElse(null);
    }

    public void setLastMountedPlayerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(LAST_PLAYER_MOUNTED, Optional.ofNullable(uuid));
    }

    @Override
    public boolean canBeMounted() {
        return false;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new DragonFollowPlayerFlying(this, 2, 2, 2));
        this.f_21345_.m_25352_(0, (Goal)new DragonFlyAndAttackAirbourneTargetGoal(this, 1.0, true));
        this.f_21345_.m_25352_(0, (Goal)new DragonBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new DragonFloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AIDragonLand(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new DragonWaterAvoidingRandomStrollGoal(this, 0.7, 1.0000001E-5f));
        this.f_21345_.m_25352_(7, (Goal)new IOBLookAtPlayerGoal(this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21346_.m_25352_(2, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, LivingEntity.class, false, PREY_SELECTOR));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(1, (Goal)new DragonHurtByTargetGoal(this, new Class[0]).setAlertOthers(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((TerribleTerror)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(2, (Goal)new DragonOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal(this, (Mob)this, true));
        this.f_21345_.m_25352_(11, (Goal)new TerrorFeedOnGroundGoal(this));
    }

    @Override
    protected boolean isItemStackForTaming(ItemStack stack) {
        return Ingredient.m_204132_(ModTags.Items.TERRIBLE_TERROR_TAME_FOOD).test(stack);
    }

    @Override
    public boolean isFoodEdibleToDragon(ItemStack pStack) {
        return super.isFoodEdibleToDragon(pStack);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22277_, 12.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 4.0).m_22268_(Attributes.f_22280_, (double)0.04f).m_22268_(Attributes.f_22281_, 2.0);
    }

    @Override
    public boolean isBreedingFood(ItemStack pStack) {
        return Ingredient.m_204132_(ModTags.Items.TERRIBLE_TERROR_BREED_FOOD).test(pStack);
    }

    @Override
    public boolean m_7327_(@NotNull Entity pEntity) {
        float f;
        Player player;
        int i;
        float f2 = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (float)this.m_21133_(Attributes.f_22282_);
        if (pEntity instanceof LivingEntity) {
            f2 += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)pEntity).m_6336_());
            f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
            pEntity.m_20254_(i * 4);
        }
        DamageSource damageSource = DamageSource.m_19370_((LivingEntity)this);
        if (pEntity instanceof Player) {
            player = (Player)pEntity;
            f = f2 / 2.0f;
        } else {
            f = f2;
        }
        boolean flag = pEntity.m_6469_(damageSource, f);
        if (flag) {
            if (f1 > 0.0f && pEntity instanceof LivingEntity) {
                ((LivingEntity)pEntity).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            if (pEntity instanceof Player) {
                player = (Player)pEntity;
                this.maybeDisableShield(player, this.m_21205_(), player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_);
            }
            this.m_19970_((LivingEntity)this, pEntity);
            this.m_21335_(pEntity);
        }
        this.playAttackSound();
        return flag;
    }

    private void maybeDisableShield(Player pPlayer, ItemStack pMobItemStack, ItemStack pPlayerItemStack) {
        if (!pMobItemStack.m_41619_() && !pPlayerItemStack.m_41619_() && pMobItemStack.m_41720_() instanceof AxeItem && pPlayerItemStack.m_150930_(Items.f_42740_)) {
            float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
            if (this.f_19796_.nextFloat() < f) {
                pPlayer.m_36335_().m_41524_(Items.f_42740_, 100);
                this.f_19853_.m_7605_((Entity)pPlayer, (byte)30);
            }
        }
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        if (this.isBreedingFood(itemstack) && !this.shouldStopMovingIndependently()) {
            if (this.m_21830_((LivingEntity)pPlayer)) {
                int i = this.m_146764_();
                if (!this.f_19853_.f_46443_ && i == 0 && this.m_5957_()) {
                    this.m_142075_(pPlayer, pHand, itemstack);
                    this.m_27595_(pPlayer);
                    this.m_146859_(GameEvent.f_157771_, this.m_146901_());
                    return InteractionResult.SUCCESS;
                }
            } else {
                String string = "iob.only.owner.breed";
                pPlayer.m_5661_((Component)new TranslatableComponent(string), false);
                return InteractionResult.FAIL;
            }
        }
        if (item.m_41472_() && !this.isBreedingFood(itemstack)) {
            ItemStack stack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (stack.m_41619_()) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)item));
                itemstack.m_41774_(1);
            }
            if (!this.m_21824_()) {
                if (this.isItemStackForTaming(itemstack) && this.f_19796_.nextInt(8) == 1) {
                    this.tameWithName(pPlayer);
                    this.f_19853_.m_7605_((Entity)this, (byte)7);
                    itemstack.m_41774_(1);
                } else {
                    this.f_19853_.m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.isCommandItems(itemstack) && !this.m_6162_() && this.m_21830_((LivingEntity)pPlayer) && !this.isItemStackForTaming(itemstack) && !this.isBreedingFood(itemstack) && this.isDragonFollowing()) {
            this.ridePlayer(pPlayer);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob parent) {
        TerribleTerror dragon = (TerribleTerror)((EntityType)ModEntities.TERRIBLE_TERROR.get()).m_20615_((Level)level);
        return dragon;
    }

    @Override
    protected int getInLoveCoolDownInMCDays() {
        return 1;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateClientControls() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92089_.m_90857_()) {
            ControlNetwork.INSTANCE.sendToServer((Object)new ControlMessageJumping(true, this.m_142049_()));
        } else {
            ControlNetwork.INSTANCE.sendToServer((Object)new ControlMessageJumping(false, this.m_142049_()));
        }
        if (ModKeyBinds.keyAbilty.m_90857_()) {
            ControlNetwork.INSTANCE.sendToServer((Object)new ControlMessageTerribleTerrorAbility(true, this.m_142049_()));
        } else {
            ControlNetwork.INSTANCE.sendToServer((Object)new ControlMessageTerribleTerrorAbility(false, this.m_142049_()));
        }
        if (ModKeyBinds.keySecondAbilty.m_90857_()) {
            ControlNetwork.INSTANCE.sendToServer((Object)new ControlMessageSECONDAbility(true, this.m_142049_()));
        } else {
            ControlNetwork.INSTANCE.sendToServer((Object)new ControlMessageSECONDAbility(false, this.m_142049_()));
        }
    }

    @Override
    protected void foodTamingInteraction(Player pPlayer, InteractionHand pHand, ItemStack itemstack) {
        if (!pPlayer.m_150110_().f_35937_) {
            itemstack.m_41774_(1);
        }
        Item forgeItem = itemstack.m_41720_();
        int nutrition = 6;
        this.m_5634_(nutrition);
    }

    protected void ridePlayer(Player player) {
        if (player.m_20197_().size() < 3) {
            this.m_7998_((Entity)player, true);
            if (!this.f_19853_.m_5776_()) {
                ControlNetwork.INSTANCE.sendToServer((Object)new DragonRideMessage(this.m_142049_(), true));
            }
        }
    }

    public boolean m_7998_(@NotNull Entity pEntity, boolean pForce) {
        this.setSleepDisturbTicks(Util.secondsToTicks(20));
        return super.m_7998_(pEntity, pForce);
    }

    public void m_6083_() {
        Entity entity = this.m_20202_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.m_20159_() && !player.m_6084_()) {
                this.m_8127_();
                if (this.f_19853_.m_5776_()) {
                    ControlNetwork.INSTANCE.sendToServer((Object)new DragonRideMessage(this.m_142049_(), false));
                }
            } else {
                this.m_20334_(0.0, 0.0, 0.0);
                this.m_8119_();
                this.updateTerrorLatch((Entity)player);
            }
        } else {
            super.m_6083_();
        }
    }

    public void updateTerrorLatch(Entity vehicle) {
        if (vehicle instanceof Player) {
            Player player = (Player)vehicle;
            int passengerIndex = vehicle.m_20197_().indexOf((Object)this);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, Util.secondsToTicks(30), passengerIndex, false, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, Util.secondsToTicks(30), passengerIndex, false, false));
            if (passengerIndex > 0) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, Util.secondsToTicks(30), Mth.m_14045_((int)passengerIndex, (int)0, (int)1), false, false));
            }
            Vec3 vehiclePosition = player.m_20182_();
            if (passengerIndex == 0) {
                float radius = -0.2f;
                double offsetX = (double)radius * -Math.sin((double)player.f_20883_ * Math.PI / 180.0);
                double offsetZ = (double)radius * Math.cos((double)player.f_20883_ * Math.PI / 180.0);
                double offsetY = 1.7;
                this.m_6034_(vehiclePosition.f_82479_ + offsetX, vehiclePosition.f_82480_ + offsetY, vehiclePosition.f_82481_ + offsetZ);
            } else if (passengerIndex == 1) {
                float radius = 0.4f;
                float angle = (float)Math.PI / 180 * ((Player)vehicle).f_20883_ - 90.0f;
                double offsetX = (double)radius * Math.sin(Math.PI + (double)angle);
                double offsetZ = (double)radius * Math.cos(angle);
                double offsetY = 1.2;
                this.m_6034_(vehiclePosition.f_82479_ + offsetX, vehiclePosition.f_82480_ + offsetY, vehiclePosition.f_82481_ + offsetZ);
            } else if (passengerIndex == 2) {
                float radius = 0.4f;
                float angle = (float)Math.PI / 180 * ((Player)vehicle).f_20883_ + 90.0f;
                double offsetX = (double)radius * Math.sin(Math.PI + (double)angle);
                double offsetZ = (double)radius * Math.cos(angle);
                double offsetY = 1.2;
                this.m_6034_(vehiclePosition.f_82479_ + offsetX, vehiclePosition.f_82480_ + offsetY, vehiclePosition.f_82481_ + offsetZ);
            }
            if (player.m_20159_() && !player.m_21255_()) {
                player.m_5618_(player.m_6080_());
            }
            this.m_146922_(player.m_146908_());
            this.f_20885_ = this.f_20883_ = player.f_20883_;
            if (player.m_6144_() && player.m_20096_() && player.m_20202_() == null || this.m_21224_() || this.m_146910_() || player.m_21224_() || player.m_146910_() || player.m_5842_() || player.m_6067_() || player.m_20143_()) {
                this.setLastMountedPlayerUUID(null);
                this.m_8127_();
                player.m_21195_(MobEffects.f_19591_);
                player.m_21195_(MobEffects.f_19603_);
                player.m_21195_(MobEffects.f_19596_);
                if (this.f_19853_.m_5776_()) {
                    ControlNetwork.INSTANCE.sendToServer((Object)new DragonRideMessage(this.m_142049_(), false));
                }
            }
            if (player.m_21255_()) {
                player.m_21195_(MobEffects.f_19591_);
                player.m_21195_(MobEffects.f_19603_);
                player.m_21195_(MobEffects.f_19596_);
            }
        }
    }

    public boolean isPlayerOnGround(Player player) {
        for (int i = 0; i < 1; ++i) {
            BlockPos solidPos = new BlockPos(player.m_20182_().f_82479_, player.m_20182_().f_82480_ - (double)i, player.m_20182_().f_82481_);
            if (this.f_19853_.m_8055_(solidPos).m_60795_()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean canUseBreathNormally() {
        return false;
    }

    @Override
    public Vec3 getThroatPos(ADragonBase entity) {
        Vec3 bodyOrigin = this.m_20182_();
        double x = -Math.sin((double)this.f_20883_ * Math.PI / 180.0) * 0.9;
        double y = 0.1;
        double z = Math.cos((double)this.f_20883_ * Math.PI / 180.0) * 0.9;
        Vec3 throatPos = bodyOrigin.m_82549_(new Vec3(x, y, z));
        return throatPos;
    }

    public Vec3 getTerror0ThroatPosViaPlayer(Player entity) {
        Vec3 vehiclePosition = entity.m_20182_();
        float radius = 0.9f;
        double offsetX = (double)radius * -Math.sin((double)entity.f_20883_ * Math.PI / 180.0);
        double offsetZ = (double)radius * Math.cos((double)entity.f_20883_ * Math.PI / 180.0);
        double offsetY = 2.1;
        Vec3 throatPos = new Vec3(vehiclePosition.f_82479_ + offsetX, vehiclePosition.f_82480_ + offsetY, vehiclePosition.f_82481_ + offsetZ);
        return throatPos;
    }

    public Vec3 getTerror1ThroatPosViaPlayer(Player entity) {
        Vec3 vehiclePosition = entity.m_20182_();
        float radius = 1.5f;
        float angle = (float)Math.PI / 180 * entity.f_20883_ - 95.0f;
        double offsetX = (double)radius * Math.sin(Math.PI + (double)angle);
        double offsetZ = (double)radius * Math.cos(angle);
        double offsetY = 1.7;
        Vec3 throatPos = new Vec3(vehiclePosition.f_82479_ + offsetX, vehiclePosition.f_82480_ + offsetY, vehiclePosition.f_82481_ + offsetZ);
        return throatPos;
    }

    public Vec3 getTerror2ThroatPosViaPlayer(Player entity) {
        Vec3 vehiclePosition = entity.m_20182_();
        float radius = 1.5f;
        float angle = (float)Math.PI / 180 * entity.f_20883_ + 95.0f;
        double offsetX = (double)radius * Math.sin(Math.PI + (double)angle);
        double offsetZ = (double)radius * Math.cos(angle);
        double offsetY = 1.7;
        Vec3 throatPos = new Vec3(vehiclePosition.f_82479_ + offsetX, vehiclePosition.f_82480_ + offsetY, vehiclePosition.f_82481_ + offsetZ);
        return throatPos;
    }

    @Override
    public float getProjectileDamage(ADragonBase dragon, Entity entity, BaseLinearFlightProjectile projectile) {
        return 4.0f;
    }

    @Override
    public int getMaxFuel() {
        return 85;
    }

    @Override
    public void m_8119_() {
        String s;
        Entity entity;
        super.m_8119_();
        if (this.m_20202_() != null && (entity = this.m_20202_()) instanceof Player) {
            Player player = (Player)entity;
            Vec3 vehicleLook = player.m_20252_(1.0f);
            if (this == player.m_20197_().get(0)) {
                Vec3 throat0 = this.getTerror0ThroatPosViaPlayer(player);
                if (this.isUsingAbility() && this.canUseBreath()) {
                    this.firePrimary(vehicleLook, throat0);
                }
            } else if (this == player.m_20197_().get(1)) {
                Vec3 throat1 = this.getTerror1ThroatPosViaPlayer(player);
                if (this.isUsingAbility() && this.canUseBreath()) {
                    this.firePrimary(vehicleLook, throat1);
                }
            } else if (this == player.m_20197_().get(2)) {
                Vec3 throat2 = this.getTerror2ThroatPosViaPlayer(player);
                if (this.isUsingAbility() && this.canUseBreath()) {
                    this.firePrimary(vehicleLook, throat2);
                }
            }
            if (player.m_6144_() && player.m_20096_() && player.m_20202_() == null || this.m_21224_() || this.m_146910_() || player.m_21224_() || player.m_146910_() || player.m_5842_() || player.m_6067_() || player.m_20143_()) {
                this.setLastMountedPlayerUUID(null);
                this.m_8127_();
                player.m_21195_(MobEffects.f_19591_);
                player.m_21195_(MobEffects.f_19603_);
                player.m_21195_(MobEffects.f_19596_);
                if (this.f_19853_.m_5776_()) {
                    ControlNetwork.INSTANCE.sendToServer((Object)new DragonRideMessage(this.m_142049_(), false));
                }
            }
        }
        if ((s = ChatFormatting.m_126649_((String)this.m_7755_().getString())) != null && (s.equals("dragonfruit") || s.equals("wyrmroost") || s.equals("chomp") || s.equals("Dragonfruit") || s.equals("Wyrmroost") || s.equals("Chomp") || s.equals("Chomper") || s.equals("chomper") || s.equals("MsChomper"))) {
            this.setDragonVariant(8);
        }
        this.performInCapacitate();
    }

    @Override
    protected boolean canUseBreath() {
        Player player;
        Entity entity = this.m_20202_();
        if (entity instanceof Player && ((player = (Player)entity).m_20202_() instanceof ADragonBaseFlyingRideableBreathUser || player.m_20202_() instanceof ADragonBaseFlyingRideableProjUser)) {
            return false;
        }
        return super.canUseBreath();
    }

    @Override
    public void firePrimary(Vec3 riderLook, Vec3 throat) {
        if (this.f_19796_.nextInt(2) == 1) {
            FireBreathSmallProjectile fireProj = new FireBreathSmallProjectile(this, throat, riderLook, this.f_19853_);
            fireProj.setProjectileSize(0);
            fireProj.shootNoScaling(riderLook, 1.0f, 7.0f);
            this.playProjectileSound();
            this.f_19853_.m_7967_((Entity)fireProj);
        }
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public ADragonEggBase getBreedEggResult(ServerLevel level, @NotNull AgeableMob parent) {
        TerribleTerrorEgg dragon = (TerribleTerrorEgg)((EntityType)ModEntities.TERRIBLE_TERROR_EGG.get()).m_20615_((Level)level);
        return dragon;
    }

    public boolean m_21531_() {
        return super.m_21531_();
    }

    protected static boolean isBrightEnoughToSpawn(BlockAndTintGetter p_186210_, BlockPos p_186211_) {
        return p_186210_.m_45524_(p_186211_, 0) > 8;
    }

    public boolean m_7252_(ItemStack pStack) {
        Item item = pStack.m_41720_();
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        return itemstack.m_41619_() || this.ticksSinceEaten > 0 && item.m_41472_() && !itemstack.m_41720_().m_41472_();
    }

    private void spitOutItem(ItemStack pStack) {
        if (!pStack.m_41619_() && !this.f_19853_.f_46443_) {
            ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_() + this.m_20154_().f_82479_, this.m_20186_() + 1.0, this.m_20189_() + this.m_20154_().f_82481_, pStack);
            itementity.m_32060_();
            itementity.m_32052_(this.m_142081_());
            this.m_5496_(SoundEvents.f_11952_, 3.0f, 1.0f);
            this.f_19853_.m_7967_((Entity)itementity);
        }
    }

    private void dropItemStack(ItemStack pStack) {
        ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), pStack);
        this.f_19853_.m_7967_((Entity)itementity);
    }

    protected void m_7581_(ItemEntity pItemEntity) {
        ItemStack itemstack = pItemEntity.m_32055_();
        if (this.m_7252_(itemstack) && this.isFoodEdibleToDragon(itemstack)) {
            int i = itemstack.m_41613_();
            if (i > 1) {
                this.dropItemStack(itemstack.m_41620_(i - 1));
            }
            this.spitOutItem(this.m_6844_(EquipmentSlot.MAINHAND));
            this.m_21053_(pItemEntity);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41620_(1));
            this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
            this.m_7938_((Entity)pItemEntity, itemstack.m_41613_());
            pItemEntity.m_146870_();
            this.ticksSinceEaten = 0;
        }
    }

    private boolean canEat(ItemStack pItemStack) {
        return pItemStack.m_41720_().m_41472_() && this.m_5448_() == null && this.f_19861_ && !this.m_5803_();
    }

    @Override
    protected void m_5907_() {
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        if (!itemstack.m_41619_() && !EnchantmentHelper.m_44924_((ItemStack)itemstack)) {
            this.m_19983_(itemstack);
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && this.m_6084_() && this.m_6142_()) {
            ++this.ticksSinceEaten;
            ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (this.canEat(itemstack)) {
                if (this.ticksSinceEaten > 600) {
                    ItemStack itemstack1 = itemstack.m_41671_(this.f_19853_, (LivingEntity)this);
                    if (this.isBreedingFood(itemstack1)) {
                        this.m_27595_(null);
                    }
                    if (!itemstack1.m_41619_()) {
                        this.m_8061_(EquipmentSlot.MAINHAND, itemstack1);
                    }
                    Player player = this.f_19853_.m_45930_((Entity)this, 8.0);
                    if (!this.m_21824_() && player != null) {
                        if (this.isItemStackForTaming(itemstack) && this.f_19796_.nextInt(5) == 1) {
                            this.tameWithName(player);
                            this.f_19853_.m_7605_((Entity)this, (byte)7);
                        } else {
                            this.f_19853_.m_7605_((Entity)this, (byte)6);
                        }
                    }
                    this.ticksSinceEaten = 0;
                } else if (this.ticksSinceEaten > 599 && this.f_19796_.nextFloat() < 0.1f) {
                    this.m_5496_(SoundEvents.f_11909_, 1.5f, 1.0f);
                    this.f_19853_.m_7605_((Entity)this, (byte)45);
                }
            }
        }
    }

    @Override
    public boolean guiLocked() {
        return true;
    }

    @Override
    protected void onGroundMechanics() {
        int start = 2;
        Vec3 pos = this.m_20182_();
        for (int xz1 = -start + 1; xz1 < start; ++xz1) {
            for (int xz4 = -start + 1; xz4 < start; ++xz4) {
                BlockPos pos1 = new BlockPos(pos.m_82520_((double)xz1, -1.0, (double)xz1));
                BlockPos pos2 = new BlockPos(pos.m_82520_((double)(-xz4), -1.0, (double)xz4));
                if (this.f_19853_.m_8055_(pos1).m_60767_().m_76334_() || this.f_19853_.m_8055_(pos2).m_60767_().m_76334_()) {
                    this.setIsDragonOnGround(true);
                    continue;
                }
                this.setIsDragonOnGround(false);
            }
        }
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int pTime) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)pTime);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_142270_(this.f_19796_));
    }

    protected SoundEvent m_7515_() {
        if (this.isDragonSleeping()) {
            return (SoundEvent)ModSounds.TERRIBLE_TERROR_SLEEP.get();
        }
        return (SoundEvent)ModSounds.TERRIBLE_TERROR_GROWL.get();
    }

    @Override
    protected SoundEvent getTameSound() {
        return (SoundEvent)ModSounds.TERRIBLE_TERROR_TAME.get();
    }

    @Override
    protected SoundEvent getProjectileSound() {
        return (SoundEvent)ModSounds.TERRIBLE_TERROR_FIRE.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.TERRIBLE_TERROR_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.TERRIBLE_TERROR_DEATH.get();
    }

    public class ResetUniversalAngerTargetGoal<T extends Mob>
    extends Goal {
        private static final int ALERT_RANGE_Y = 10;
        private final T mob;
        private final boolean alertOthersOfSameType;
        private int lastHurtByPlayerTimestamp;
        final /* synthetic */ TerribleTerror this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public ResetUniversalAngerTargetGoal(T pMob, boolean pAlertOthersOfSameType) {
            this.this$0 = (TerribleTerror)this$0;
            this.mob = pMob;
            this.alertOthersOfSameType = pAlertOthersOfSameType;
        }

        public boolean m_8036_() {
            return ((Mob)this.mob).f_19853_.m_46469_().m_46207_(GameRules.f_46127_) && this.wasHurtByPlayer();
        }

        public boolean m_8045_() {
            return this.mob.m_142581_() != null && this.mob.m_20280_((Entity)this.mob.m_142581_()) < 12.0;
        }

        private boolean wasHurtByPlayer() {
            return this.mob.m_142581_() != null && this.mob.m_142581_().m_6095_() == EntityType.f_20532_ && this.mob.m_21213_() > this.lastHurtByPlayerTimestamp;
        }

        public void m_8056_() {
            this.lastHurtByPlayerTimestamp = this.mob.m_21213_();
            ((NeutralMob)this.mob).m_21661_();
            if (this.alertOthersOfSameType) {
                this.getNearbyMobsOfSameType().stream().filter(p_26127_ -> p_26127_ != this.mob).map(p_26125_ -> (NeutralMob)p_26125_).forEach(NeutralMob::m_21661_);
            }
            super.m_8056_();
        }

        private List<? extends Mob> getNearbyMobsOfSameType() {
            double d0 = this.mob.m_21133_(Attributes.f_22277_);
            AABB aabb = AABB.m_82333_((Vec3)this.mob.m_20182_()).m_82377_(d0, 10.0, d0);
            return ((Mob)this.mob).f_19853_.m_6443_(this.mob.getClass(), aabb, EntitySelector.f_20408_);
        }
    }

    public static class TerrorFeedOnGroundGoal
    extends Goal {
        TerribleTerror dragonBase;
        Level level;

        public TerrorFeedOnGroundGoal(TerribleTerror dragonBase) {
            this.dragonBase = dragonBase;
            this.level = dragonBase.f_19853_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!this.dragonBase.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
                return false;
            }
            if (this.dragonBase.m_5448_() == null && this.dragonBase.m_142581_() == null) {
                if (this.dragonBase.shouldStopMovingIndependently()) {
                    return false;
                }
                List list = this.dragonBase.f_19853_.m_6443_(ItemEntity.class, this.dragonBase.m_142469_().m_82377_(8.0, 4.0, 8.0), ALLOWED_ITEMS);
                if (list != null) {
                    for (ItemEntity itemEntity : list) {
                        if (!this.dragonBase.m_142582_((Entity)itemEntity) || !this.dragonBase.m_7252_(itemEntity.m_32055_())) continue;
                        return !list.isEmpty() && this.dragonBase.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
                    }
                }
            } else {
                return true;
            }
            ItemStack itemstack = this.dragonBase.m_6844_(EquipmentSlot.MAINHAND);
            return itemstack.m_41619_() || this.dragonBase.ticksSinceEaten > 0;
        }

        public void m_8056_() {
            ItemEntity itemEntity;
            List itemEntityList = this.level.m_6443_(ItemEntity.class, this.dragonBase.m_142469_().m_82377_(8.0, 4.0, 8.0), ALLOWED_ITEMS);
            ItemStack itemStack = this.dragonBase.m_6844_(EquipmentSlot.MAINHAND);
            if (!itemEntityList.isEmpty() && itemStack.m_41619_() && this.dragonBase.isFoodEdibleToDragon((itemEntity = (ItemEntity)itemEntityList.iterator().next()).m_32055_())) {
                this.dragonBase.m_21573_().m_5624_((Entity)itemEntity, (double)1.2f);
            }
        }

        public void m_8037_() {
            List itemEntityList = this.level.m_6443_(ItemEntity.class, this.dragonBase.m_142469_().m_82377_(8.0, 4.0, 8.0), ALLOWED_ITEMS);
            ItemStack itemStack = this.dragonBase.m_6844_(EquipmentSlot.MAINHAND);
            if (!itemEntityList.isEmpty() && itemStack.m_41619_()) {
                ItemEntity itemEntity = (ItemEntity)itemEntityList.iterator().next();
                if (this.dragonBase.m_21574_().m_148306_((Entity)itemEntity) && this.dragonBase.isFoodEdibleToDragon(itemEntity.m_32055_())) {
                    this.dragonBase.m_21573_().m_5624_((Entity)itemEntity, (double)1.2f);
                }
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }
}

