/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.dragons.stinger;

import com.GACMD.isleofberk.entity.base.render.model.BaseDragonModel;
import com.GACMD.isleofberk.entity.dragons.stinger.Stinger;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class StingerModel
extends BaseDragonModel<Stinger> {
    @Override
    public ResourceLocation getAnimationFileLocation(Stinger stinger) {
        return new ResourceLocation("isleofberk", "animations/dragons/stinger.animation.json");
    }

    @Override
    public ResourceLocation getModelLocation(Stinger stinger) {
        return new ResourceLocation("isleofberk", "geo/dragons/stinger.geo.json");
    }

    @Override
    public ResourceLocation getTextureLocation(Stinger stinger) {
        if (stinger.isTitanWing()) {
            return new ResourceLocation("isleofberk:textures/dragons/stinger/titanstinger.png");
        }
        switch (stinger.getDragonVariant()) {
            default: {
                return new ResourceLocation("isleofberk:textures/dragons/stinger/wildroar.png");
            }
            case 1: {
                return new ResourceLocation("isleofberk:textures/dragons/stinger/mudsmasher.png");
            }
            case 2: {
                return new ResourceLocation("isleofberk:textures/dragons/stinger/sandscorcher.png");
            }
            case 3: {
                return new ResourceLocation("isleofberk:textures/dragons/stinger/badlands.png");
            }
            case 4: {
                return new ResourceLocation("isleofberk:textures/dragons/stinger/kingly.png");
            }
            case 5: 
        }
        return new ResourceLocation("isleofberk:textures/dragons/stinger/coastal_predator.png");
    }

    @Override
    public void setLivingAnimations(Stinger stinger, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations(stinger, uniqueID, customPredicate);
        IBone saddle = this.getAnimationProcessor().getBone("Saddle");
        IBone collar = this.getAnimationProcessor().getBone("Collar");
        IBone spike2 = this.getAnimationProcessor().getBone("Spike2");
        IBone headTrack1 = this.getAnimationProcessor().getBone("HeadTrack1");
        IBone headTrack2 = this.getAnimationProcessor().getBone("HeadTrack2");
        IBone headTrack3 = this.getAnimationProcessor().getBone("HeadTrack3");
        if (stinger.hasSaddle()) {
            saddle.setHidden(false);
            spike2.setHidden(true);
        }
        if (!stinger.m_21824_()) {
            collar.setHidden(true);
        }
        if (!stinger.isRenderedOnGUI()) {
            EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
            headTrack1.setRotationX(extraData.headPitch * ((float)Math.PI / 180) / 3.0f);
            headTrack1.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180) / 3.0f);
            headTrack2.setRotationX(extraData.headPitch * ((float)Math.PI / 180) / 3.0f);
            headTrack2.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180) / 3.0f);
            headTrack3.setRotationX(extraData.headPitch * ((float)Math.PI / 180) / 3.0f);
            headTrack3.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180) / 3.0f);
        }
    }

    @Override
    protected String getMainBodyBone() {
        return "root";
    }
}

