/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.dragons.speedstinger;

import com.GACMD.isleofberk.entity.base.render.model.BaseDragonModel;
import com.GACMD.isleofberk.entity.dragons.speedstinger.SpeedStinger;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class SpeedStingerModel
extends BaseDragonModel<SpeedStinger> {
    public static final ResourceLocation SPEED_STINGER = new ResourceLocation("isleofberk:textures/dragons/speed_stinger/speed_stinger.png");
    public static final ResourceLocation FLOUTSCOUT = new ResourceLocation("isleofberk:textures/dragons/speed_stinger/floutscout.png");
    public static final ResourceLocation ICE_BREAKER = new ResourceLocation("isleofberk:textures/dragons/speed_stinger/ice_breaker.png");
    public static final ResourceLocation SWEET_STING = new ResourceLocation("isleofberk:textures/dragons/speed_stinger/sweet_sting.png");

    @Override
    public ResourceLocation getAnimationFileLocation(SpeedStinger speed_stinger) {
        return new ResourceLocation("isleofberk", "animations/dragons/speed_stinger.animation.json");
    }

    @Override
    public ResourceLocation getModelLocation(SpeedStinger speed_stinger) {
        return new ResourceLocation("isleofberk", "geo/dragons/speed_stinger.geo.json");
    }

    @Override
    public ResourceLocation getTextureLocation(SpeedStinger speed_stinger) {
        switch (speed_stinger.getDragonVariant()) {
            default: {
                return SPEED_STINGER;
            }
            case 1: {
                return FLOUTSCOUT;
            }
            case 2: {
                return ICE_BREAKER;
            }
            case 3: 
        }
        return SWEET_STING;
    }

    @Override
    public void setLivingAnimations(SpeedStinger dragon, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations(dragon, uniqueID, customPredicate);
        IBone neck1 = this.getAnimationProcessor().getBone("Neck1");
        IBone neck2 = this.getAnimationProcessor().getBone("Neck2");
        IBone head = this.getAnimationProcessor().getBone("head");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (!(dragon.shouldStopMovingIndependently() || Minecraft.m_91087_().m_91104_() || dragon.isRenderedOnGUI())) {
            neck1.setRotationY(neck1.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180) / 3.0f);
            neck2.setRotationY(neck2.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180) / 3.0f);
            head.setRotationY(head.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180) / 3.0f);
            neck1.setRotationX(neck1.getRotationX() + extraData.headPitch * ((float)Math.PI / 180) / 4.0f);
            head.setRotationX(head.getRotationX() + extraData.headPitch * ((float)Math.PI / 180) / 4.0f);
        }
    }

    @Override
    public String getMainBodyBone() {
        return "root";
    }
}

