/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.dragons.speedstinger;

import com.GACMD.isleofberk.entity.AI.breed.DragonBreedGoal;
import com.GACMD.isleofberk.entity.AI.goal.FollowOwnerNoTPGoal;
import com.GACMD.isleofberk.entity.AI.goal.IOBLookAtPlayerGoal;
import com.GACMD.isleofberk.entity.AI.goal.IOBRandomLookAroundGoal;
import com.GACMD.isleofberk.entity.AI.ground.DragonWaterAvoidingRandomStrollGoal;
import com.GACMD.isleofberk.entity.AI.taming.AggressionToPlayersGoal;
import com.GACMD.isleofberk.entity.AI.target.DragonOwnerHurtTargetGoal;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.base.dragon.ADragonRideableUtility;
import com.GACMD.isleofberk.entity.dragons.speedstingerleader.SpeedStingerLeader;
import com.GACMD.isleofberk.entity.eggs.entity.base.ADragonEggBase;
import com.GACMD.isleofberk.entity.eggs.entity.eggs.SpeedStingerEgg;
import com.GACMD.isleofberk.registery.ModEntities;
import com.GACMD.isleofberk.registery.ModItems;
import com.GACMD.isleofberk.registery.ModSounds;
import com.GACMD.isleofberk.registery.ModTags;
import com.GACMD.isleofberk.util.Util;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SpeedStinger
extends ADragonRideableUtility {
    private static final EntityDataAccessor<Optional<UUID>> LEADER_UUID = SynchedEntityData.m_135353_(SpeedStinger.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final Optional<Boolean> DO_NOT_DESPAWN = Optional.empty();
    private static final EntityDataAccessor<Byte> UNIT_TYPE = SynchedEntityData.m_135353_(SpeedStinger.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    protected int ticksSinceLastStingAttack = 0;
    protected int jumpTicks = 0;

    private <E extends IAnimatable> PlayState basicMovementController(AnimationEvent<E> event) {
        if (this.isDragonMoving() && !this.shouldStopMovingIndependently()) {
            if (this.m_5448_() != null && !this.m_5448_().m_21224_() && this.m_20270_((Entity)this.m_5448_()) < 14.0f) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("SpeedStingerRun", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("SpeedStingerWalk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isDragonSitting() && !this.isDragonSleeping()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("SpeedStingerSit", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isDragonSleeping()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("SpeedStingerSleep", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.m_21563_().m_186069_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("SpeedStingerCurious", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("SpeedStingerIdle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState attackController(AnimationEvent<E> event) {
        LivingEntity target;
        if (this.getTicksSinceLastAttack() >= 0 && this.getTicksSinceLastAttack() < 12) {
            if (this.getCurrentAttackType() == 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("SpeedStingerBite", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.getCurrentAttackType() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("SpeedStingerSting", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
        }
        if ((target = this.m_5448_()) != null && !this.isSSOnGround() && this.isDragonMoving() && !target.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("SpeedStingerPounce", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    @Override
    public boolean m_6673_(@NotNull DamageSource pSource) {
        if (pSource == DamageSource.f_19305_ || pSource == DamageSource.f_19307_ || pSource == DamageSource.f_19315_ || pSource == DamageSource.f_19310_ || pSource == DamageSource.f_19316_ || pSource == DamageSource.f_19314_ || pSource == DamageSource.f_19309_) {
            return true;
        }
        if (this.isDragonDisabled() && !(pSource.m_7639_() instanceof Player)) {
            return false;
        }
        return super.m_6673_(pSource);
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "speed_stinger_controller", (float)this.getTransitionTicks(), this::basicMovementController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "speed_stinger_controller_attacks", 0.0f, this::attackController));
    }

    public boolean isSSOnGround() {
        BlockPos solidPos = new BlockPos(this.m_20182_().f_82479_, this.m_20182_().f_82480_ - 1.0, this.m_20182_().f_82481_);
        return !this.f_19853_.m_8055_(solidPos).m_60795_();
    }

    public SpeedStinger(EntityType<? extends SpeedStinger> animal, Level world) {
        super(animal, world);
        this.f_21364_ = 3;
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public static boolean checkSpeedStingerSpawnRules(EntityType<? extends Animal> pAnimal, ServerLevelAccessor pLevel, MobSpawnType pReason, BlockPos pPos, Random pRandom) {
        return pReason == MobSpawnType.SPAWNER || pReason == MobSpawnType.STRUCTURE || !pLevel.m_45527_(pPos) || pLevel.m_45527_(pPos) && SpeedStinger.checkMonsterSpawnRules(pAnimal, pLevel, pReason, pPos, pRandom);
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor pLevel, BlockPos pPos, Random pRandom) {
        if (pLevel.m_45517_(LightLayer.SKY, pPos) > pRandom.nextInt(32)) {
            return false;
        }
        if (pLevel.m_45517_(LightLayer.BLOCK, pPos) > 0) {
            return false;
        }
        int i = pLevel.m_6018_().m_46470_() ? pLevel.m_46849_(pPos, 10) : pLevel.m_46803_(pPos);
        return i <= pRandom.nextInt(8);
    }

    public static boolean checkMonsterSpawnRules(EntityType<? extends Animal> pType, ServerLevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, Random pRandom) {
        return pLevel.m_46791_() != Difficulty.PEACEFUL && SpeedStinger.isDarkEnoughToSpawn(pLevel, pPos, pRandom) && SpeedStinger.m_21400_(pType, (LevelAccessor)pLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (Random)pRandom);
    }

    protected boolean m_8028_() {
        return !this.m_21824_() && !this.m_6162_();
    }

    public boolean m_8023_() {
        return !this.m_21824_() && !this.m_6162_();
    }

    @Override
    public void m_6043_() {
        if (this.m_8028_() && this.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        } else if (!(this.m_21824_() || this.m_21532_() || this.m_8023_())) {
            Player entity = this.f_19853_.m_45930_((Entity)this, -1.0);
            Event.Result result = ForgeEventFactory.canEntityDespawn((Mob)this);
            if (result == Event.Result.DENY) {
                this.f_20891_ = 0;
                entity = null;
            } else if (result == Event.Result.ALLOW) {
                this.m_146870_();
                entity = null;
            }
            if (!this.m_21824_() && entity != null) {
                int i;
                int j;
                double d0 = entity.m_20280_((Entity)this);
                if (d0 > (double)(j = (i = this.m_6095_().m_20674_().m_21611_()) * i) && this.m_6785_(d0)) {
                    this.m_146870_();
                }
                int k = this.m_6095_().m_20674_().m_21612_();
                int l = k * k;
                if (this.f_20891_ > 600 && this.f_19796_.nextInt(800) == 0 && d0 > (double)l && this.m_6785_(d0)) {
                    this.m_146870_();
                } else if (d0 < (double)l) {
                    this.f_20891_ = 0;
                }
            }
        } else {
            this.f_20891_ = 0;
        }
    }

    @Override
    public boolean isNocturnal() {
        return true;
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return true;
    }

    @Override
    protected boolean isItemStackForTaming(ItemStack stack) {
        return Ingredient.m_204132_(ModTags.Items.SPEED_STINGER_TAME_FOOD).test(stack);
    }

    @Override
    public boolean isBreedingFood(ItemStack pStack) {
        return Ingredient.m_204132_(ModTags.Items.SPEED_STINGER_BREED_FOOD).test(pStack);
    }

    @Override
    protected int getAggressionType() {
        return 3;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new SpeedStingerCustomMeleeAttackGoal((PathfinderMob)this, 1.4, true));
        this.f_21345_.m_25352_(3, (Goal)new DragonBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new FollowOwnerNoTPGoal(this, 1.1, 3.0f, 3.0f, false));
        this.f_21345_.m_25352_(6, (Goal)new DragonWaterAvoidingRandomStrollGoal(this, this.m_21133_(Attributes.f_22279_), 1.0000001E-5f));
        this.f_21345_.m_25352_(7, (Goal)new IOBLookAtPlayerGoal(this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new IOBRandomLookAroundGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new SpeedStingerCustomLeapAttackGoal(this, 0.6f));
        this.f_21346_.m_25352_(1, new AggressionToPlayersGoal<Player>(this, Player.class, true, this.getAggressionType(), null));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new DragonOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, PREY_SELECTOR));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, ZombifiedPiglin.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Spider.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, EnderMan.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Witch.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Slime.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true));
    }

    @Override
    public void m_6710_(@org.jetbrains.annotations.Nullable LivingEntity pLivingEntity) {
        super.m_6710_(pLivingEntity);
        this.setSleepDisturbTicks(250);
        this.setAbilityDisturbTicksAbility(250);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LEADER_UUID, Optional.empty());
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.getLeaderUUID() != null) {
            pCompound.m_128362_("dragon_flock_leader", this.getLeaderUUID());
        }
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128403_("dragon_flock_leader")) {
            UUID uuid = pCompound.m_128342_("dragon_flock_leader");
            this.setLeaderViaUUID(uuid);
        }
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        this.setDragonVariant(this.getTypeForBiome(pLevel));
        return pSpawnData;
    }

    @Override
    public int getMaxAmountOfVariants() {
        return 4;
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    protected int getTypeForBiome(ServerLevelAccessor pLevel) {
        Holder biome = pLevel.m_204166_(new BlockPos(this.m_20182_()));
        if (this.m_20186_() < 0.0) {
            return 1;
        }
        if (biome.m_203656_(ModTags.Biomes.SPEED_STINGER_BIOMES)) {
            return 0;
        }
        if (biome.m_203656_(ModTags.Biomes.ICE_BREAKER_BIOMES)) {
            return 2;
        }
        if (biome.m_203656_(ModTags.Biomes.FLOUTSCOUT_BIOMES)) {
            return 1;
        }
        if (biome.m_203656_(ModTags.Biomes.SWEET_STING_BIOMES)) {
            return 3;
        }
        return 0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22279_, (double)0.4f).m_22268_(Attributes.f_22277_, 5.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 10.0);
    }

    protected boolean isSpeedStingerLeaderClass() {
        return false;
    }

    @Nullable
    public UUID getLeaderUUID() {
        return ((Optional)this.f_19804_.m_135370_(LEADER_UUID)).orElse(null);
    }

    public void setLeaderViaUUID(UUID uuid) {
        this.setLeaderViaUUID(Optional.of(uuid));
    }

    public void setLeaderViaUUID(Optional<UUID> leader) {
        this.f_19804_.m_135381_(LEADER_UUID, leader);
    }

    @Override
    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public float getRideCameraDistanceBack() {
        return 6.0f;
    }

    private void findPotentialLeader() {
        SpeedStingerLeader speedStingerLeaderEntity = (SpeedStingerLeader)this.f_19853_.m_45982_(this.f_19853_.m_45976_(SpeedStingerLeader.class, this.getTargetSearchArea(this.getFollowDistance())), TargetingConditions.m_148353_(), (LivingEntity)this, this.m_20185_(), this.m_20188_(), this.m_20189_());
        if (speedStingerLeaderEntity != null) {
            if (!this.isSpeedStingerLeaderClass()) {
                this.setLeaderViaUUID(speedStingerLeaderEntity.m_142081_());
            }
            speedStingerLeaderEntity.addMember(this);
        }
    }

    public void removeLeader() {
        this.setLeaderViaUUID(Optional.empty());
    }

    private SpeedStingerLeader nearestLeader() {
        return (SpeedStingerLeader)this.f_19853_.m_45982_(this.f_19853_.m_45976_(SpeedStingerLeader.class, this.getTargetSearchArea(this.getFollowDistance())), TargetingConditions.m_148353_(), (LivingEntity)this, this.m_20185_(), this.m_20188_(), this.m_20189_());
    }

    protected int m_6552_(Player pPlayer) {
        return 150;
    }

    public void m_6863_(boolean baby) {
        super.m_6863_(baby);
        if (baby) {
            this.m_21051_(Attributes.f_22276_).m_22100_(14.0);
            this.m_21153_(14.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_((double)this.m_21233_());
        }
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        return super.m_6469_(pSource, pAmount);
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        boolean ownedByPlayer = this.m_21830_((LivingEntity)pPlayer);
        if (pPlayer.m_6047_() && ownedByPlayer && !this.guiLocked() && !this.isCommandItems(itemstack)) {
            this.openGUI(pPlayer);
            return InteractionResult.SUCCESS;
        }
        if (!itemstack.m_41619_()) {
            int nutrition = 6;
            if (!this.m_21824_()) {
                if (this.m_6162_() && this.isFoodEdibleToDragon(itemstack)) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    if (this.f_19796_.nextInt(5) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)pPlayer)) {
                        this.m_21828_(pPlayer);
                        this.f_21344_.m_26573_();
                        this.m_6710_(null);
                        this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11813_, SoundSource.NEUTRAL, 1.0f, this.getSoundPitch(), true);
                        this.addParticlesAroundSelf((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemstack));
                        this.f_19853_.m_7605_((Entity)this, (byte)7);
                    } else {
                        this.f_19853_.m_7605_((Entity)this, (byte)6);
                    }
                }
            } else if (this.isFoodEdibleToDragon(itemstack) && this.canEatWithFoodOnHand(true)) {
                if (this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(5.0f);
                    this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11813_, SoundSource.NEUTRAL, 1.0f, this.getSoundPitch(), true);
                    this.addParticlesAroundSelf((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemstack));
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                }
                if (this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(5.0f);
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                }
            }
        } else if (itemstack.m_41619_()) {
            String owned = "iob.speed_stinger.owned";
            String not_owned = "iob.speed_stinger.not_owned";
            if (this.m_21830_((LivingEntity)pPlayer)) {
                pPlayer.m_5661_((Component)new TranslatableComponent(owned, new Object[]{this.m_21830_((LivingEntity)pPlayer)}), true);
            } else {
                pPlayer.m_5661_((Component)new TranslatableComponent(not_owned, new Object[]{!this.m_21830_((LivingEntity)pPlayer)}), true);
            }
            if (!(this.m_21824_() || this.isBreedingFood(itemstack) || this.isFoodEdibleToDragon(itemstack) || !pPlayer.m_7500_() || this.isSpeedStingerLeaderClass())) {
                this.tameWithName(pPlayer);
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    @Override
    protected int getInLoveCoolDownInMCDays() {
        return 1;
    }

    public void circleEntity(Entity target, float radius, float speed, boolean direction, int circleFrame, float offset, float moveSpeedMultiplier) {
        int directionInt = direction ? 1 : -1;
        double t = (double)(1 * circleFrame) * 0.5 * (double)speed / (double)radius + (double)offset;
        Vec3 movePos = target.m_20182_().m_82520_((double)radius * Math.cos(t), 0.0, (double)radius * Math.sin(t));
        this.f_21344_.m_26519_(movePos.m_7096_(), movePos.m_7098_(), movePos.m_7094_(), (double)(speed * moveSpeedMultiplier));
    }

    public void m_7105_(boolean pTamed) {
        if (pTamed) {
            this.m_21153_(this.m_21233_() + this.m_21233_() * 0.2f);
        }
        super.m_7105_(pTamed);
    }

    public void m_21153_(float pHealth) {
        super.m_21153_(pHealth);
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        ItemStack itemstack0 = new ItemStack((ItemLike)ModItems.SPEED_STINGER_EGG.get(), 1);
        ItemStack itemstack1 = new ItemStack((ItemLike)ModItems.SPEED_STINGER_EGG_FLOUTSCOOUT.get(), 1);
        ItemStack itemstack2 = new ItemStack((ItemLike)ModItems.SPEED_STINGER_EGG_ICE_BREAKER.get(), 1);
        ItemStack itemstack3 = new ItemStack((ItemLike)ModItems.SPEED_STINGER_EGG_SWEET_STING.get(), 1);
        if (this.f_19796_.nextInt(8) == 1) {
            if (this.getDragonVariant() == 0) {
                if (!itemstack0.m_41619_()) {
                    this.m_19983_(itemstack0);
                }
            } else if (this.getDragonVariant() == 1) {
                if (!itemstack1.m_41619_()) {
                    this.m_19983_(itemstack1);
                }
            } else if (this.getDragonVariant() == 2) {
                if (!itemstack2.m_41619_()) {
                    this.m_19983_(itemstack2);
                }
            } else if (this.getDragonVariant() == 3 && !itemstack3.m_41619_()) {
                this.m_19983_(itemstack3);
            }
        }
    }

    @Override
    public void m_21011_(InteractionHand pHand, boolean pUpdateSelf) {
        if (this.f_19796_.nextInt(7) == 0) {
            this.ticksSinceLastStingAttack = Util.secondsToTicks(3);
        }
        super.m_21011_(pHand, pUpdateSelf);
    }

    @Override
    public boolean m_7327_(Entity pEntity) {
        this.initAttackEffects(pEntity);
        return super.m_7327_(pEntity);
    }

    protected void initAttackEffects(Entity pEntity) {
        if (pEntity instanceof LivingEntity && this.getCurrentAttackType() == 1) {
            LivingEntity target = (LivingEntity)pEntity;
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 250, 2));
        }
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public ADragonEggBase getBreedEggResult(ServerLevel level, @NotNull AgeableMob parent) {
        SpeedStingerEgg dragon = (SpeedStingerEgg)((EntityType)ModEntities.SPEED_STINGER_EGG.get()).m_20615_((Level)level);
        return dragon;
    }

    @Override
    public void m_27563_(ServerLevel serverLevel, Animal partner) {
        if (partner instanceof ADragonBase) {
            ADragonBase dragonPartner = (ADragonBase)partner;
            ADragonEggBase egg = this.getBreedEggResult(serverLevel, (AgeableMob)dragonPartner);
            BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((Mob)this, (Mob)partner, (AgeableMob)egg);
            boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
            if (cancelled) {
                this.m_146762_(Util.mcDaysToMinutes(this.getInLoveCoolDownInMCDays()));
                dragonPartner.m_146762_(Util.mcDaysToMinutes(this.getInLoveCoolDownInMCDays()));
                this.m_27594_();
                partner.m_27594_();
                return;
            }
            if (egg != null) {
                ServerPlayer serverplayer = this.m_27592_();
                if (serverplayer == null && partner.m_27592_() != null) {
                    serverplayer = partner.m_27592_();
                }
                if (serverplayer != null) {
                    serverplayer.m_36220_(Stats.f_12937_);
                    CriteriaTriggers.f_10581_.m_147278_(serverplayer, (Animal)this, partner, (AgeableMob)egg);
                }
                this.m_146762_(Util.mcDaysToMinutes(this.getInLoveCoolDownInMCDays()));
                dragonPartner.m_146762_(Util.mcDaysToMinutes(this.getInLoveCoolDownInMCDays()));
                this.m_27594_();
                partner.m_27594_();
                if (dragonPartner.getDragonVariant() == this.getDragonVariant()) {
                    egg.setDragonVariant(this.getDragonVariant());
                } else {
                    egg.setDragonVariant(this.f_19796_.nextInt(this.getMaxAmountOfVariants()));
                }
                egg.m_6863_(true);
                egg.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                this.f_19853_.m_7967_((Entity)egg);
                this.f_19853_.m_7605_((Entity)this, (byte)18);
                if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46135_)) {
                    this.f_19853_.m_7967_((Entity)new ExperienceOrb(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_21187_().nextInt(7) + 1));
                }
            }
        }
    }

    @Override
    public void m_8119_() {
        Pig pig;
        super.m_8119_();
        if (this.getLeaderUUID() == null) {
            this.findPotentialLeader();
        }
        if ((pig = (Pig)this.f_19853_.m_45982_(this.f_19853_.m_45976_(Pig.class, this.getTargetSearchArea(14.0)), TargetingConditions.m_148353_(), (LivingEntity)this, this.m_20185_(), this.m_20188_(), this.m_20189_())) != null) {
            this.m_6710_((LivingEntity)pig);
        }
        if (this.ticksSinceLastStingAttack >= 0) {
            --this.ticksSinceLastStingAttack;
        }
        if (this.ticksSinceLastStingAttack >= 0) {
            this.setCurrentAttackType(1);
        } else {
            this.setCurrentAttackType(0);
        }
        this.jumpTicks = !this.f_19861_ ? ++this.jumpTicks : 0;
        this.m_20101_();
        this.floatStinger();
    }

    @Override
    protected void onGroundMechanics() {
        BlockPos pos1 = new BlockPos(this.m_20182_().m_82520_(0.0, -1.0, 0.0));
        if (this.f_19853_.m_8055_(pos1).m_60767_().m_76333_()) {
            this.setIsDragonOnGround(true);
        } else {
            this.setIsDragonOnGround(false);
        }
    }

    @Override
    public boolean canBeMounted() {
        return false;
    }

    @Override
    public boolean m_6741_() {
        return false;
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new SpeedStingerPathNavigation(this, pLevel);
    }

    private void floatStinger() {
        if (this.m_20069_()) {
            CollisionContext collisioncontext = CollisionContext.m_82750_((Entity)this);
            if (collisioncontext.m_6513_(LiquidBlock.f_54690_, this.m_142538_(), true) && !this.f_19853_.m_6425_(this.m_142538_().m_7494_()).m_205070_(FluidTags.f_13131_)) {
                this.f_19861_ = true;
            } else {
                this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.05, 0.0));
            }
        }
    }

    public boolean m_203441_(FluidState fluidstate) {
        return fluidstate.m_205070_(FluidTags.f_13131_);
    }

    public float m_5610_(@NotNull BlockPos pPos, LevelReader pLevel) {
        if (pLevel.m_8055_(pPos).m_60819_().m_205070_(FluidTags.f_13131_)) {
            return 10.0f;
        }
        return this.m_20069_() || this.isWaterBelow() ? Float.NEGATIVE_INFINITY : 0.0f;
    }

    protected SoundEvent m_7515_() {
        if (this.isDragonSleeping()) {
            return (SoundEvent)ModSounds.SPEED_STINGER_SLEEP.get();
        }
        return (SoundEvent)ModSounds.SPEED_STINGER_GROWL.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.SPEED_STINGER_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SPEED_STINGER_DEATH.get();
    }

    @Override
    protected SoundEvent get1stAttackSound() {
        return (SoundEvent)ModSounds.SPEED_STINGER_BITE.get();
    }

    @Override
    protected SoundEvent get2ndAttackSound() {
        return (SoundEvent)ModSounds.SPEED_STINGER_STING.get();
    }

    @Override
    protected void playAttackSound() {
        if (this.getCurrentAttackType() == 0) {
            this.m_5496_(this.get1stAttackSound(), 4.0f, 1.0f);
        }
        if (this.getCurrentAttackType() == 1) {
            this.m_5496_(this.get2ndAttackSound(), 4.0f, 1.0f);
        }
    }

    protected class SpeedStingerCustomMeleeAttackGoal
    extends MeleeAttackGoal {
        SpeedStinger speedStingerEntity;

        public SpeedStingerCustomMeleeAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.speedStingerEntity = (SpeedStinger)pMob;
        }

        public boolean m_8036_() {
            if (this.speedStingerEntity.isDragonSitting()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (this.speedStingerEntity.isDragonSitting()) {
                return false;
            }
            return super.m_8045_();
        }
    }

    protected class SpeedStingerCustomLeapAttackGoal
    extends LeapAtTargetGoal {
        SpeedStinger speedStingerEntity;

        public SpeedStingerCustomLeapAttackGoal(SpeedStinger speedStingerEntity, float pYd) {
            super((Mob)speedStingerEntity, pYd);
            this.speedStingerEntity = speedStingerEntity;
        }

        public boolean m_8036_() {
            if (this.speedStingerEntity.m_20160_() || this.speedStingerEntity.isDragonSitting()) {
                return false;
            }
            this.f_25489_ = this.speedStingerEntity.m_5448_();
            if (this.f_25489_ == null) {
                return false;
            }
            double d0 = Math.sqrt(this.speedStingerEntity.m_20275_(this.f_25489_.m_20185_(), 0.0, this.f_25489_.m_20189_()));
            if (d0 > 6.0) {
                if (!this.speedStingerEntity.m_20096_()) {
                    return false;
                }
                return this.speedStingerEntity.m_21187_().nextInt(SpeedStingerCustomLeapAttackGoal.m_186073_((int)75)) == 0;
            }
            return false;
        }

        public void m_8056_() {
            Vec3 vec3 = this.speedStingerEntity.m_20184_();
            Vec3 vec31 = new Vec3(this.f_25489_.m_20185_() - this.speedStingerEntity.m_20185_(), 0.0, this.f_25489_.m_20189_() - this.speedStingerEntity.m_20189_());
            if (vec31.m_82556_() > 1.0E-7) {
                vec31 = vec31.m_82541_().m_82490_(0.8).m_82549_(vec3.m_82490_(0.5));
            }
            this.speedStingerEntity.m_20334_(vec31.f_82479_, this.f_25490_, vec31.f_82481_);
        }

        public boolean m_8045_() {
            if (this.speedStingerEntity.isDragonSitting()) {
                return false;
            }
            return super.m_8045_();
        }
    }

    static class SpeedStingerPathNavigation
    extends GroundPathNavigation {
        SpeedStingerPathNavigation(SpeedStinger pSpeedStinger, Level pLevel) {
            super((Mob)pSpeedStinger, pLevel);
        }

        @NotNull
        protected PathFinder m_5532_(int pMaxVisitedNodes) {
            this.f_26508_ = new WalkNodeEvaluator();
            return new PathFinder(this.f_26508_, pMaxVisitedNodes);
        }

        protected boolean m_7367_(@NotNull BlockPathTypes pPathType) {
            return pPathType == BlockPathTypes.WATER || pPathType == BlockPathTypes.DAMAGE_FIRE || pPathType == BlockPathTypes.DANGER_FIRE || super.m_7367_(pPathType);
        }

        public boolean m_6342_(@NotNull BlockPos pPos) {
            return this.f_26495_.m_8055_(pPos).m_60713_(Blocks.f_49990_) || super.m_6342_(pPos);
        }
    }

    private class SpeedStingerPlayerSupport
    extends Goal {
        SpeedStinger speedStinger;
        Player player;

        public SpeedStingerPlayerSupport(SpeedStinger speedStinger2) {
            this.speedStinger = speedStinger2;
            this.player = (Player)speedStinger2.m_142480_();
        }

        public boolean m_8036_() {
            return this.speedStinger.m_21824_() && this.player != null && !SpeedStinger.this.isDragonSitting() && SpeedStinger.this.isDragonFollowing();
        }

        public void m_8037_() {
            Vec3 bodyOrigin = this.player.m_20182_();
            double x = -Math.sin((double)this.player.m_146908_() * Math.PI / 180.0) * 2.4;
            double y = this.player.m_20186_();
            double z = Math.cos((double)this.player.m_146908_() * Math.PI / 180.0) * 2.4;
            Vec3 pos = bodyOrigin.m_82549_(new Vec3(x, y, z));
            this.speedStinger.f_21344_.m_26519_(pos.m_7096_() - 40.0, pos.m_7098_(), pos.m_7094_() - 40.0, (double)1.4f);
        }
    }
}

