/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.dragons.nightfury;

import com.GACMD.isleofberk.entity.AI.taming.T4DragonPotionRequirement;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideable;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideableProjUser;
import com.GACMD.isleofberk.entity.eggs.entity.base.ADragonEggBase;
import com.GACMD.isleofberk.entity.eggs.entity.eggs.NightFuryEgg;
import com.GACMD.isleofberk.entity.projectile.abase.BaseLinearFlightProjectile;
import com.GACMD.isleofberk.entity.projectile.proj_user.furybolt.FuryBolt;
import com.GACMD.isleofberk.registery.ModEntities;
import com.GACMD.isleofberk.registery.ModSounds;
import com.GACMD.isleofberk.registery.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class NightFury
extends ADragonBaseFlyingRideableProjUser {
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final EntityDataAccessor<Integer> GLOW_VARIANT = SynchedEntityData.m_135353_(NightFury.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    private <E extends IAnimatable> PlayState basicMovementController(AnimationEvent<E> event) {
        if (this.isFlying()) {
            if (this.isDragonMoving()) {
                if (this.m_20160_()) {
                    if (this.m_146909_() < 8.0f || this.isGoingUp() || this.m_20197_().size() > 2) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("nightfury.flap", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        this.setShouldPlayFlapping(true);
                    }
                    if (this.m_146909_() >= 8.0f && this.m_146909_() < 33.0f && !this.isGoingUp()) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("nightfury.glide", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        this.setShouldPlayFlapping(false);
                    }
                    if (this.m_146909_() >= 33.0f && !this.isGoingUp()) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("nightfury.dive", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        this.setShouldPlayFlapping(false);
                    }
                    return PlayState.CONTINUE;
                }
                if (this.isDragonFollowing() && this.m_142480_() != null && this.m_142480_().m_21255_()) {
                    LivingEntity owner = this.m_142480_();
                    float dist = this.m_20270_((Entity)owner);
                    double ydist = this.m_20186_() - owner.m_20186_();
                    if (ydist < 10.0 || dist > 15.0f) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("nightfury.flap", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    } else {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("nightfury.dive", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    }
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("nightfury.flap", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    this.setShouldPlayFlapping(true);
                }
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("nightfury.hover", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                this.setShouldPlayFlapping(true);
            }
        } else {
            if (this.isDragonSitting() && !this.isDragonSleeping()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("nightfury.sit", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.isDragonSleeping()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("nightfury.sleep", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.isDragonMoving() && !this.shouldStopMovingIndependently()) {
                if (this.m_5448_() != null && !this.m_5448_().m_21224_() && this.m_20270_((Entity)this.m_5448_()) < 14.0f || this.m_20160_()) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("nightfury.run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("nightfury.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                }
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("nightfury.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState attackController(AnimationEvent<E> event) {
        if (this.getTicksSinceLastAttack() >= 0 && this.getTicksSinceLastAttack() < 12 && this.getCurrentAttackType() == 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("nightfury.bite", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isMarkFired()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("nightfury.breath"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState turnController(AnimationEvent<E> event) {
        int turnState = this.getRotationState();
        event.getController().setAnimationSpeed(4.0);
        if (turnState != 0) {
            if (this.isFlying()) {
                if (turnState == 1) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("nightfury.tailrotleft1f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else if (turnState == 2) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("nightfury.tailrotleft2f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else if (turnState == -1) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("nightfury.tailrotright1f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else if (turnState == -2) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("nightfury.tailrotright2f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                }
            } else if (turnState == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("nightfury.tailrotleft1", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (turnState == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("nightfury.tailrotleft2", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (turnState == -1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("nightfury.tailrotright1", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (turnState == -2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("nightfury.tailrotright2", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("nightfury.tailrot0", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "basic_MovementController", (float)this.getTransitionTicks(), this::basicMovementController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attack_Controller", 0.0f, this::attackController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "turnController", 35.0f, this::turnController));
    }

    public NightFury(EntityType<? extends NightFury> entityType, Level level) {
        super((EntityType<? extends ADragonBaseFlyingRideable>)entityType, level);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @javax.annotation.Nullable SpawnGroupData pSpawnData, @javax.annotation.Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (this.f_19796_.nextInt(1000) == 1) {
            this.setDragonVariant(5);
        } else {
            this.setDragonVariant(this.f_19796_.nextInt(this.getMaxAmountOfVariants()));
        }
        this.setGlowVariant(this.getMaxAmountOfGlowVariants());
        return pSpawnData;
    }

    public boolean m_7848_(Animal pOtherAnimal) {
        if (pOtherAnimal == this) {
            return false;
        }
        if (!(pOtherAnimal instanceof NightFury)) {
            return false;
        }
        return this.m_27593_() && pOtherAnimal.m_27593_();
    }

    @Override
    public int getMaxAmountOfVariants() {
        return 5;
    }

    public int getMaxAmountOfGlowVariants() {
        return 2;
    }

    @Override
    public float getRideCameraDistanceBack() {
        if (!this.isFlying()) {
            return 4.0f;
        }
        return 11.0f;
    }

    public int getGlowVariants() {
        return (Integer)this.f_19804_.m_135370_(GLOW_VARIANT);
    }

    public void setGlowVariant(int flying) {
        this.f_19804_.m_135381_(GLOW_VARIANT, (Object)flying);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GLOW_VARIANT, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("glow_variants", this.getGlowVariants());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setGlowVariant(pCompound.m_128451_("glow_variants"));
    }

    @Override
    public float getRideCameraDistanceFront() {
        return 3.0f;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new T4DragonPotionRequirement(this, 1.0));
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        return super.m_6469_(pSource, pAmount);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22279_, (double)0.4f).m_22268_(Attributes.f_22280_, (double)0.2f).m_22268_(Attributes.f_22277_, 32.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), (double)0.8f);
    }

    @Override
    protected boolean isItemStackForTaming(ItemStack stack) {
        return Ingredient.m_204132_(ModTags.Items.FURY_TAME_FOOD).test(stack);
    }

    @Override
    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob parent) {
        NightFury dragon = (NightFury)((EntityType)ModEntities.NIGHT_FURY.get()).m_20615_((Level)level);
        return dragon;
    }

    @Override
    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public boolean isBreedingFood(ItemStack pStack) {
        return Ingredient.m_204132_(ModTags.Items.FURY_BREED_FOOD).test(pStack);
    }

    @Override
    protected int getInLoveCoolDownInMCDays() {
        return 4;
    }

    @Override
    public Vec3 getThroatPos(ADragonBase entity) {
        Vec3 bodyOrigin = this.m_20182_();
        double x = -Math.sin((double)this.f_20883_ * Math.PI / 180.0) * 2.4;
        double y = 1.5;
        double z = Math.cos((double)this.f_20883_ * Math.PI / 180.0) * 2.4;
        Vec3 throatPos = bodyOrigin.m_82549_(new Vec3(x, y, z));
        return throatPos;
    }

    @Override
    protected void playerFireProjectile(Vec3 riderLook, Vec3 throat) {
        if ((this.tier1() || this.tier2() || this.tier3() || this.tier4()) && !this.isUsingAbility()) {
            this.setTicksSinceLastFire(this.ticksSinceLastProjShootSet());
            FuryBolt bolt = new FuryBolt(this, throat, riderLook, this.f_19853_, this.getExplosionStrength());
            bolt.setProjectileSize(this.getProjsSize());
            bolt.shoot(riderLook, 1.0f);
            bolt.setIsLightFuryTexture(false);
            if (this.tier4() || this.tier3()) {
                this.playProjectileSound();
                if (this.f_19853_.m_46471_() && this.m_6688_() instanceof Player) {
                    LightningBolt lightningBolt = new LightningBolt(EntityType.f_20465_, this.f_19853_);
                    lightningBolt.m_6034_(this.m_20185_() - 6.0, this.m_20186_() + 4.0, this.m_20189_() + 6.0);
                    this.f_19853_.m_7967_((Entity)lightningBolt);
                    LightningBolt lightningBolt1 = new LightningBolt(EntityType.f_20465_, this.f_19853_);
                    lightningBolt1.m_6034_(this.m_20185_() - 6.0, this.m_20186_() + 4.0, this.m_20189_() + 6.0);
                    this.f_19853_.m_7967_((Entity)lightningBolt1);
                    LightningBolt lightningBolt2 = new LightningBolt(EntityType.f_20465_, this.f_19853_);
                    lightningBolt2.m_6034_(this.m_20185_() - 6.0, this.m_20186_() + 4.0, this.m_20189_() + 6.0);
                    this.f_19853_.m_7967_((Entity)lightningBolt2);
                }
            }
            if (this.tier1() || this.tier2()) {
                this.m_5496_(SoundEvents.f_12032_, 18.0f, 0.05f);
            }
            this.f_19853_.m_7967_((Entity)bolt);
            this.setPlayerBoltBlastPendingScale(0);
            this.setPlayerBoltBlastPendingStopThreshold(0);
        }
    }

    @Override
    public void dragonShootProjectile(Vec3 dragonLook, Vec3 throat) {
        if ((this.tier1() || this.tier2() || this.tier3() || this.tier4()) && !this.isUsingAbility()) {
            this.setTicksSinceLastFire(this.ticksSinceLastProjShootSet());
            FuryBolt bolt = new FuryBolt(this, throat, dragonLook, this.f_19853_, this.getExplosionStrength());
            bolt.shoot(dragonLook, 1.0f, 5.0);
            bolt.setProjectileSize(this.getProjsSize());
            if (this.tier4() || this.tier3()) {
                this.playProjectileSound();
                if (this.f_19853_.m_46471_()) {
                    LightningBolt lightningBolt = new LightningBolt(EntityType.f_20465_, this.f_19853_);
                    lightningBolt.m_6034_(this.m_20185_() - 6.0, this.m_20186_() + 4.0, this.m_20189_() + 6.0);
                    this.f_19853_.m_7967_((Entity)lightningBolt);
                    LightningBolt lightningBolt1 = new LightningBolt(EntityType.f_20465_, this.f_19853_);
                    lightningBolt1.m_6034_(this.m_20185_() - 6.0, this.m_20186_() + 4.0, this.m_20189_() + 6.0);
                    this.f_19853_.m_7967_((Entity)lightningBolt1);
                    LightningBolt lightningBolt2 = new LightningBolt(EntityType.f_20465_, this.f_19853_);
                    lightningBolt2.m_6034_(this.m_20185_() - 6.0, this.m_20186_() + 4.0, this.m_20189_() + 6.0);
                    this.f_19853_.m_7967_((Entity)lightningBolt2);
                }
            }
            if (this.tier1() || this.tier2()) {
                this.m_5496_(SoundEvents.f_12032_, 18.0f, 0.05f);
            }
            this.f_19853_.m_7967_((Entity)bolt);
            bolt.setIsLightFuryTexture(false);
            this.setPlayerBoltBlastPendingScale(0);
            this.setPlayerBoltBlastPendingStopThreshold(0);
        }
    }

    @Override
    protected int ticksSinceLastProjShootSet() {
        return 12;
    }

    @Override
    protected int getChanceToFire() {
        return 40;
    }

    @Override
    @Nullable
    public ADragonEggBase getBreedEggResult(ServerLevel level, @NotNull AgeableMob parent) {
        NightFuryEgg dragon = (NightFuryEgg)((EntityType)ModEntities.NIGHT_FURY_EGG.get()).m_20615_((Level)level);
        return dragon;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.tier1()) {
            this.setProjsSize(0);
            this.setExplosionStrength(0);
        } else if (this.tier2()) {
            this.setProjsSize(1);
            this.setExplosionStrength(3);
        } else if (this.tier3()) {
            this.setProjsSize(2);
            this.setExplosionStrength(5);
        } else if (this.tier4()) {
            this.setProjsSize(3);
            this.setExplosionStrength(7);
        }
        String s = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        if (s != null && (s.equals("Toothless") || s.equals("toothless") || s.equals("Toothlezz") || s.equals("toothlezz"))) {
            this.setDragonVariant(101);
        }
        this.performInCapacitate();
    }

    @Override
    public float getProjectileDamage(ADragonBase dragon, Entity entity, BaseLinearFlightProjectile projectile) {
        if (projectile.getDamageTier() == 1) {
            float f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = (float)Math.floor(livingEntity.m_21233_() * 0.1f);
            } else {
                f = 0.0f;
            }
            return 16.0f + f;
        }
        if (projectile.getDamageTier() == 2) {
            float f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = (float)Math.floor(livingEntity.m_21233_() * 0.1f);
            } else {
                f = 0.0f;
            }
            return 18.0f + f;
        }
        if (projectile.getDamageTier() == 3) {
            float f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = (float)Math.floor(livingEntity.m_21233_() * 0.12f);
            } else {
                f = 0.0f;
            }
            return 20.0f + f;
        }
        if (projectile.getDamageTier() == 4) {
            float f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = (float)Math.floor(livingEntity.m_21233_() * 0.12f);
            } else {
                f = 0.0f;
            }
            return 25.0f + f;
        }
        return 16.0f;
    }

    @Override
    public int getMaxPlayerBoltBlast() {
        return 70;
    }

    @Override
    protected boolean canCarryCargo() {
        return true;
    }

    @Override
    protected double rider1XOffSet() {
        return 0.0;
    }

    @Override
    protected double rider1YOffSet() {
        return 1.1;
    }

    @Override
    protected double rider1ZOffSet() {
        return 0.0;
    }

    @Override
    protected double extraRidersXOffset() {
        return 0.4;
    }

    @Override
    protected double extraRidersYOffset() {
        return 1.0;
    }

    @Override
    protected double extraRidersZOffset() {
        return 1.0;
    }

    @Override
    public float getRideCameraDistanceVert() {
        return 0.2f;
    }

    @Override
    public boolean tier1() {
        return (double)this.getPlayerBoltBlastPendingScale() >= (double)this.getMaxPlayerBoltBlast() * 0.1 && (double)this.getPlayerBoltBlastPendingScale() < (double)this.getMaxPlayerBoltBlast() * 0.5;
    }

    @Override
    public boolean tier2() {
        return (double)this.getPlayerBoltBlastPendingScale() >= (double)this.getMaxPlayerBoltBlast() * 0.5 && (double)this.getPlayerBoltBlastPendingScale() < (double)this.getMaxPlayerBoltBlast() * 0.65;
    }

    @Override
    public boolean tier3() {
        return (double)this.getPlayerBoltBlastPendingScale() >= (double)this.getMaxPlayerBoltBlast() * 0.65 && this.getPlayerBoltBlastPendingScale() < this.getMaxPlayerBoltBlast();
    }

    @Override
    public boolean tier4() {
        return (double)this.getPlayerBoltBlastPendingScale() >= (double)this.getMaxPlayerBoltBlast() * 0.92;
    }

    @Override
    protected float getAIProjPowerPercentage() {
        return 0.85f;
    }

    protected SoundEvent m_7515_() {
        if (this.isDragonSleeping()) {
            return (SoundEvent)ModSounds.NIGHT_FURY_SLEEP.get();
        }
        return (SoundEvent)ModSounds.NIGHT_FURY_GROWL.get();
    }

    @Override
    protected SoundEvent getTameSound() {
        return (SoundEvent)ModSounds.NIGHT_FURY_TAME.get();
    }

    @Override
    protected SoundEvent getProjectileSound() {
        return (SoundEvent)ModSounds.NIGHT_FURY_FIRE.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.NIGHT_FURY_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.NIGHT_FURY_DEATH.get();
    }

    @Override
    protected SoundEvent get1stAttackSound() {
        return (SoundEvent)ModSounds.NIGHT_FURY_BITE.get();
    }

    @Override
    protected int getMaxPassengerCapacity() {
        return 2;
    }
}

