/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.dragons.montrous_nightmare;

import com.GACMD.isleofberk.entity.AI.taming.T4DragonPotionRequirement;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideable;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideableBreathUser;
import com.GACMD.isleofberk.entity.eggs.entity.base.ADragonEggBase;
import com.GACMD.isleofberk.entity.eggs.entity.eggs.MonstrousNightmareEgg;
import com.GACMD.isleofberk.entity.projectile.abase.BaseLinearFlightProjectile;
import com.GACMD.isleofberk.entity.projectile.breath_user.firebreaths.FireBreathProjectile;
import com.GACMD.isleofberk.registery.ModEntities;
import com.GACMD.isleofberk.registery.ModParticles;
import com.GACMD.isleofberk.registery.ModSounds;
import com.GACMD.isleofberk.registery.ModTags;
import com.GACMD.isleofberk.util.Util;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class MonstrousNightmare
extends ADragonBaseFlyingRideableBreathUser {
    private static final EntityDataAccessor<Boolean> IS_ON_FIRE_ABILITY = SynchedEntityData.m_135353_(MonstrousNightmare.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int ticksUsingSecondAbility;
    private int ticksUsingActiveSecondAbility;

    public MonstrousNightmare(EntityType<? extends ADragonBaseFlyingRideable> entityType, Level level) {
        super(entityType, level);
    }

    private <E extends IAnimatable> PlayState basicMovementController(AnimationEvent<E> event) {
        if (this.isFlying()) {
            if (this.isDragonMoving()) {
                if (this.m_20160_()) {
                    if (this.m_146909_() < 8.0f || this.isGoingUp() || this.m_20197_().size() > 2) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("nightmare.flap", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        this.setShouldPlayFlapping(true);
                    }
                    if (this.m_146909_() >= 8.0f && this.m_146909_() < 33.0f && !this.isGoingUp()) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("nightmare.glide", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        this.setShouldPlayFlapping(false);
                    }
                    if (this.m_146909_() >= 33.0f && !this.isGoingUp()) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("nightmare.dive", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        this.setShouldPlayFlapping(false);
                    }
                    return PlayState.CONTINUE;
                }
                if (this.isDragonFollowing() && this.m_142480_() != null && this.m_142480_().m_21255_()) {
                    LivingEntity owner = this.m_142480_();
                    float dist = this.m_20270_((Entity)owner);
                    double ydist = this.m_20186_() - owner.m_20186_();
                    if (ydist < 10.0 || dist > 15.0f) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("nightmare.flap", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    } else {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("nightmare.dive", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    }
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("nightmare.flap", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    this.setShouldPlayFlapping(true);
                }
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("nightmare.hover", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                this.setShouldPlayFlapping(true);
            }
        } else {
            if (this.isDragonSitting() && !this.isDragonSleeping()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("nightmare.sit", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.isDragonSleeping()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("nightmare.sleep", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.isDragonMoving() && !this.shouldStopMovingIndependently()) {
                if (this.m_5448_() != null && !this.m_5448_().m_21224_() && this.m_20270_((Entity)this.m_5448_()) < 14.0f || this.m_20160_()) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("nightmare.run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("nightmare.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                }
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("nightmare.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState attackController(AnimationEvent<E> event) {
        if (this.getTicksSinceLastAttack() >= 0 && this.getTicksSinceLastAttack() < 12 && this.getCurrentAttackType() == 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("nightmare.bite", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isUsingAbility()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("nightmare.breath", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState turnController(AnimationEvent<E> event) {
        int turnState = this.getRotationState();
        event.getController().setAnimationSpeed(4.0);
        if (turnState != 0) {
            if (this.isFlying()) {
                if (turnState == 1) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("nightmare.tailrotleft1f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else if (turnState == 2) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("nightmare.tailrotleft2f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else if (turnState == -1) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("nightmare.tailrotright1f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else if (turnState == -2) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("nightmare.tailrotright2f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                }
            } else if (turnState == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("nightmare.tailrotleft1", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (turnState == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("nightmare.tailrotleft2", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (turnState == -1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("nightmare.tailrotright1", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (turnState == -2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("nightmare.tailrotright2", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("nightmare.tailrot0", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "basic_MovementController", (float)this.getTransitionTicks(), this::basicMovementController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attack_Controller", 0.0f, this::attackController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "turn_Controller", 35.0f, this::turnController));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ON_FIRE_ABILITY, (Object)false);
    }

    public boolean isOnFireAbility() {
        return (Boolean)this.f_19804_.m_135370_(IS_ON_FIRE_ABILITY);
    }

    public void setOnFireAbility(boolean fire) {
        this.f_19804_.m_135381_(IS_ON_FIRE_ABILITY, (Object)fire);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("is_on_fire_ability", this.isOnFireAbility());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setOnFireAbility(pCompound.m_128471_("is_on_fire_ability"));
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @javax.annotation.Nullable SpawnGroupData pSpawnData, @javax.annotation.Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (this.f_19796_.nextInt(50) == 1) {
            this.setDragonVariant(9);
        } else if (this.f_19796_.nextInt(100) == 1) {
            this.setDragonVariant(10);
        } else if (this.f_19796_.nextInt(200) == 1) {
            this.setDragonVariant(11);
        } else if (this.f_19796_.nextInt(500) == 1) {
            this.setDragonVariant(12);
        } else if (this.f_19796_.nextInt(1000) == 1) {
            this.setDragonVariant(13);
        } else {
            this.setDragonVariant(this.f_19796_.nextInt(this.getMaxAmountOfVariants()));
        }
        return pSpawnData;
    }

    @Override
    public int getMaxAmountOfVariants() {
        return 9;
    }

    @Override
    public float getRideCameraDistanceBack() {
        if (this.isFlying()) {
            return 15.0f;
        }
        return 6.0f;
    }

    @Override
    public float getRideCameraDistanceFront() {
        if (this.isFlying()) {
            return 9.0f;
        }
        return 7.0f;
    }

    @Override
    protected double rider1YOffSet() {
        return super.rider1YOffSet();
    }

    @Override
    public Vec3 getThroatPos(ADragonBase entity) {
        Vec3 bodyOrigin = this.m_20182_();
        double x = -Math.sin((double)this.m_146908_() * Math.PI / 180.0) * 5.0;
        double y = 1.0;
        double z = Math.cos((double)this.m_146908_() * Math.PI / 180.0) * 5.0;
        float scale = this.m_6162_() ? 0.2f : 1.0f;
        Vec3 throatPos = bodyOrigin.m_82549_(new Vec3(x * (double)scale, y * (double)scale, z * (double)scale));
        return throatPos;
    }

    @Override
    public void m_8119_() {
        String s;
        boolean hasDamageResist;
        super.m_8119_();
        boolean bl = hasDamageResist = this.m_21124_(MobEffects.f_19606_) != null;
        if (this.isUsingSECONDAbility()) {
            if (!(hasDamageResist || this.m_20069_() || this.m_20071_())) {
                ++this.ticksUsingSecondAbility;
                this.ticksUsingActiveSecondAbility = 0;
            } else {
                ++this.ticksUsingActiveSecondAbility;
                this.ticksUsingSecondAbility = 0;
            }
        }
        if (this.ticksUsingSecondAbility > 40) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, Util.minutesToSeconds(1), 0, false, false));
        }
        if (this.isOnFireAbility()) {
            Vec3 t = this.getLWingPos(this);
            Vec3 t1 = this.getRWingPos(this);
            double posXL = t.f_82479_ + (this.f_19796_.nextDouble() - this.f_19796_.nextDouble()) * 2.5;
            double posYL = t.f_82480_ + (this.f_19796_.nextDouble() - this.f_19796_.nextDouble()) * 2.5;
            double posZL = t.f_82481_ + (this.f_19796_.nextDouble() - this.f_19796_.nextDouble()) * 2.5;
            double posXR = t1.f_82479_ + (this.f_19796_.nextDouble() - this.f_19796_.nextDouble()) * 2.5;
            double posYR = t1.f_82480_ + (this.f_19796_.nextDouble() - this.f_19796_.nextDouble()) * 2.5;
            double posZR = t1.f_82481_ + (this.f_19796_.nextDouble() - this.f_19796_.nextDouble()) * 2.5;
            ParticleOptions particleOptions = (ParticleOptions)ModParticles.FIRE_COAT.get();
            this.f_19853_.m_6493_(particleOptions, true, posXL, posYL, posZL, 0.3 * (double)(this.f_19796_.nextFloat() - 0.5f), 0.3 * (double)(this.f_19796_.nextFloat() - 0.5f), 0.3 * (double)(this.f_19796_.nextFloat() - 0.5f));
            this.f_19853_.m_6493_(particleOptions, true, posXR, posYR, posZR, 0.3 * (double)(this.f_19796_.nextFloat() - 0.5f), 0.3 * (double)(this.f_19796_.nextFloat() - 0.5f), 0.3 * (double)(this.f_19796_.nextFloat() - 0.5f));
            if (this.f_19797_ % 10 == 0) {
                this.f_19853_.m_45976_(LivingEntity.class, this.m_142469_().m_82400_(4.0)).forEach(livingEntity -> {
                    Player player;
                    if (!(livingEntity.m_21124_(MobEffects.f_19607_) != null || livingEntity instanceof Player && (player = (Player)livingEntity).m_7500_() || this.m_6254_() && this.m_20197_().contains(livingEntity))) {
                        livingEntity.m_20254_(4);
                    }
                });
            }
        }
        if (!this.f_19853_.m_5776_() && hasDamageResist) {
            this.setOnFireAbility(true);
            this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 5, 0, false, false));
        }
        if (!this.f_19853_.m_5776_() && !hasDamageResist) {
            this.setOnFireAbility(false);
        }
        if ((this.m_20069_() || this.m_20071_() || this.ticksUsingActiveSecondAbility > 40) && hasDamageResist) {
            this.m_21195_(MobEffects.f_19606_);
            this.ticksUsingSecondAbility = 0;
        }
        if ((s = ChatFormatting.m_126649_((String)this.m_7755_().getString())) != null && (s.equals("Hookfang") || s.equals("hookfang"))) {
            this.setDragonVariant(0);
        }
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        LivingEntity attacker;
        Entity entity = pSource.m_7640_();
        if (entity instanceof LivingEntity && (attacker = (LivingEntity)entity).m_20270_((Entity)this) < 3.0f && this.m_21213_() < 12 && attacker.m_21213_() < 12) {
            attacker.m_20254_(5);
            attacker.m_6469_(DamageSource.m_19335_((Entity)this), 4.0f);
        }
        if (this.f_19796_.nextInt(24) == 1 && !this.m_20069_() && this.m_6688_() == null) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, Util.minutesToSeconds(2), 0, false, false));
        }
        return super.m_6469_(pSource, pAmount);
    }

    public Vec3 getLWingPos(ADragonBase entity) {
        Vec3 bodyOrigin = this.m_20182_();
        float angle = (float)((double)((float)Math.PI / 180 * this.f_20883_) + 1.6580627893946132);
        float angle1 = (float)((double)((float)Math.PI / 180 * this.f_20883_) + 1.6580627893946132);
        double x = -Math.sin(Math.PI + (double)angle) * 3.0;
        double y = 2.0;
        double z = Math.cos(Math.PI + (double)angle1) * 3.0;
        float scale = this.m_6162_() ? 0.2f : 1.0f;
        Vec3 throatPos = bodyOrigin.m_82549_(new Vec3(x * (double)scale, y * (double)scale, z * (double)scale));
        return throatPos;
    }

    public Vec3 circleVec(Vec3 target, float radius, float speed, boolean direction, int circleFrame, float offset, float moveSpeedMultiplier) {
        int directionInt = direction ? 1 : -1;
        double t = (double)(directionInt * circleFrame) * 0.5 * (double)speed / (double)radius + (double)offset;
        return target.m_82520_((double)radius * Math.cos(t), 0.0, (double)radius * Math.sin(t));
    }

    public Vec3 getRWingPos(ADragonBase entity) {
        Vec3 bodyOrigin = this.m_20182_();
        float angle = (float)((double)((float)Math.PI / 180 * this.f_20883_) - 1.6580627893946132);
        float angle1 = (float)((double)((float)Math.PI / 180 * this.f_20883_) - 1.6580627893946132);
        double x = -Math.sin(Math.PI + (double)angle) * 3.0;
        double y = 2.0;
        double z = Math.cos(Math.PI + (double)angle1) * 3.0;
        float scale = this.m_6162_() ? 0.2f : 1.0f;
        Vec3 throatPos = bodyOrigin.m_82549_(new Vec3(x * (double)scale, y * (double)scale, z * (double)scale));
        return throatPos;
    }

    @Override
    public void m_7332_(Entity pPassenger) {
        super.m_7332_(pPassenger);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 120.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22279_, (double)0.4f).m_22268_(Attributes.f_22280_, (double)0.14f).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), (double)0.6f);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new T4DragonPotionRequirement(this, 1.0));
    }

    @Override
    public void firePrimary(Vec3 riderLook, Vec3 throat) {
        if (this.f_19796_.nextInt(3) == 1) {
            FireBreathProjectile fireProj = new FireBreathProjectile(this, throat, riderLook, this.f_19853_);
            fireProj.setProjectileSize(2);
            fireProj.shoot(riderLook, 1.0f, 4.0);
            this.playProjectileSound();
            this.f_19853_.m_7967_((Entity)fireProj);
        }
    }

    @Override
    public int getExplosionStrength() {
        return 2;
    }

    @Override
    public float getProjectileDamage(ADragonBase dragon, Entity entity, BaseLinearFlightProjectile projectile) {
        return 3.0f;
    }

    @Override
    protected int breathBarRegenSpeed() {
        return 20;
    }

    @Override
    protected int breathBarRegenAmount() {
        return 1;
    }

    @Override
    public int getMaxFuel() {
        return 80;
    }

    @Override
    @Nullable
    public ADragonEggBase getBreedEggResult(ServerLevel level, @NotNull AgeableMob parent) {
        MonstrousNightmareEgg dragon = (MonstrousNightmareEgg)((EntityType)ModEntities.M_NIGHTMARE_EGG.get()).m_20615_((Level)level);
        return dragon;
    }

    @Override
    protected int getInLoveCoolDownInMCDays() {
        return 4;
    }

    protected SoundEvent m_7515_() {
        if (this.isDragonSleeping()) {
            return (SoundEvent)ModSounds.MONSTROUS_NIGHTMARE_SLEEP.get();
        }
        return (SoundEvent)ModSounds.MONSTROUS_NIGHTMARE_GROWL.get();
    }

    @Override
    protected SoundEvent getTameSound() {
        return (SoundEvent)ModSounds.MONSTROUS_NIGHTMARE_TAME.get();
    }

    @Override
    protected SoundEvent getProjectileSound() {
        return (SoundEvent)ModSounds.MONSTROUS_NIGHTMARE_FIRE.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.MONSTROUS_NIGHTMARE_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.MONSTROUS_NIGHTMARE_DEATH.get();
    }

    @Override
    protected SoundEvent get1stAttackSound() {
        return (SoundEvent)ModSounds.MONSTROUS_NIGHTMARE_BITE.get();
    }

    @Override
    protected boolean canCarryCargo() {
        return true;
    }

    @Override
    protected int getMaxPassengerCapacity() {
        return 3;
    }

    @Override
    protected boolean isItemStackForTaming(ItemStack stack) {
        return Ingredient.m_204132_(ModTags.Items.NIGHTMARE_TAME_FOOD).test(stack);
    }

    @Override
    public boolean isBreedingFood(ItemStack pStack) {
        return Ingredient.m_204132_(ModTags.Items.NIGHTMARE_BREED_FOOD).test(pStack);
    }
}

