/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.dragons.gronckle;

import com.GACMD.isleofberk.entity.AI.taming.T2DragonFeedTamingGoal;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideable;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideableProjUser;
import com.GACMD.isleofberk.entity.eggs.entity.base.ADragonEggBase;
import com.GACMD.isleofberk.entity.eggs.entity.eggs.GronkleEgg;
import com.GACMD.isleofberk.entity.projectile.abase.BaseLinearFlightProjectile;
import com.GACMD.isleofberk.registery.ModEntities;
import com.GACMD.isleofberk.registery.ModItems;
import com.GACMD.isleofberk.registery.ModSounds;
import com.GACMD.isleofberk.registery.ModTags;
import com.GACMD.isleofberk.util.Util;
import com.GACMD.isleofberk.util.math.MathX;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddMobPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.entity.PartEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class Gronckle
extends ADragonBaseFlyingRideableProjUser
implements IAnimatable {
    protected int ticksSinceLastRamAttack = 0;
    protected int ticksSinceLastBiteAttack = 0;
    protected int ticksSinceLastRamAttackPlayer = 0;
    protected static final EntityDataAccessor<Integer> TICK_SINCE_LAST_RAM = SynchedEntityData.m_135353_(Gronckle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> TICKS_SINCE_STONE_FED = SynchedEntityData.m_135353_(Gronckle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    ADragonBase.DragonPart[] subParts;
    ADragonBase.DragonPart GronckleRamArea = new ADragonBase.DragonPart(this, "GronckleRamArea", 1.6f, 1.6f);
    private ItemStack pStack;

    public Gronckle(EntityType<? extends ADragonBaseFlyingRideable> entityType, Level level) {
        super(entityType, level);
        this.subParts = new ADragonBase.DragonPart[]{this.GronckleRamArea};
    }

    private <E extends IAnimatable> PlayState basicMovementController(AnimationEvent<E> event) {
        if (this.isFlying()) {
            if (this.isDragonMoving()) {
                if (this.m_20160_()) {
                    if (this.m_146909_() < 8.0f || this.isGoingUp() || this.m_20197_().size() > 2) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.Fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        this.setShouldPlayFlapping(true);
                    }
                    if (this.m_146909_() >= 8.0f && this.m_146909_() < 33.0f && !this.isGoingUp()) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.Glide", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        this.setShouldPlayFlapping(false);
                    }
                    if (this.m_146909_() >= 33.0f && !this.isGoingUp()) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.Dive", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        this.setShouldPlayFlapping(false);
                    }
                    return PlayState.CONTINUE;
                }
                if (this.isDragonFollowing() && this.m_142480_() != null && this.m_142480_().m_21255_()) {
                    LivingEntity owner = this.m_142480_();
                    float dist = this.m_20270_((Entity)owner);
                    double ydist = this.m_20186_() - owner.m_20186_();
                    if (ydist < 10.0 || dist > 15.0f) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.Fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    } else {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.Dive", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    }
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.Fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    this.setShouldPlayFlapping(true);
                }
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.Hover", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                this.setShouldPlayFlapping(true);
            }
        } else {
            if (this.isDragonSitting() && !this.isDragonSleeping()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.Sit", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.isDragonSleeping()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.Sleep", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.isDragonMoving() && !this.shouldStopMovingIndependently()) {
                if (this.m_5448_() != null && !this.m_5448_().m_21224_() && this.m_20270_((Entity)this.m_5448_()) < 14.0f || this.m_20160_()) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.Run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.Walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                }
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.Idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState attackController(AnimationEvent<E> event) {
        if (this.getTicksSinceLastAttack() >= 0 && this.getTicksSinceLastAttack() < 12) {
            if (this.getCurrentAttackType() == 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.Bite", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            if (this.getCurrentAttackType() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.Ram", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
        }
        if (this.ticksSinceLastRamAttackPlayer > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.Ram", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isMarkFired()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.Breath"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState turnController(AnimationEvent<E> event) {
        int turnState = this.getRotationState();
        event.getController().setAnimationSpeed(4.0);
        if (turnState != 0) {
            if (this.isFlying()) {
                if (turnState == 1) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.tailrotleft1f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else if (turnState == 2) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.tailrotleft2f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else if (turnState == -1) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.tailrotright1f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else if (turnState == -2) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.tailrotright2f", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                }
            } else if (turnState == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.tailrotleft1", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (turnState == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.tailrotleft2", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (turnState == -1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.tailrotright1", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (turnState == -2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.tailrotright2", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("Gronckle.TailRot0", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "basic_MovementController", (float)this.getTransitionTicks(), this::basicMovementController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attack_Controller", 0.0f, this::attackController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "turnController", 35.0f, this::turnController));
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("ticks_since_ram_attack", this.getTicksSincePlayerLastRamAttack());
        pCompound.m_128405_("ticks_since_last_stone_fed", this.getStoneDigestionTicks());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setTicksSincePlayerLastRamAttack(pCompound.m_128451_("ticks_since_ram_attack"));
        this.setTicksSincelastStoneFed(pCompound.m_128451_("ticks_since_last_stone_fed"));
    }

    public PartEntity<?>[] getParts() {
        return this.subParts;
    }

    public void m_142223_(@NotNull ClientboundAddMobPacket mobPacket) {
        super.m_142223_(mobPacket);
        PartEntity<?>[] part = this.getParts();
        for (int i = 0; i < Objects.requireNonNull(part).length; ++i) {
            part[i].m_20234_(i + mobPacket.m_131552_());
        }
    }

    @NotNull
    public Packet<?> m_5654_() {
        return new ClientboundAddMobPacket((LivingEntity)this);
    }

    private void tickPart(ADragonBase.DragonPart pPart, double pOffsetX, double pOffsetY, double pOffsetZ) {
        Vec3 lastPos = new Vec3(pPart.m_20185_(), pPart.m_20186_(), pPart.m_20189_());
        pPart.m_6034_(this.m_20185_() + pOffsetX, this.m_20186_() + pOffsetY, this.m_20189_() + pOffsetZ);
        pPart.f_19854_ = lastPos.f_82479_;
        pPart.f_19855_ = lastPos.f_82480_;
        pPart.f_19856_ = lastPos.f_82481_;
        pPart.f_19790_ = lastPos.f_82479_;
        pPart.f_19791_ = lastPos.f_82480_;
        pPart.f_19792_ = lastPos.f_82481_;
    }

    public boolean isMultipartEntity() {
        return !this.m_6162_();
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        float yRotRadians = MathX.toRadians(this.m_146908_());
        float sinY = Mth.m_14031_((float)yRotRadians);
        float cosY = Mth.m_14089_((float)yRotRadians);
        this.tickPart(this.GronckleRamArea, 2.2 * (double)(-sinY) * 1.0, 0.4, 2.2 * (double)cosY * 1.0);
        this.ticksSinceLastRamAttackPlayer = this.isUsingSECONDAbility() && this.getTicksSincePlayerLastRamAttack() == 0 ? 20 : (this.ticksSinceLastRamAttackPlayer > 0 ? --this.ticksSinceLastRamAttackPlayer : 0);
        if (this.ticksSinceLastRamAttackPlayer == 18) {
            this.setTicksSincePlayerLastRamAttack(Util.secondsToTicks(1));
            this.knockBack(this.f_19853_.m_6249_((Entity)this, this.GronckleRamArea.m_142469_().m_82377_(0.4, 0.4, 0.4).m_82386_(0.0, -0.3, 0.0), EntitySelector.f_20406_));
            if (!this.f_19853_.m_5776_()) {
                this.hurt(this.f_19853_.m_6249_((Entity)this, this.GronckleRamArea.m_142469_().m_82400_(1.0), EntitySelector.f_20406_));
            }
        }
    }

    private void knockBack(List<Entity> pEntities) {
        double d0 = (this.GronckleRamArea.m_142469_().f_82288_ + this.GronckleRamArea.m_142469_().f_82291_) / 2.0;
        double d1 = (this.GronckleRamArea.m_142469_().f_82290_ + this.GronckleRamArea.m_142469_().f_82293_) / 2.0;
        for (Entity entity : pEntities) {
            if (!(entity instanceof LivingEntity) || entity == this.m_20197_() || entity.f_19790_ != entity.m_20185_() && entity.f_19792_ != entity.m_20189_()) continue;
            double d2 = entity.m_20185_() - d0;
            double d3 = entity.m_20189_() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.m_5997_(d2 / d4 * 0.5, (double)0.2f, d3 / d4 * 4.0);
            entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 5.0f);
            this.m_19970_((LivingEntity)this, entity);
        }
    }

    private void hurt(List<Entity> pEntities) {
        for (Entity entity : pEntities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.m_20197_().contains(livingEntity)) continue;
            this.m_5496_(SoundEvents.f_11908_, 3.0f, 1.0f);
            livingEntity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 22.0f);
            this.m_19970_((LivingEntity)this, (Entity)livingEntity);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TICK_SINCE_LAST_RAM, (Object)0);
        this.f_19804_.m_135372_(TICKS_SINCE_STONE_FED, (Object)0);
    }

    public int getTicksSincePlayerLastRamAttack() {
        return (Integer)this.f_19804_.m_135370_(TICK_SINCE_LAST_RAM);
    }

    public void setTicksSincePlayerLastRamAttack(int ticksSinceLastRamAttack) {
        this.f_19804_.m_135381_(TICK_SINCE_LAST_RAM, (Object)ticksSinceLastRamAttack);
    }

    public int getStoneDigestionTicks() {
        return (Integer)this.f_19804_.m_135370_(TICKS_SINCE_STONE_FED);
    }

    public void setTicksSincelastStoneFed(int ticksSinceLastRamAttack) {
        this.f_19804_.m_135381_(TICKS_SINCE_STONE_FED, (Object)ticksSinceLastRamAttack);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @javax.annotation.Nullable SpawnGroupData pSpawnData, @javax.annotation.Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        this.setDragonVariant(this.f_19796_.nextInt(this.getMaxAmountOfVariants()));
        return pSpawnData;
    }

    @Override
    public int getMaxAmountOfVariants() {
        return 10;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new T2DragonFeedTamingGoal(this, 1.0));
        this.f_21346_.m_25352_(2, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, PREY_SELECTOR));
    }

    @Override
    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public Vec3 getThroatPos(ADragonBase entity) {
        Vec3 bodyOrigin = this.m_20182_();
        double x = -Math.sin((double)this.f_20883_ * Math.PI / 180.0) * 2.4;
        double y = 1.5;
        double z = Math.cos((double)this.f_20883_ * Math.PI / 180.0) * 2.4;
        Vec3 throatPos = bodyOrigin.m_82549_(new Vec3(x, y, z));
        return throatPos;
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack stack = pPlayer.m_21120_(pHand);
        if (this.isGronckleIngredient(stack)) {
            if (this.getStoneDigestionTicks() <= 0 && this.m_21824_() && (!this.isDragonSleeping() || this.isDragonSitting()) && !stack.m_41619_()) {
                this.setSleepDisturbTicks(Util.secondsToTicks(30));
                stack.m_41774_(1);
                this.setTicksSincelastStoneFed(Util.secondsToTicks(3));
                this.m_5496_(SoundEvents.f_11813_, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public ItemEntity shootGronckIron(ItemStack pStack) {
        if (pStack.m_41619_()) {
            return null;
        }
        if (this.f_19853_.f_46443_) {
            return null;
        }
        ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), pStack);
        itementity.m_32060_();
        double d0 = this.getThroatPos(this).m_7096_() - this.m_20185_();
        double d1 = this.getThroatPos(this).m_7098_() - this.m_20186_();
        double d2 = this.getThroatPos(this).m_7094_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        this.shootItem(itementity, d0, d1 + d3 * (double)0.2f, d2, 0.5f, 11.0f);
        if (this.captureDrops() != null) {
            this.captureDrops().add(itementity);
        } else {
            this.f_19853_.m_7967_((Entity)itementity);
        }
        return itementity;
    }

    public void shootItem(ItemEntity itemEntity, double pX, double pY, double pZ, float pVelocity, float pInaccuracy) {
        Vec3 vec3 = new Vec3(pX, pY, pZ).m_82541_().m_82520_(this.f_19796_.nextGaussian() * (double)0.0075f * (double)pInaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)pInaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)pInaccuracy).m_82490_((double)pVelocity);
        itemEntity.m_20256_(vec3);
        double d0 = vec3.m_165924_();
        itemEntity.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
        itemEntity.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
        itemEntity.f_19859_ = itemEntity.m_146908_();
        itemEntity.f_19860_ = itemEntity.m_146909_();
    }

    @Override
    protected void rideInteract(Player pPlayer, InteractionHand pHand, ItemStack itemstack) {
        Item item = itemstack.m_41720_();
        if (!this.isGronckleIngredient(itemstack)) {
            super.rideInteract(pPlayer, pHand, itemstack);
        }
    }

    @Override
    protected int getAggressionType() {
        return super.getAggressionType();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22280_, (double)0.08f).m_22268_(Attributes.f_22279_, (double)0.37f).m_22268_(Attributes.f_22277_, 32.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 0.25);
    }

    @Override
    public void m_6674_(InteractionHand pHand) {
        int random1 = this.f_19796_.nextInt(200);
        if (random1 > 1) {
            this.ticksSinceLastBiteAttack = Util.secondsToTicks(3);
            this.ticksSinceLastRamAttack = 0;
        }
        if (random1 > 100) {
            this.ticksSinceLastRamAttack = Util.secondsToTicks(3);
            this.ticksSinceLastBiteAttack = 0;
        }
        super.m_6674_(pHand);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        ItemStack itemStack = new ItemStack((ItemLike)ModItems.RAW_GRONCKLE_IRON.get(), 1);
        if (this.getStoneDigestionTicks() == 5) {
            if (this.f_19796_.nextInt(20) == 1) {
                this.m_5496_((SoundEvent)ModSounds.GRONCKLE_SPIT_IRON.get(), 4.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11909_, 4.0f, 1.0f);
                if (!this.f_19853_.m_5776_()) {
                    this.shootGronckIron(itemStack);
                    this.setTicksSinceLastFire(20);
                }
                this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123756_);
                this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123755_);
            } else {
                this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123755_);
                this.m_5496_(SoundEvents.f_12032_, 4.0f, 1.0f);
            }
        }
        if (!this.f_19853_.m_5776_() && this.getStoneDigestionTicks() > 0) {
            this.setTicksSincelastStoneFed(this.getStoneDigestionTicks() - 1);
        }
        if (this.getTicksSinceLastFire() > 0) {
            this.setTicksSinceLastFire(this.getTicksSinceLastFire() - 1);
        }
        if (this.ticksSinceLastBiteAttack >= 0) {
            --this.ticksSinceLastBiteAttack;
        }
        if (this.ticksSinceLastRamAttack >= 0) {
            --this.ticksSinceLastRamAttack;
        }
        if (this.ticksSinceLastRamAttackPlayer > 0) {
            --this.ticksSinceLastRamAttackPlayer;
        }
        if (this.getTicksSinceLastFire() < 2) {
            this.setMarkFired(false);
        } else {
            this.setMarkFired(true);
        }
        if (this.getTicksSincePlayerLastRamAttack() > 0) {
            this.setTicksSincePlayerLastRamAttack(this.getTicksSincePlayerLastRamAttack() - 1);
        }
        if (this.ticksSinceLastRamAttack >= 54) {
            this.setCurrentAttackType(0);
        } else if (this.ticksSinceLastBiteAttack >= 70) {
            this.setCurrentAttackType(1);
        }
        if (this.tier1()) {
            this.setProjsSize(0);
            this.setExplosionStrength(0);
        } else if (this.tier2()) {
            this.setProjsSize(1);
            this.setExplosionStrength(1);
        } else if (this.tier3()) {
            this.setExplosionStrength(3);
            this.setProjsSize(2);
        } else if (this.tier4()) {
            this.setProjsSize(3);
            this.setExplosionStrength(4);
        }
        String s = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        if (s != null && (s.equals("Meatlug") || s.equals("meatlug"))) {
            this.setDragonVariant(0);
        }
    }

    @Override
    public float getSoundPitch() {
        return 1.0f;
    }

    protected float m_6121_() {
        return 0.7f;
    }

    @Override
    protected boolean canCarryCargo() {
        return true;
    }

    @Override
    protected double rider1XOffSet() {
        return 0.0;
    }

    @Override
    protected double rider1YOffSet() {
        return 1.2;
    }

    @Override
    protected double rider1ZOffSet() {
        return 0.0;
    }

    @Override
    protected double extraRidersXOffset() {
        return 0.4;
    }

    @Override
    protected double extraRidersYOffset() {
        return 1.2;
    }

    @Override
    protected double extraRidersZOffset() {
        return 1.0;
    }

    @Override
    @Nullable
    public ADragonEggBase getBreedEggResult(ServerLevel level, @NotNull AgeableMob parent) {
        GronkleEgg dragon = (GronkleEgg)((EntityType)ModEntities.GRONCKLE_EGG.get()).m_20615_((Level)level);
        return dragon;
    }

    @Override
    public float getRideCameraDistanceVert() {
        return 0.2f;
    }

    @Override
    protected int getInLoveCoolDownInMCDays() {
        return 2;
    }

    @Override
    public float getProjectileDamage(ADragonBase dragon, Entity entity, BaseLinearFlightProjectile projectile) {
        if (projectile.getDamageTier() == 1) {
            float f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = (float)Math.floor(livingEntity.m_21233_() * 0.1f);
            } else {
                f = 0.0f;
            }
            return 10.0f + f;
        }
        if (projectile.getDamageTier() == 2) {
            float f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = (float)Math.floor(livingEntity.m_21233_() * 0.1f);
            } else {
                f = 0.0f;
            }
            return 12.0f + f;
        }
        if (projectile.getDamageTier() == 3) {
            float f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = (float)Math.floor(livingEntity.m_21233_() * 0.1f);
            } else {
                f = 0.0f;
            }
            return 14.0f + f;
        }
        if (projectile.getDamageTier() == 4) {
            float f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = (float)Math.floor(livingEntity.m_21233_() * 0.1f);
            } else {
                f = 0.0f;
            }
            return 16.0f + f;
        }
        return 10.0f;
    }

    protected SoundEvent m_7515_() {
        if (this.isDragonSleeping()) {
            return (SoundEvent)ModSounds.GRONCKLE_SLEEP.get();
        }
        return (SoundEvent)ModSounds.GRONCKLE_GROWL.get();
    }

    @Override
    protected SoundEvent getFlapSound() {
        return (SoundEvent)ModSounds.GRONCKLE_FLAP.get();
    }

    @Override
    protected SoundEvent getTameSound() {
        return (SoundEvent)ModSounds.GRONCKLE_TAME.get();
    }

    @Override
    protected float getFlapPitch() {
        return 1.0f;
    }

    @Override
    protected SoundEvent getProjectileSound() {
        return (SoundEvent)ModSounds.GRONCKLE_FIRE.get();
    }

    @Override
    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.GRONCKLE_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.GRONCKLE_DEATH.get();
    }

    @Override
    protected SoundEvent get1stAttackSound() {
        return (SoundEvent)ModSounds.DEADLY_NADDER_BITE.get();
    }

    @Override
    protected int getMaxPassengerCapacity() {
        return 3;
    }

    @Override
    protected boolean isItemStackForTaming(ItemStack stack) {
        return Ingredient.m_204132_(ModTags.Items.GRONCKLE_TAME_FOOD).test(stack);
    }

    @Override
    public boolean isBreedingFood(ItemStack pStack) {
        return Ingredient.m_204132_(ModTags.Items.GRONCKLE_BREED_FOOD).test(pStack);
    }

    protected boolean isGronckleIngredient(ItemStack stack) {
        return Ingredient.m_204132_(ModTags.Items.GRONCKLE_IRON_INGREDIENTS).test(stack);
    }
}

