/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.dragons.deadlynadder;

import com.GACMD.isleofberk.entity.base.render.model.BaseDragonModelFlying;
import com.GACMD.isleofberk.entity.dragons.deadlynadder.DeadlyNadder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class DeadlyNadderModel
extends BaseDragonModelFlying<DeadlyNadder> {
    public DeadlyNadderModel(EntityRendererProvider.Context renderManager) {
    }

    @Override
    public ResourceLocation getModelLocation(DeadlyNadder entity) {
        return new ResourceLocation("isleofberk", "geo/dragons/deadly_nadder.geo.json");
    }

    @Override
    public ResourceLocation getTextureLocation(DeadlyNadder entity) {
        switch (entity.getDragonVariant()) {
            default: {
                return new ResourceLocation("isleofberk", "textures/dragons/deadly_nadder/stormfly.png");
            }
            case 1: {
                return new ResourceLocation("isleofberk", "textures/dragons/deadly_nadder/deadly_nadder.png");
            }
            case 2: {
                return new ResourceLocation("isleofberk", "textures/dragons/deadly_nadder/kingstail.png");
            }
            case 3: {
                return new ResourceLocation("isleofberk", "textures/dragons/deadly_nadder/scardian.png");
            }
            case 4: {
                return new ResourceLocation("isleofberk", "textures/dragons/deadly_nadder/springshedder.png");
            }
            case 5: {
                return new ResourceLocation("isleofberk", "textures/dragons/deadly_nadder/hjarta.png");
            }
            case 6: {
                return new ResourceLocation("isleofberk", "textures/dragons/deadly_nadder/bork_week.png");
            }
            case 7: {
                return new ResourceLocation("isleofberk", "textures/dragons/deadly_nadder/flystorm.png");
            }
            case 8: {
                return new ResourceLocation("isleofberk", "textures/dragons/deadly_nadder/hjaldr.png");
            }
            case 9: {
                return new ResourceLocation("isleofberk", "textures/dragons/deadly_nadder/barklethorn.png");
            }
            case 10: {
                return new ResourceLocation("isleofberk", "textures/dragons/deadly_nadder/lethal_lancebeak.png");
            }
            case 11: 
        }
        return new ResourceLocation("isleofberk", "textures/dragons/deadly_nadder/seedling_stormpest.png");
    }

    @Override
    public ResourceLocation getAnimationFileLocation(DeadlyNadder entity) {
        return new ResourceLocation("isleofberk", "animations/dragons/deadly_nadder.animation.json");
    }

    @Override
    public void setLivingAnimations(DeadlyNadder dragon, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations(dragon, uniqueID, customPredicate);
        IBone tailSpike5 = this.getAnimationProcessor().getBone("Tail5Spikes");
        IBone tailSpike4 = this.getAnimationProcessor().getBone("Tail4Spikes");
        IBone tailSpike3 = this.getAnimationProcessor().getBone("Tail3Spikes");
        IBone tailSpike2 = this.getAnimationProcessor().getBone("Tail2Spikes");
        IBone tailSpike1 = this.getAnimationProcessor().getBone("Tail1Spikes");
        IBone neck1 = this.getAnimationProcessor().getBone("Neck1");
        IBone neck2 = this.getAnimationProcessor().getBone("Neck2");
        IBone head = this.getAnimationProcessor().getBone("head");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (!(dragon.shouldStopMovingIndependently() || Minecraft.m_91087_().m_91104_() || dragon.isRenderedOnGUI())) {
            neck1.setRotationY(neck1.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180) / 3.0f);
            neck2.setRotationY(neck2.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180) / 3.0f);
            head.setRotationY(head.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180) / 3.0f);
            neck1.setRotationX(neck1.getRotationX() + extraData.headPitch * ((float)Math.PI / 180) / 3.0f);
            head.setRotationX(head.getRotationX() + extraData.headPitch * ((float)Math.PI / 180) / 3.0f);
        }
        tailSpike5.setHidden((double)dragon.getRemainingSecondFuel() < (double)dragon.getMaxSecondFuel() * 0.8);
        tailSpike4.setHidden((double)dragon.getRemainingSecondFuel() < (double)dragon.getMaxSecondFuel() * 0.6);
        tailSpike3.setHidden((double)dragon.getRemainingSecondFuel() < (double)dragon.getMaxSecondFuel() * 0.4);
        tailSpike2.setHidden((double)dragon.getRemainingSecondFuel() < (double)dragon.getMaxSecondFuel() * 0.2);
        tailSpike1.setHidden(dragon.getRemainingSecondFuel() == 0);
    }

    @Override
    public String getMainBodyBone() {
        return "rotation";
    }
}

