/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.base.render.layer;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.base.dragon.ADragonBaseFlyingRideable;
import com.GACMD.isleofberk.entity.base.render.render.BaseRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib3.renderers.geo.GeoLayerRenderer;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;

public class LayerDragonRider<T extends ADragonBaseFlyingRideable>
extends GeoLayerRenderer<T> {
    BaseRenderer<T> baseRenderer;

    public LayerDragonRider(IGeoRenderer<T> entityRendererIn) {
        super(entityRendererIn);
        this.baseRenderer = (BaseRenderer)entityRendererIn;
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T dragon, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        matrixStackIn.m_85836_();
        if (!dragon.m_20197_().isEmpty() && ((ADragonBaseFlyingRideable)((Object)dragon)).isFlying()) {
            float dragonScale = dragon.m_6134_();
            for (Entity passenger : dragon.m_20197_()) {
                matrixStackIn.m_85837_(0.0, (double)(-0.01f * dragonScale), (double)(-0.035f * dragonScale));
                float riderRot1 = ((ADragonBase)((Object)dragon)).getChangeInYaw();
                float riderRot = passenger.f_19859_ + (passenger.m_146908_() - passenger.f_19859_) * partialTicks;
                matrixStackIn.m_85845_(new Quaternion(Vector3f.f_122227_, riderRot1, true));
                matrixStackIn.m_85845_(new Quaternion(Vector3f.f_122225_, riderRot + 180.0f, true));
                matrixStackIn.m_85841_(1.0f / dragonScale, 1.0f / dragonScale, 1.0f / dragonScale);
                matrixStackIn.m_85837_(0.0, 2.25, 0.0);
                this.renderEntity(passenger, 0.0, 0.0, 0.0, 0.0f, partialTicks, matrixStackIn, bufferIn, packedLightIn);
            }
        }
        matrixStackIn.m_85849_();
    }

    public <E extends Entity> void renderEntity(E entityIn, double x, double y, double z, float yaw, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int packedLight) {
        EntityRenderer<E> render = LayerDragonRider.getRenderer(entityIn);
        render.m_7392_(entityIn, 0.0f, partialTicks, matrixStack, bufferIn, packedLight);
    }

    public static <T extends Entity> EntityRenderer<T> getRenderer(T entity) {
        EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
        return renderManager.m_114382_(entity);
    }
}

