/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.base.dragon;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.entity.dragons.speedstinger.SpeedStinger;
import com.GACMD.isleofberk.entity.dragons.terrible_terror.TerribleTerror;
import com.GACMD.isleofberk.gui.DragonContainerMenu;
import com.GACMD.isleofberk.util.Util;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class ADragonRideableUtility
extends ADragonBase
implements ContainerListener,
Saddleable,
PlayerRideable {
    private static final EntityDataAccessor<Boolean> DATA_ID_CHEST = SynchedEntityData.m_135353_(ADragonRideableUtility.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_SADDLE = SynchedEntityData.m_135353_(ADragonRideableUtility.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SEAT_LOCK = SynchedEntityData.m_135353_(ADragonRideableUtility.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final String DRAGON_NEEDS_SADDLE = "iob.dragonAir.needSaddle";
    private boolean hasChestVarChanged = false;
    public SimpleContainer dragonContainer;
    protected AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private LazyOptional<?> itemHandler = null;
    int noSaddleRideTicks = 0;

    protected ADragonRideableUtility(EntityType<? extends ADragonBase> animal, Level world) {
        super(animal, world);
        this.m_21530_();
        this.f_19793_ = 2.0f;
        this.createInventory();
    }

    @Override
    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void openGUI(Player playerEntity) {
        if (!this.f_19853_.m_5776_() && (!this.m_20160_() || playerEntity.m_20202_() != this && this.m_21824_()) && playerEntity instanceof ServerPlayer) {
            final Component dragonName = this.m_7755_();
            final int id = this.m_142049_();
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)playerEntity), (MenuProvider)new MenuProvider(){

                @NotNull
                public Component m_5446_() {
                    return dragonName;
                }

                @NotNull
                public AbstractContainerMenu m_7208_(int i, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
                    return new DragonContainerMenu(i, playerInventory, id);
                }
            }, buf -> buf.writeInt(id));
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
    }

    @javax.annotation.Nullable
    public Entity m_6688_() {
        return this.m_146895_();
    }

    public boolean m_5807_() {
        Player player;
        Entity entity = this.m_6688_();
        return entity instanceof Player && this.m_21830_((LivingEntity)(player = (Player)entity));
    }

    protected void foodTamingInteraction(Player pPlayer, InteractionHand pHand, ItemStack itemstack) {
        if (!itemstack.m_41619_()) {
            Item forgeItem = itemstack.m_41720_();
            int nutrition = 6;
            if (!this.m_21824_() && this.canBeMounted()) {
                if (this.isItemStackForTaming(itemstack) && this.m_5448_() == null && this.getFoodTameLimiterBar() < this.getFoodTamingPhaseMaximumLevel()) {
                    this.modifyFoodTamingLimiterBar(nutrition * 3);
                    this.modifyPhase1Progress(this.getDragonProgressSpeed());
                    this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11813_, SoundSource.NEUTRAL, 1.0f, this.getSoundPitch(), true);
                    this.addParticlesAroundSelf((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemstack));
                    if (!pPlayer.m_150110_().f_35937_ && !pPlayer.m_183503_().m_5776_()) {
                        itemstack.m_41774_(1);
                    }
                }
            } else if (this.m_21223_() < this.m_21233_()) {
                this.m_5634_(nutrition);
                if (!pPlayer.m_150110_().f_35937_ && !pPlayer.m_183503_().m_5776_()) {
                    itemstack.m_41774_(1);
                }
            }
            if (!this.m_21824_() && this.isFoodEdibleToDragon(itemstack)) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11813_, SoundSource.NEUTRAL, 1.0f, this.getSoundPitch(), true);
                if (this.m_6162_() && this.isItemStackForTaming(itemstack)) {
                    if (this.f_19796_.nextInt(7) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)pPlayer)) {
                        this.m_21828_(pPlayer);
                        this.f_21344_.m_26573_();
                        this.m_6710_(null);
                        this.f_19853_.m_7605_((Entity)this, (byte)7);
                        if (!pPlayer.m_150110_().f_35937_ && !pPlayer.m_183503_().m_5776_()) {
                            itemstack.m_41774_(1);
                        }
                    } else {
                        this.f_19853_.m_7605_((Entity)this, (byte)6);
                        if (!pPlayer.m_150110_().f_35937_ && !pPlayer.m_183503_().m_5776_()) {
                            itemstack.m_41774_(1);
                        }
                    }
                }
            }
            if (this.isPhaseTwo() && !this.m_21824_()) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, Util.secondsToTicks(120)));
            }
            if (this.isTamingPhaseBarFull() && !this.m_21824_()) {
                this.addSmokeParticles();
            }
        }
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        boolean ownedByPlayer = this.m_21830_((LivingEntity)pPlayer);
        this.setSleepDisturbTicks(Util.secondsToTicks(38));
        if (this.m_6162_() && itemstack.m_41619_()) {
            String owned = "iob.baby.owned";
            String not_owned = "iob.baby.not_owned";
            if (this.m_21830_((LivingEntity)pPlayer)) {
                pPlayer.m_5661_((Component)new TranslatableComponent(owned, new Object[]{this.m_21830_((LivingEntity)pPlayer)}), true);
            } else {
                pPlayer.m_5661_((Component)new TranslatableComponent(not_owned, new Object[]{!this.m_21830_((LivingEntity)pPlayer)}), true);
            }
        }
        if (!this.f_19853_.m_5776_()) {
            if (this.isFoodEdibleToDragon(itemstack) && this.canEatWithFoodOnHand(true)) {
                this.foodTamingInteraction(pPlayer, pHand, itemstack);
                this.m_146859_(GameEvent.f_157771_, this.m_146901_());
                return InteractionResult.SUCCESS;
            }
            if (pPlayer.m_6047_() && ownedByPlayer && !this.guiLocked() && !this.isCommandItems(itemstack)) {
                this.openGUI(pPlayer);
                return InteractionResult.SUCCESS;
            }
            if (this.m_21824_() && this.isCommandItems(itemstack) && this.m_21830_((LivingEntity)pPlayer)) {
                if (pPlayer.m_6144_()) {
                    String seatLockOn = "iob.command.seatLock.on";
                    String seatLockOff = "iob.command.seatLock.off";
                    this.setSeatLocked(!this.isSeatLocked());
                    if (this.isSeatLocked()) {
                        pPlayer.m_5661_((Component)new TranslatableComponent(seatLockOn, new Object[]{this.isSeatLocked()}), true);
                    } else {
                        pPlayer.m_5661_((Component)new TranslatableComponent(seatLockOff, new Object[]{!this.isSeatLocked()}), true);
                    }
                    return InteractionResult.SUCCESS;
                }
                this.modifyCommand(2, pPlayer);
                return InteractionResult.SUCCESS;
            }
        }
        if (this.isCommandItems(itemstack)) {
            int i = this.getPhase1Progress();
            String s = Integer.toString(i);
            if (this.canBeMounted()) {
                pPlayer.m_5661_((Component)new TranslatableComponent("taming.phase1.25").m_130946_(s).m_130946_("%"), true);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (!this.isBreedingFood(itemstack) && !this.isFoodEdibleToDragon(itemstack)) {
            this.rideInteract(pPlayer, pHand, itemstack);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    protected void rideInteract(Player pPlayer, InteractionHand pHand, ItemStack itemstack) {
        if (!this.m_21824_() && this.canBeTameRidden(pPlayer)) {
            this.doPlayerRide(pPlayer);
            if (pPlayer.m_7500_()) {
                this.tameWithName(pPlayer);
            }
        } else if (this.m_21824_()) {
            if (pPlayer == this.m_142480_()) {
                this.doPlayerRide(pPlayer);
            } else if (pPlayer != this.m_142480_() && !this.isSeatLocked() && this.m_6688_() == this.m_142480_()) {
                this.doPlayerRide(pPlayer);
            }
        }
    }

    protected void addSmokeParticles() {
        this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123762_);
    }

    @Override
    public boolean canEatWithFoodOnHand(boolean pIgnoreHunger) {
        if (this.m_21824_()) {
            return true;
        }
        return pIgnoreHunger || !this.isTamingPhaseBarFull();
    }

    protected int getDragonProgressSpeed() {
        return 4;
    }

    protected boolean canBeTameRidden(Player player) {
        return this.isPhaseTwo() && !this.isDragonIncapacitated() || player.m_7500_();
    }

    public boolean canBeMounted() {
        return true;
    }

    protected void doPlayerRide(Player pPlayer) {
        if (this.canBeMounted()) {
            if (!this.f_19853_.f_46443_) {
                if (this.m_21824_()) {
                    pPlayer.m_146922_(this.m_146908_());
                    pPlayer.m_146926_(this.m_146909_());
                }
                if (!this.m_6254_() && !pPlayer.m_7500_() && this.m_21824_()) {
                    pPlayer.m_5661_((Component)new TranslatableComponent(DRAGON_NEEDS_SADDLE), false);
                }
                pPlayer.m_20329_((Entity)this);
            }
            if (this.isDragonSitting()) {
                this.setIsDragonWandering(true);
            }
            if (this.isDragonSleeping()) {
                this.setIsDragonSleeping(false);
            }
            if (this.m_5448_() != null) {
                this.m_6710_(null);
            }
        }
    }

    public void m_20153_() {
        super.m_20153_();
    }

    protected boolean m_7310_(Entity pPassenger) {
        if (this.m_6162_()) {
            return false;
        }
        return this.m_20197_().size() < this.getMaxPassengerCapacity();
    }

    protected int getMaxPassengerCapacity() {
        return 2;
    }

    public void m_142098_(double pX, double pY, double pZ) {
        super.m_142098_(pX, pY, pZ);
    }

    protected void m_21834_(boolean p_30670_) {
        SimpleParticleType particleoptions = p_30670_ ? ParticleTypes.f_123750_ : ParticleTypes.f_123762_;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.nextGaussian() * 0.02;
            double d1 = this.f_19796_.nextGaussian() * 0.02;
            double d2 = this.f_19796_.nextGaussian() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)particleoptions, this.m_20208_(1.0), this.m_20187_() + (double)this.m_20206_() - (double)this.m_20206_() * 0.25, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 7) {
            this.m_21834_(true);
        } else if (pId == 6) {
            this.m_21834_(false);
        } else {
            super.m_7822_(pId);
        }
    }

    public boolean hasChest() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_CHEST);
    }

    public void setChest(boolean chested) {
        this.hasChestVarChanged = true;
        this.f_19804_.m_135381_(DATA_ID_CHEST, (Object)chested);
    }

    public boolean isSeatLocked() {
        return (Boolean)this.f_19804_.m_135370_(SEAT_LOCK);
    }

    public void setSeatLocked(boolean rear_lock) {
        this.f_19804_.m_135381_(SEAT_LOCK, (Object)rear_lock);
    }

    public boolean hasSaddle() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_SADDLE);
    }

    public void setSaddle(boolean saddle) {
        this.f_19804_.m_135381_(DATA_ID_SADDLE, (Object)saddle);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel p_146743_, @NotNull AgeableMob p_146744_) {
        return null;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_CHEST, (Object)false);
        this.f_19804_.m_135372_(SEAT_LOCK, (Object)true);
        this.f_19804_.m_135372_(DATA_ID_SADDLE, (Object)false);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("ChestedDragon", this.hasChest());
        pCompound.m_128379_("seat_lock", this.isSeatLocked());
        pCompound.m_128379_("Saddled", this.hasSaddle());
        if (!this.dragonContainer.m_8020_(0).m_41619_()) {
            pCompound.m_128365_("SaddleItem", (Tag)this.dragonContainer.m_8020_(0).m_41739_(new CompoundTag()));
        }
        if (!this.dragonContainer.m_8020_(1).m_41619_()) {
            pCompound.m_128365_("ChestItem", (Tag)this.dragonContainer.m_8020_(1).m_41739_(new CompoundTag()));
        }
        if (this.hasChest()) {
            ListTag listtag = new ListTag();
            for (int i = 2; i < this.dragonContainer.m_6643_(); ++i) {
                ItemStack itemstack = this.dragonContainer.m_8020_(i);
                if (itemstack.m_41619_()) continue;
                CompoundTag compoundtag = new CompoundTag();
                compoundtag.m_128344_("Slot", (byte)i);
                itemstack.m_41739_(compoundtag);
                listtag.add((Object)compoundtag);
            }
            pCompound.m_128365_("Items", (Tag)listtag);
        }
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        ItemStack itemstack;
        super.m_7378_(pCompound);
        this.setChest(pCompound.m_128471_("ChestedDragon"));
        this.setSeatLocked(pCompound.m_128471_("seat_lock"));
        this.setSaddle(pCompound.m_128471_("Saddled"));
        if (pCompound.m_128425_("SaddleItem", 10) && (itemstack = ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("SaddleItem"))).m_150930_(Items.f_42450_)) {
            this.dragonContainer.m_6836_(0, itemstack);
        }
        if (pCompound.m_128425_("ChestItem", 10) && (itemstack = ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("ChestItem"))).m_150930_(Items.f_42009_)) {
            this.dragonContainer.m_6836_(1, itemstack);
        }
        this.createInventory();
        if (this.hasChest()) {
            ListTag listtag = pCompound.m_128437_("Items", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.m_128728_(i);
                int j = compoundtag.m_128445_("Slot") & 0xFF;
                if (j < 2 || j >= this.dragonContainer.m_6643_()) continue;
                this.dragonContainer.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundtag));
            }
        }
        this.updateContainerEquipment();
    }

    protected void m_5907_() {
        if (this.dragonContainer != null) {
            for (int i = 0; i < this.dragonContainer.m_6643_(); ++i) {
                ItemStack itemstack = this.dragonContainer.m_8020_(i);
                if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
                this.m_19983_(itemstack);
            }
        }
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.dragonContainer;
        this.dragonContainer = new SimpleContainer(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.dragonContainer.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.dragonContainer.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.dragonContainer.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.dragonContainer));
    }

    private SlotAccess createEquipmentSlotAccess(final int p_149503_, final Predicate<ItemStack> p_149504_) {
        return new SlotAccess(){

            @NotNull
            public ItemStack m_142196_() {
                return ADragonRideableUtility.this.dragonContainer.m_8020_(p_149503_);
            }

            public boolean m_142104_(@NotNull ItemStack p_149528_) {
                if (!p_149504_.test(p_149528_)) {
                    return false;
                }
                ADragonRideableUtility.this.dragonContainer.m_6836_(p_149503_, p_149528_);
                ADragonRideableUtility.this.updateContainerEquipment();
                return true;
            }
        };
    }

    @NotNull
    public SlotAccess m_141942_(int pSlot) {
        return pSlot == 499 ? new SlotAccess(){

            @NotNull
            public ItemStack m_142196_() {
                return ADragonRideableUtility.this.hasChest() ? new ItemStack((ItemLike)Items.f_42009_) : ItemStack.f_41583_;
            }

            public boolean m_142104_(@NotNull ItemStack p_149485_) {
                if (p_149485_.m_41619_()) {
                    if (ADragonRideableUtility.this.hasChest()) {
                        ADragonRideableUtility.this.setChest(false);
                        ADragonRideableUtility.this.createInventory();
                    }
                    return true;
                }
                if (p_149485_.m_150930_(Items.f_42009_)) {
                    if (!ADragonRideableUtility.this.hasChest()) {
                        ADragonRideableUtility.this.setChest(true);
                        ADragonRideableUtility.this.createInventory();
                    }
                    return true;
                }
                return false;
            }
        } : this.getBasicSlot(pSlot);
    }

    public SlotAccess getBasicSlot(int pSlot) {
        int j;
        int i = pSlot - 400;
        if (i >= 0 && i < 2 && i < this.dragonContainer.m_6643_()) {
            if (i == 0) {
                return this.createEquipmentSlotAccess(i, pStack -> pStack.m_41619_() || pStack.m_150930_(Items.f_42450_));
            }
            if (i == 1) {
                if (!this.canWearArmor()) {
                    return SlotAccess.f_147290_;
                }
                return this.createEquipmentSlotAccess(i, pStack -> pStack.m_41619_() || pStack.m_150930_(Items.f_42009_));
            }
        }
        return (j = pSlot - 500 + 2) >= 2 && j < this.dragonContainer.m_6643_() ? SlotAccess.m_147292_((Container)this.dragonContainer, (int)j) : super.m_141942_(pSlot);
    }

    protected void updateContainerEquipment() {
        if (!this.f_19853_.f_46443_) {
            this.setSaddle(!this.dragonContainer.m_8020_(0).m_41619_());
            this.setChest(!this.dragonContainer.m_8020_(1).m_41619_());
        }
    }

    public void m_5757_(Container pInvBasic) {
        boolean flag = this.m_6254_();
        this.updateContainerEquipment();
        if (this.f_19797_ > 20 && !flag && this.m_6254_()) {
            this.m_5496_(SoundEvents.f_12034_, 0.5f, 1.0f);
        }
        boolean flag_a = this.hasChest();
        if (this.f_19797_ > 20 && !flag_a && this.hasChest()) {
            this.m_5496_(SoundEvents.f_11811_, 0.5f, 1.0f);
        }
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_() && this.m_21824_();
    }

    public boolean isChestable() {
        return true;
    }

    public void m_5853_(@Nullable SoundSource p_21748_) {
        this.dragonContainer.m_6836_(0, new ItemStack((ItemLike)Items.f_42450_));
    }

    public boolean m_6254_() {
        return this.hasSaddle();
    }

    @Override
    public <T> @NotNull LazyOptional<T> getCapability(Capability<T> capability, @javax.annotation.Nullable Direction facing) {
        if (this.m_6084_() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public boolean hasInventoryChanged(Container container) {
        return this.dragonContainer != container;
    }

    public int getInventoryColumns() {
        return 5;
    }

    protected int getInventorySize() {
        return 17;
    }

    @Override
    public void m_8119_() {
        Object object;
        if (!this.f_19853_.m_5776_()) {
            if (!this.hasSaddle() && this.m_20160_() && this.m_21824_()) {
                ++this.noSaddleRideTicks;
                if (this.noSaddleRideTicks > 350) {
                    Player player;
                    object = this.m_6688_();
                    if (object instanceof Player && !(player = (Player)object).m_7500_()) {
                        this.m_20153_();
                    }
                    this.noSaddleRideTicks = 0;
                }
            }
            if (this.noSaddleRideTicks != 0 && this.m_6688_() == null) {
                this.noSaddleRideTicks = 0;
            }
        }
        if (this.canCarryCargo() && this.m_6688_() != null && this.m_6688_() instanceof Player && !this.isSeatLocked() && this.m_21824_()) {
            this.m_20101_();
            List list = this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.m_20421_((Entity)this));
            if (!list.isEmpty()) {
                boolean flag = !this.f_19853_.f_46443_;
                for (Entity entity : list) {
                    ADragonBase dragonBase;
                    if (entity.m_20363_((Entity)this)) continue;
                    if (flag && this.m_7310_(entity) && !entity.m_20159_() && entity.m_20205_() < this.m_20205_() && !(entity instanceof ADragonBase) && entity instanceof LivingEntity && !(entity instanceof WaterAnimal) && !(entity instanceof Player) && !(entity instanceof Enemy) && !this.isSeatLocked()) {
                        entity.m_20329_((Entity)this);
                    }
                    if (entity instanceof ADragonBase && ((dragonBase = (ADragonBase)entity).m_6162_() || dragonBase instanceof TerribleTerror || dragonBase instanceof SpeedStinger && dragonBase.m_142480_() == this.m_142480_() && dragonBase.m_21824_())) {
                        dragonBase.m_20329_((Entity)this);
                    }
                    if (entity instanceof TamableAnimal) {
                        TamableAnimal tame = (TamableAnimal)entity;
                        if (tame.m_142480_() != this.m_142480_() || !this.m_21824_()) continue;
                        tame.m_20329_((Entity)this);
                        continue;
                    }
                    this.m_7334_(entity);
                }
            }
        }
        if (this.m_20197_().size() > 0) {
            ADragonBase dragonBase;
            object = this.m_20197_().stream().iterator().next();
            if (object instanceof ADragonBase && !(dragonBase = (ADragonBase)((Object)object)).m_6162_()) {
                this.m_20153_();
            }
            if (this.m_6688_() != this.m_142480_() && this.m_21824_()) {
                this.m_20153_();
            }
        }
        if (this.hasChestVarChanged && this.dragonContainer != null && !this.hasChest()) {
            for (int i = 2; i < 17; ++i) {
                if (this.dragonContainer.m_8020_(i).m_41619_()) continue;
                if (!this.f_19853_.f_46443_) {
                    this.m_5552_(this.dragonContainer.m_8020_(i), 1.0f);
                }
                this.dragonContainer.m_8016_(i);
            }
            this.hasChestVarChanged = false;
        }
        super.m_8119_();
    }

    public void m_7332_(@NotNull Entity pPassenger) {
        super.m_7332_(pPassenger);
        if (pPassenger == this.m_20197_().get(0)) {
            pPassenger.m_6034_(this.m_20185_() + this.rider1XOffSet(), this.m_20186_() + this.rider1YOffSet(), this.m_20189_() + this.rider1ZOffSet());
        }
        if (this.m_20197_().size() == 2) {
            if (pPassenger == this.m_20197_().get(1)) {
                Vec3 pos = new Vec3(0.0, this.extraRidersYOffset(), -this.extraRidersZOffset());
                pos = pos.m_82524_((float)Math.toRadians(-this.m_146908_()));
                Vec3 pos1 = pos.m_82520_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                pPassenger.m_6034_(pos1.f_82479_, pos1.f_82480_, pos1.f_82481_);
                this.setAnimalRotations(pPassenger);
            }
        } else if (this.m_20197_().size() == 3) {
            Vec3 pos1;
            Vec3 pos;
            if (pPassenger == this.m_20197_().get(1)) {
                pos = new Vec3(this.extraRidersXOffset(), this.extraRidersYOffset(), -this.extraRidersZOffset());
                pos = pos.m_82524_((float)Math.toRadians(-this.m_146908_()));
                pos1 = pos.m_82520_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                pPassenger.m_6034_(pos1.f_82479_, pos1.f_82480_, pos1.f_82481_);
                this.setAnimalRotations(pPassenger);
            }
            if (pPassenger == this.m_20197_().get(2)) {
                pos = new Vec3(-this.extraRidersXOffset(), this.extraRidersYOffset(), -this.extraRidersZOffset());
                pos = pos.m_82524_((float)Math.toRadians(-this.m_146908_()));
                pos1 = pos.m_82520_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                pPassenger.m_6034_(pos1.f_82479_, pos1.f_82480_, pos1.f_82481_);
                this.setAnimalRotations(pPassenger);
            }
        }
    }

    protected void setAnimalRotations(Entity pPassenger) {
        if (pPassenger instanceof Animal) {
            Animal animal = (Animal)pPassenger;
            this.m_5618_(this.m_6080_());
            animal.m_146922_(this.m_146908_());
            animal.m_5616_(this.m_146908_());
            animal.f_20885_ = animal.f_20883_ = animal.m_146908_();
            pPassenger.m_5618_(((Animal)pPassenger).f_20883_ + 270.0f);
            pPassenger.m_5616_(pPassenger.m_6080_() + 270.0f);
        }
    }

    protected double rider1XOffSet() {
        return 0.0;
    }

    protected double rider1YOffSet() {
        return 2.0;
    }

    protected double rider1ZOffSet() {
        return 0.0;
    }

    protected double extraRidersXOffset() {
        return 0.4;
    }

    protected double extraRidersYOffset() {
        return 2.2;
    }

    protected double extraRidersZOffset() {
        return 1.0;
    }

    public boolean guiLocked() {
        return false;
    }

    protected boolean canCarryCargo() {
        return false;
    }
}

