/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.entity.AI.target;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class DragonMeleeAttackGoal
extends Goal {
    protected final ADragonBase dragon;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private final int attackInterval = 20;
    private long lastCanUseCheck;
    private static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20L;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;

    public DragonMeleeAttackGoal(ADragonBase pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
        this.dragon = pMob;
        this.speedModifier = pSpeedModifier;
        this.followingTargetEvenIfNotSeen = pFollowingTargetEvenIfNotSeen;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long i = this.dragon.f_19853_.m_46467_();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity livingentity = this.dragon.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.ticksUntilNextPathRecalculation <= 0) {
                this.path = this.dragon.m_21573_().m_6570_((Entity)livingentity, 0);
                this.ticksUntilNextPathRecalculation = 4 + this.dragon.m_21187_().nextInt(7);
                return this.path != null;
            }
            return true;
        }
        this.path = this.dragon.m_21573_().m_6570_((Entity)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return !this.dragon.shouldStopMovingIndependently() && this.getAttackReachSqr(livingentity) >= this.dragon.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
    }

    public boolean m_8045_() {
        LivingEntity livingentity = this.dragon.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (livingentity.m_20270_((Entity)this.dragon) > 8.0f) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.dragon.m_21573_().m_26571_();
        }
        if (!this.dragon.m_21444_(livingentity.m_142538_())) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_() && !this.dragon.shouldStopMovingIndependently();
    }

    public void m_8056_() {
        this.dragon.m_21573_().m_26536_(this.path, this.speedModifier);
        this.dragon.m_21561_(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        LivingEntity livingentity = this.dragon.m_5448_();
        if (!EntitySelector.f_20406_.test(livingentity)) {
            this.dragon.m_6710_(null);
        }
        this.dragon.m_21561_(false);
        this.dragon.m_21573_().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingentity = this.dragon.m_5448_();
        if (livingentity != null) {
            this.dragon.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
            double d0 = this.dragon.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.dragon.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.dragon.m_21187_().nextFloat() < 0.05f)) {
                this.pathedTargetX = livingentity.m_20185_();
                this.pathedTargetY = livingentity.m_20186_();
                this.pathedTargetZ = livingentity.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.dragon.m_21187_().nextInt(7);
                if (this.canPenalize) {
                    Node finalPathPoint;
                    this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.dragon.m_21573_().m_26570_() != null ? ((finalPathPoint = this.dragon.m_21573_().m_26570_().m_77395_()) != null && livingentity.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.dragon.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
                this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.checkAndPerformAttack(livingentity, d0);
        }
    }

    protected void checkAndPerformAttack(LivingEntity pEnemy, double pDistToEnemySqr) {
        double d0 = this.getAttackReachSqr(pEnemy);
        if (pDistToEnemySqr <= d0 && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            this.dragon.m_6674_(InteractionHand.MAIN_HAND);
            this.dragon.m_7327_((Entity)pEnemy);
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.m_183277_(20);
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected int getAttackInterval() {
        return this.m_183277_(20);
    }

    protected double getAttackReachSqr(LivingEntity pAttackTarget) {
        return this.dragon.m_20205_() * 2.0f * this.dragon.m_20205_() * 2.0f + pAttackTarget.m_20205_();
    }
}

