/*
 * Decompiled with CFR 0.152.
 */
package com.GACMD.isleofberk.config.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHelper {
    public static <T> T register(ModConfig.Type configType, BiFunction<ForgeConfigSpec.Builder, Subscriber, T> configBuilder, String registerConfig) {
        return ConfigHelper.register(ModLoadingContext.get(), configType, configBuilder, registerConfig);
    }

    public static <T> T register(ModLoadingContext modContext, ModConfig.Type configType, BiFunction<ForgeConfigSpec.Builder, Subscriber, T> configBuilder, String registerConfig) {
        ArrayList subscriptionList = new ArrayList();
        Pair entry = new ForgeConfigSpec.Builder().configure(builder -> configBuilder.apply((ForgeConfigSpec.Builder)builder, ConfigHelper.getSubscriber(subscriptionList)));
        Object config = entry.getLeft();
        ForgeConfigSpec spec = (ForgeConfigSpec)entry.getRight();
        modContext.registerConfig(configType, (IConfigSpec)spec, registerConfig);
        Consumer<ModConfigEvent> configUpdate = event -> {
            if (event.getConfig().getSpec() == spec) {
                for (ConfigValueListener value : subscriptionList) {
                    value.update();
                }
            }
        };
        FMLJavaModLoadingContext.get().getModEventBus().addListener(configUpdate);
        return (T)config;
    }

    private static Subscriber getSubscriber(List<ConfigValueListener<?>> list) {
        return new Subscriber(list);
    }

    public static class Subscriber {
        final List<ConfigValueListener<?>> list;

        Subscriber(List<ConfigValueListener<?>> list) {
            this.list = list;
        }

        public <T> ConfigValueListener<T> subscribe(ForgeConfigSpec.ConfigValue<T> value) {
            return ConfigValueListener.of(value, this.list);
        }
    }

    public static class ConfigValueListener<T>
    implements Supplier<T> {
        private T value = null;
        private final ForgeConfigSpec.ConfigValue<T> configValue;

        private ConfigValueListener(ForgeConfigSpec.ConfigValue<T> configValue) {
            this.configValue = configValue;
        }

        public static <T> ConfigValueListener<T> of(ForgeConfigSpec.ConfigValue<T> configValue, List<ConfigValueListener<?>> valueList) {
            ConfigValueListener<T> value = new ConfigValueListener<T>(configValue);
            valueList.add(value);
            return value;
        }

        public void update() {
            this.value = this.configValue.get();
        }

        @Override
        public T get() {
            if (this.value == null) {
                this.update();
            }
            return this.value;
        }
    }
}

