/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.compat.jei;

import java.util.Collections;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class ChippedRecipeCategory
implements IRecipeCategory<FlattenedRecipe> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("jei", "textures/gui/gui_vanilla.png");
    private final ResourceLocation UID;
    private final String localizedName;
    private final IDrawable background;
    private final IDrawable icon;

    public ChippedRecipeCategory(Item item, IGuiHelper guiHelper) {
        this.UID = Registry.f_122827_.m_7981_((Object)item);
        this.localizedName = I18n.m_118938_((String)("container.chipped." + this.UID.m_135815_()), (Object[])new Object[0]);
        this.background = guiHelper.createDrawable(TEXTURE, 0, 220, 82, 34);
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)item.m_7968_());
    }

    @NotNull
    public ResourceLocation getUid() {
        return this.UID;
    }

    @NotNull
    public Class<? extends FlattenedRecipe> getRecipeClass() {
        return FlattenedRecipe.class;
    }

    public Component getTitle() {
        return new TextComponent(this.localizedName);
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(FlattenedRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(Collections.singletonList(recipe.tag));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.result);
    }

    public void setRecipe(IRecipeLayout recipeLayout, @NotNull FlattenedRecipe recipe, @NotNull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 8);
        guiItemStacks.init(1, false, 60, 8);
        guiItemStacks.set(ingredients);
    }

    public record FlattenedRecipe(Ingredient tag, ItemStack result) {
    }
}

