/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.connectiblechains.entity;

import com.lilypuree.connectiblechains.chain.ChainLink;
import com.lilypuree.connectiblechains.chain.ChainType;
import com.lilypuree.connectiblechains.chain.ChainTypesRegistry;
import com.lilypuree.connectiblechains.client.ClientInitializer;
import com.lilypuree.connectiblechains.entity.ChainLinkEntity;
import com.lilypuree.connectiblechains.entity.ModEntityTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainCollisionEntity
extends Entity
implements IEntityAdditionalSpawnData,
ChainLinkEntity {
    @Nullable
    private ChainLink link;
    private ChainType chainType;

    public ChainCollisionEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ChainCollisionEntity(Level world, double x, double y, double z, @NotNull ChainLink link) {
        this((EntityType)ModEntityTypes.CHAIN_COLLISION.get(), world);
        this.link = link;
        this.m_6034_(x, y, z);
    }

    @Nullable
    public ChainLink getLink() {
        return this.link;
    }

    public ChainType getChainType() {
        return this.chainType;
    }

    public void setChainType(ChainType chainType) {
        this.chainType = chainType;
    }

    protected void m_8097_() {
    }

    public boolean m_6087_() {
        return !this.m_146910_();
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6783_(double pDistance) {
        if (ClientInitializer.checkCollisionEntityWithinRenderDistance(this, pDistance)) {
            return super.m_6783_(pDistance);
        }
        return false;
    }

    protected void m_7378_(CompoundTag pCompound) {
    }

    protected void m_7380_(CompoundTag pCompound) {
    }

    public boolean m_7313_(Entity attacker) {
        if (attacker instanceof Player) {
            Player playerEntity = (Player)attacker;
            return this.m_6469_(DamageSource.m_19344_((Player)playerEntity), 0.0f);
        }
        this.m_5496_(SoundEvents.f_11744_, 0.5f, 1.0f);
        return true;
    }

    public boolean m_6469_(DamageSource source, float pAmount) {
        InteractionResult result = ChainLinkEntity.onDamageFrom(this, source);
        if (result.m_19077_()) {
            this.destroyLinks(result == InteractionResult.SUCCESS);
            return true;
        }
        return false;
    }

    @Override
    public void destroyLinks(boolean mayDrop) {
        if (this.link != null) {
            this.link.destroy(mayDrop);
        }
    }

    public InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        if (ChainLinkEntity.canDestroyWith(pPlayer.m_21120_(pHand))) {
            this.destroyLinks(!pPlayer.m_7500_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        ChainType chainType = this.link == null ? ChainTypesRegistry.DEFAULT_CHAIN_TYPE : this.link.chainType;
        buffer.m_130085_(ChainTypesRegistry.getKey(chainType));
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.setChainType(ChainTypesRegistry.getValue(additionalData.m_130281_()));
    }

    public void m_8119_() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (this.link != null && this.link.needsBeDestroyed()) {
            this.link.destroy(true);
        }
        if (this.link == null || this.link.isDead()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)this.chainType.item());
    }
}

