/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.connectiblechains.client.render.entity;

import com.lilypuree.connectiblechains.ConnectibleChains;
import com.lilypuree.connectiblechains.client.render.entity.ChainModel;
import com.lilypuree.connectiblechains.client.render.entity.UVRect;
import com.lilypuree.connectiblechains.util.Helper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ChainRenderer {
    private static final float CHAIN_SCALE = 1.0f;
    private static final int MAX_SEGMENTS = 2048;
    private final Object2ObjectOpenHashMap<BakeKey, ChainModel> models = new Object2ObjectOpenHashMap(256);

    public void renderBaked(VertexConsumer buffer, PoseStack matrices, BakeKey key, Vector3f chainVec, int blockLight0, int blockLight1, int skyLight0, int skyLight1) {
        ChainModel model;
        if (this.models.containsKey((Object)key)) {
            model = (ChainModel)this.models.get((Object)key);
        } else {
            model = this.buildModel(chainVec);
            this.models.put((Object)key, (Object)model);
            if (!FMLEnvironment.production && this.models.size() > 10000) {
                ConnectibleChains.LOGGER.error("Chain model leak found!!!!!");
            }
        }
        model.render(buffer, matrices, blockLight0, blockLight1, skyLight0, skyLight1);
    }

    private ChainModel buildModel(Vector3f chainVec) {
        float desiredSegmentLength = 1.0f / (float)ConnectibleChains.runtimeConfig.getQuality();
        int initialCapacity = (int)(2.0f * Helper.lengthOf(chainVec) / desiredSegmentLength);
        ChainModel.Builder builder = ChainModel.builder(initialCapacity);
        if (chainVec.m_122239_() == 0.0f && chainVec.m_122269_() == 0.0f) {
            this.buildFaceVertical(builder, chainVec, 45.0f, UVRect.DEFAULT_SIDE_A);
            this.buildFaceVertical(builder, chainVec, -45.0f, UVRect.DEFAULT_SIDE_B);
        } else {
            this.buildFace(builder, chainVec, 45.0f, UVRect.DEFAULT_SIDE_A);
            this.buildFace(builder, chainVec, -45.0f, UVRect.DEFAULT_SIDE_B);
        }
        return builder.build();
    }

    private void buildFaceVertical(ChainModel.Builder builder, Vector3f v, float angle, UVRect uv) {
        float actualSegmentLength = 1.0f / (float)ConnectibleChains.runtimeConfig.getQuality();
        float chainWidth = (uv.x1() - uv.x0()) / 16.0f * 1.0f;
        Vector3f normal = new Vector3f((float)Math.cos(Math.toRadians(angle)), 0.0f, (float)Math.sin(Math.toRadians(angle)));
        normal.m_122261_(chainWidth);
        Vector3f vert00 = new Vector3f(-normal.m_122239_() / 2.0f, 0.0f, -normal.m_122269_() / 2.0f);
        Vector3f vert01 = vert00.m_122281_();
        vert01.m_122253_(normal);
        Vector3f vert10 = new Vector3f(-normal.m_122239_() / 2.0f, 0.0f, -normal.m_122269_() / 2.0f);
        Vector3f vert11 = vert10.m_122281_();
        vert11.m_122253_(normal);
        float uvv0 = 0.0f;
        float uvv1 = 0.0f;
        boolean lastIter_ = false;
        for (int segment = 0; segment < 2048; ++segment) {
            if (vert00.m_122260_() + actualSegmentLength >= v.m_122260_()) {
                lastIter_ = true;
                actualSegmentLength = v.m_122260_() - vert00.m_122260_();
            }
            vert10.m_122272_(0.0f, actualSegmentLength, 0.0f);
            vert11.m_122272_(0.0f, actualSegmentLength, 0.0f);
            builder.vertex(vert00).uv(uv.x0() / 16.0f, uvv0).next();
            builder.vertex(vert01).uv(uv.x1() / 16.0f, uvv0).next();
            builder.vertex(vert11).uv(uv.x1() / 16.0f, uvv1 += actualSegmentLength / 1.0f).next();
            builder.vertex(vert10).uv(uv.x0() / 16.0f, uvv1).next();
            if (lastIter_) break;
            uvv0 = uvv1;
            vert00.m_176768_(vert10);
            vert01.m_176768_(vert11);
        }
    }

    private void buildFace(ChainModel.Builder builder, Vector3f v, float angle, UVRect uv) {
        float desiredSegmentLength = 1.0f / (float)ConnectibleChains.runtimeConfig.getQuality();
        float distance = Helper.lengthOf(v);
        float distanceXZ = (float)Math.sqrt(v.m_122239_() * v.m_122239_() + v.m_122269_() * v.m_122269_());
        float wrongDistanceFactor = distance / distanceXZ;
        Vector3f vert00 = new Vector3f();
        Vector3f vert01 = new Vector3f();
        Vector3f vert11 = new Vector3f();
        Vector3f vert10 = new Vector3f();
        Vector3f normal = new Vector3f();
        Vector3f rotAxis = new Vector3f();
        float chainWidth = (uv.x1() - uv.x0()) / 16.0f * 1.0f;
        float uvv1 = 0.0f;
        Vector3f point0 = new Vector3f();
        Vector3f point1 = new Vector3f();
        point0.m_122245_(0.0f, (float)Helper.drip2(0.0, distance, v.m_122260_()), 0.0f);
        float gradient = (float)Helper.drip2prime(0.0, distance, v.m_122260_());
        normal.m_122245_(-gradient, Math.abs(distanceXZ / distance), 0.0f);
        normal.m_122278_();
        float x = this.estimateDeltaX(desiredSegmentLength, gradient);
        gradient = (float)Helper.drip2prime(x * wrongDistanceFactor, distance, v.m_122260_());
        float y = (float)Helper.drip2(x * wrongDistanceFactor, distance, v.m_122260_());
        point1.m_122245_(x, y, 0.0f);
        rotAxis.m_122245_(point1.m_122239_() - point0.m_122239_(), point1.m_122260_() - point0.m_122260_(), point1.m_122269_() - point0.m_122269_());
        rotAxis.m_122278_();
        Quaternion rotator = rotAxis.m_122240_(angle);
        normal.m_122251_(rotator);
        normal.m_122261_(chainWidth);
        vert10.m_122245_(point0.m_122239_() - normal.m_122239_() / 2.0f, point0.m_122260_() - normal.m_122260_() / 2.0f, point0.m_122269_() - normal.m_122269_() / 2.0f);
        vert11.m_176768_(vert10);
        vert11.m_122253_(normal);
        float actualSegmentLength = Helper.distanceBetween(point0, point1);
        boolean lastIter_ = false;
        for (int segment = 0; segment < 2048; ++segment) {
            rotAxis.m_122245_(point1.m_122239_() - point0.m_122239_(), point1.m_122260_() - point0.m_122260_(), point1.m_122269_() - point0.m_122269_());
            rotAxis.m_122278_();
            rotator = rotAxis.m_122240_(angle);
            normal.m_122245_(-gradient, Math.abs(distanceXZ / distance), 0.0f);
            normal.m_122278_();
            normal.m_122251_(rotator);
            normal.m_122261_(chainWidth);
            vert00.m_176768_(vert10);
            vert01.m_176768_(vert11);
            vert10.m_122245_(point1.m_122239_() - normal.m_122239_() / 2.0f, point1.m_122260_() - normal.m_122260_() / 2.0f, point1.m_122269_() - normal.m_122269_() / 2.0f);
            vert11.m_176768_(vert10);
            vert11.m_122253_(normal);
            float uvv0 = uvv1;
            uvv1 = uvv0 + actualSegmentLength / 1.0f;
            builder.vertex(vert00).uv(uv.x0() / 16.0f, uvv0).next();
            builder.vertex(vert01).uv(uv.x1() / 16.0f, uvv0).next();
            builder.vertex(vert11).uv(uv.x1() / 16.0f, uvv1).next();
            builder.vertex(vert10).uv(uv.x0() / 16.0f, uvv1).next();
            if (lastIter_) break;
            point0.m_176768_(point1);
            x += this.estimateDeltaX(desiredSegmentLength, gradient);
            if (x >= distanceXZ) {
                lastIter_ = true;
                x = distanceXZ;
            }
            gradient = (float)Helper.drip2prime(x * wrongDistanceFactor, distance, v.m_122260_());
            y = (float)Helper.drip2(x * wrongDistanceFactor, distance, v.m_122260_());
            point1.m_122245_(x, y, 0.0f);
            actualSegmentLength = Helper.distanceBetween(point0, point1);
        }
    }

    private float estimateDeltaX(float s, float k) {
        return (float)((double)s / Math.sqrt(1.0f + k * k));
    }

    public void render(VertexConsumer buffer, PoseStack matrices, Vector3f chainVec, int blockLight0, int blockLight1, int skyLight0, int skyLight1) {
        ChainModel model = this.buildModel(chainVec);
        model.render(buffer, matrices, blockLight0, blockLight1, skyLight0, skyLight1);
    }

    public void purge() {
        this.models.clear();
    }

    public static class BakeKey {
        private final int hash;

        public BakeKey(Vec3 srcPos, Vec3 dstPos) {
            float dY = (float)(srcPos.f_82480_ - dstPos.f_82480_);
            float dXZ = Helper.distanceBetween(new Vector3f((float)srcPos.f_82479_, 0.0f, (float)srcPos.f_82481_), new Vector3f((float)dstPos.f_82479_, 0.0f, (float)dstPos.f_82481_));
            int hash = Float.floatToIntBits(dY);
            this.hash = hash = 31 * hash + Float.floatToIntBits(dXZ);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BakeKey bakeKey = (BakeKey)o;
            return this.hash == bakeKey.hash;
        }
    }
}

