/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.connectiblechains.client;

import com.lilypuree.connectiblechains.client.ChainPacketHandler;
import com.lilypuree.connectiblechains.client.render.entity.ChainCollisionEntityRenderer;
import com.lilypuree.connectiblechains.client.render.entity.ChainKnotEntityRenderer;
import com.lilypuree.connectiblechains.client.render.entity.ChainTextureManager;
import com.lilypuree.connectiblechains.client.render.entity.model.ChainKnotEntityModel;
import com.lilypuree.connectiblechains.entity.ChainCollisionEntity;
import com.lilypuree.connectiblechains.entity.ModEntityTypes;
import com.lilypuree.connectiblechains.util.Helper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="connectiblechains", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientInitializer {
    public static final ModelLayerLocation CHAIN_KNOT = new ModelLayerLocation(Helper.identifier("chain_knot"), "main");
    public static final ChainTextureManager textureManager = new ChainTextureManager();
    protected static ChainKnotEntityRenderer chainKnotEntityRenderer;
    public static ChainPacketHandler chainPacketHandler;

    @SubscribeEvent
    public static void onRegisterLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(CHAIN_KNOT, ChainKnotEntityModel::getTexturedModelData);
    }

    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)ModEntityTypes.CHAIN_COLLISION.get(), ChainCollisionEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.CHAIN_KNOT.get(), ctx -> {
            chainKnotEntityRenderer = new ChainKnotEntityRenderer(ctx);
            return chainKnotEntityRenderer;
        });
    }

    @SubscribeEvent
    public static void onClientConfigReload(ModConfigEvent.Reloading event) {
        if (chainKnotEntityRenderer != null) {
            chainKnotEntityRenderer.getChainRenderer().purge();
        }
    }

    @SubscribeEvent
    public static void onRegisterReloadListener(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)textureManager);
    }

    public static boolean checkCollisionEntityWithinRenderDistance(ChainCollisionEntity entity, double distance) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return player != null && player.m_21093_(item -> item.m_204117_(Tags.Items.SHEARS));
    }

    static {
        chainPacketHandler = new ChainPacketHandler();
    }
}

