/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.connectiblechains.client;

import com.lilypuree.connectiblechains.ConnectibleChains;
import com.lilypuree.connectiblechains.chain.ChainLink;
import com.lilypuree.connectiblechains.chain.ChainType;
import com.lilypuree.connectiblechains.chain.ChainTypesRegistry;
import com.lilypuree.connectiblechains.chain.IncompleteChainLink;
import com.lilypuree.connectiblechains.entity.ChainKnotEntity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ChainPacketHandler {
    private final ObjectList<IncompleteChainLink> incompleteLinks = new ObjectArrayList(256);

    public void createLinks(int fromId, int[] toIds, List<ResourceLocation> typeIds) {
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91073_ == null) {
            return;
        }
        Entity from = client.f_91073_.m_6815_(fromId);
        if (from instanceof ChainKnotEntity) {
            ChainKnotEntity knot = (ChainKnotEntity)from;
            for (int i = 0; i < toIds.length; ++i) {
                Entity to = client.f_91073_.m_6815_(toIds[i]);
                ChainType chainType = ChainTypesRegistry.getValue(typeIds.get(i));
                if (to == null) {
                    this.incompleteLinks.add((Object)new IncompleteChainLink(knot, toIds[i], chainType));
                    continue;
                }
                ChainLink.create(knot, to, chainType);
            }
        } else {
            this.logBadActionTarget("attach from", from, fromId, "chain knot");
        }
    }

    public void removeLink(int fromId, int toId) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity from = level.m_6815_(fromId);
        Entity to = level.m_6815_(toId);
        if (from instanceof ChainKnotEntity) {
            ChainKnotEntity knot = (ChainKnotEntity)from;
            if (to == null) {
                for (IncompleteChainLink link : this.incompleteLinks) {
                    if (link.primary != from || link.secondaryId != toId) continue;
                    link.destroy();
                }
            } else {
                for (ChainLink link : knot.getLinks()) {
                    if (link.secondary != to) continue;
                    link.destroy(true);
                }
            }
        } else {
            this.logBadActionTarget("detach from", from, fromId, "chain knot");
        }
    }

    public void changeKnotType(int knotId, ResourceLocation typeId) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(knotId);
        ChainType chainType = ChainTypesRegistry.getValue(typeId);
        if (entity instanceof ChainKnotEntity) {
            ChainKnotEntity knot = (ChainKnotEntity)entity;
            knot.updateChainType(chainType);
        } else {
            this.logBadActionTarget("change type of", entity, knotId, "chain knot");
        }
    }

    private void logBadActionTarget(String action, Entity target, int targetId, String expectedTarget) {
        ConnectibleChains.LOGGER.error(String.format("Tried to %s %s (#%d) which is not %s", action, target, targetId, expectedTarget));
    }

    public void tick() {
        this.incompleteLinks.removeIf(IncompleteChainLink::tryCompleteOrRemove);
    }
}

