/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.connectiblechains.chain;

import com.lilypuree.connectiblechains.ConnectibleChains;
import com.lilypuree.connectiblechains.chain.ChainType;
import com.lilypuree.connectiblechains.util.Helper;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="connectiblechains", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ChainTypesRegistry {
    public static final ResourceLocation DEFAULT_CHAIN_TYPE_ID = Helper.identifier("iron_chain");
    public static ChainType DEFAULT_CHAIN_TYPE;
    public static ChainType IRON_CHAIN;
    public static final Map<Item, ChainType> ITEM_CHAIN_TYPES;
    private static Supplier<IForgeRegistry<ChainType>> REGISTRY;

    public static ResourceLocation getKey(ChainType type) {
        return REGISTRY.get().getKey((IForgeRegistryEntry)type);
    }

    public static ChainType getValue(ResourceLocation id) {
        return (ChainType)REGISTRY.get().getValue(id);
    }

    public static ChainType getValue(String id) {
        return (ChainType)REGISTRY.get().getValue(ResourceLocation.m_135820_((String)id));
    }

    public static Collection<ResourceLocation> getKeys() {
        return REGISTRY.get().getKeys();
    }

    @SubscribeEvent
    public static void onNewRegistry(NewRegistryEvent event) {
        RegistryBuilder registryBuilder = new RegistryBuilder();
        registryBuilder.setName(new ResourceLocation("connectiblechains", "chain_types")).setType(ChainType.class).setDefaultKey(DEFAULT_CHAIN_TYPE_ID);
        REGISTRY = event.create(registryBuilder);
    }

    @SubscribeEvent
    public static void onRegistry(RegistryEvent.Register<ChainType> event) {
        IRON_CHAIN = DEFAULT_CHAIN_TYPE = ChainTypesRegistry.register(DEFAULT_CHAIN_TYPE_ID.m_135815_(), Items.f_42026_);
        event.getRegistry().register((IForgeRegistryEntry)IRON_CHAIN);
    }

    private static ChainType register(String id, Item item) {
        ChainType chainType = (ChainType)new ChainType(item).setRegistryName(Helper.identifier(id));
        ITEM_CHAIN_TYPES.put(item, chainType);
        return chainType;
    }

    public static ChainType register(Item item) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item);
        if (id == ForgeRegistries.ITEMS.getDefaultKey()) {
            ConnectibleChains.LOGGER.error("Cannot create chain type with unregistered item: {}", (Object)item.m_41466_());
            return DEFAULT_CHAIN_TYPE;
        }
        if (REGISTRY.get().containsKey(id)) {
            return (ChainType)REGISTRY.get().getValue(id);
        }
        ChainType chainType = (ChainType)new ChainType(item).setRegistryName(id);
        ITEM_CHAIN_TYPES.put(item, chainType);
        return chainType;
    }

    public static void init() {
    }

    static {
        ITEM_CHAIN_TYPES = new Object2ObjectOpenHashMap(64);
    }
}

