/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.ui.entry;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import xaero.hud.category.ui.GuiCategoryEditor;
import xaero.hud.category.ui.entry.ConnectionLineType;
import xaero.hud.category.ui.entry.EditorListEntry;
import xaero.hud.category.ui.entry.EditorListTextButtonEntry;
import xaero.hud.category.ui.node.EditorNode;
import xaero.lib.client.gui.widget.Tooltip;

public abstract class EditorListRootEntry
extends EditorListEntry {
    private final ConnectionLineType lineType;
    protected final EditorNode node;

    public EditorListRootEntry(int screenWidth, int index, GuiCategoryEditor.SettingRowList rowList, ConnectionLineType lineType, EditorNode node) {
        super(0, 0, screenWidth, 24, index, rowList, () -> null);
        this.lineType = lineType;
        this.node = node;
    }

    protected void addHelpElement(Supplier<Tooltip> helpTooltipSupplier) {
        if (helpTooltipSupplier == null) {
            return;
        }
        this.withSubEntry((int x, int y, int w, int h, EditorListRootEntry root) -> new EditorListTextButtonEntry(x - 24, y + 2, this.index, this.rowList, (Component)new TextComponent("?"), -5592406, -1, 5, () -> false, this, helpTooltipSupplier));
    }

    @Override
    public EditorListEntry render(PoseStack poseStack, int index, int rowWidth, int rowHeight, int relativeMouseX, int relativeMouseY, boolean isMouseOver, float partialTicks, Font font, int globalMouseX, int globalMouseY, boolean includesSelected, boolean isRoot) {
        EditorListEntry result = super.render(poseStack, index, rowWidth, rowHeight, relativeMouseX, relativeMouseY, isMouseOver, partialTicks, font, globalMouseX, globalMouseY, includesSelected, isRoot);
        int xOffset = rowWidth / 2 - 110;
        int yOffset = 8;
        if (this.lineType == ConnectionLineType.TAIL_LEAF || this.lineType == ConnectionLineType.HEAD_LEAF) {
            int leftX = xOffset - 14;
            int rightX = xOffset - 2;
            int bottomY = yOffset + 4;
            int topY = yOffset - 24 + 4;
            this.m_93154_(poseStack, leftX, rightX, bottomY, -5592406);
            this.m_93222_(poseStack, leftX, topY, bottomY, -5592406);
            this.m_93222_(poseStack, rightX - 1, bottomY - 2, bottomY + 2, -5592406);
            this.m_93222_(poseStack, rightX - 2, bottomY - 3, bottomY + 3, -5592406);
            if (this.lineType == ConnectionLineType.HEAD_LEAF) {
                this.m_93154_(poseStack, leftX, rightX, topY, -5592406);
            }
            return result;
        }
        if (this.lineType != ConnectionLineType.PATH) {
            return result;
        }
        int topY = yOffset - 24 + 9;
        int bottomY = yOffset - 2;
        int lineX = xOffset + 12;
        this.m_93154_(poseStack, lineX - 2, lineX + 2, bottomY - 3, -5592406);
        this.m_93154_(poseStack, lineX - 1, lineX + 1, bottomY - 2, -5592406);
        this.m_93222_(poseStack, lineX, topY, bottomY, -5592406);
        return result;
    }

    public EditorListRootEntry withSubEntry(CenteredEntryFactory entryFactory) {
        super.withSubEntry(entryFactory.get(this.rowList.m_5759_() / 2 - 110 - 1, 0, 220, 24, this));
        return this;
    }

    @Override
    protected boolean selectAction() {
        return false;
    }

    @FunctionalInterface
    public static interface CenteredEntryFactory {
        public EditorListEntry get(int var1, int var2, int var3, int var4, EditorListRootEntry var5);
    }
}

