/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.CompositeModelState;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import net.minecraftforge.client.model.geometry.IMultipartModelGeometry;

public class SimpleCompositeModel
implements IDynamicBakedModel {
    private final ImmutableMap<String, BakedModel> bakedParts;
    private final boolean isAmbientOcclusion;
    private final boolean isGui3d;
    private final boolean isSideLit;
    private final TextureAtlasSprite particle;
    private final ItemOverrides overrides;

    public SimpleCompositeModel(boolean isGui3d, boolean isSideLit, boolean isAmbientOcclusion, TextureAtlasSprite particle, ImmutableMap<String, BakedModel> bakedParts, ItemOverrides overrides) {
        this.bakedParts = bakedParts;
        this.isAmbientOcclusion = isAmbientOcclusion;
        this.isGui3d = isGui3d;
        this.isSideLit = isSideLit;
        this.particle = particle;
        this.overrides = overrides;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (Map.Entry entry : this.bakedParts.entrySet()) {
            quads.addAll(((BakedModel)entry.getValue()).getQuads(state, side, rand, extraData));
        }
        return quads;
    }

    public boolean m_7541_() {
        return this.isAmbientOcclusion;
    }

    public boolean m_7539_() {
        return this.isGui3d;
    }

    public boolean m_7547_() {
        return this.isSideLit;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.particle;
    }

    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    public boolean doesHandlePerspectives() {
        return true;
    }

    public static class Loader
    implements IModelLoader<Geometry> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public void m_6213_(ResourceManager resourceManager) {
        }

        public Geometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            if (!modelContents.has("parts")) {
                throw new RuntimeException("Composite model requires a \"parts\" element.");
            }
            ImmutableMap.Builder parts = ImmutableMap.builder();
            for (Map.Entry part : modelContents.get("parts").getAsJsonObject().entrySet()) {
                SimpleModelState modelTransform = SimpleModelState.IDENTITY;
                parts.put((Object)((String)part.getKey()), (Object)new Submodel((String)part.getKey(), (BlockModel)deserializationContext.deserialize((JsonElement)part.getValue(), BlockModel.class), (ModelState)modelTransform));
            }
            return new Geometry((ImmutableMap<String, Submodel>)parts.build());
        }
    }

    public static class Geometry
    implements IMultipartModelGeometry<Geometry> {
        private final ImmutableMap<String, Submodel> children;

        Geometry(ImmutableMap<String, Submodel> children) {
            this.children = children;
        }

        public Collection<Submodel> getParts() {
            return this.children.values();
        }

        public Optional<? extends IModelGeometryPart> getPart(String name) {
            return Optional.ofNullable((Submodel)this.children.get((Object)name));
        }

        public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            Material particleLocation = owner.resolveTexture("particle");
            TextureAtlasSprite particle = spriteGetter.apply(particleLocation);
            ImmutableMap.Builder bakedParts = ImmutableMap.builder();
            for (Map.Entry part : this.children.entrySet()) {
                Submodel submodel = (Submodel)part.getValue();
                if (!owner.getPartVisibility((IModelGeometryPart)submodel)) continue;
                bakedParts.put((Object)((String)part.getKey()), (Object)submodel.bakeModel(bakery, spriteGetter, modelTransform, modelLocation));
            }
            return new SimpleCompositeModel(owner.isShadedInGui(), owner.isSideLit(), owner.useSmoothLighting(), particle, (ImmutableMap<String, BakedModel>)bakedParts.build(), overrides);
        }

        public Map<String, Either<Material, String>> getTextures() {
            HashMap<String, Either<Material, String>> textures = new HashMap<String, Either<Material, String>>();
            this.children.values().forEach(childModel -> {
                IModelGeometry patt6696$temp;
                childModel.model.f_111417_.forEach(textures::putIfAbsent);
                if (childModel.model.customData.hasCustomGeometry() && (patt6696$temp = childModel.model.customData.getCustomGeometry()) instanceof Geometry) {
                    Geometry compositeModel = (Geometry)patt6696$temp;
                    compositeModel.getTextures().forEach(textures::putIfAbsent);
                } else if (childModel.model.f_111418_ != null) {
                    childModel.model.f_111418_.f_111417_.forEach(textures::putIfAbsent);
                }
            });
            return textures;
        }

        public List<BlockElement> getElements() {
            ArrayList<BlockElement> elements = new ArrayList<BlockElement>();
            this.children.forEach((name, subModel) -> {
                IModelGeometry patt7420$temp;
                elements.addAll(subModel.model.m_111436_());
                if (subModel.model.customData.hasCustomGeometry() && (patt7420$temp = subModel.model.customData.getCustomGeometry()) instanceof Geometry) {
                    Geometry compositeModel = (Geometry)patt7420$temp;
                    elements.addAll(compositeModel.getElements());
                }
            });
            return elements;
        }

        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            HashSet<Material> textures = new HashSet<Material>();
            for (Submodel part : this.children.values()) {
                textures.addAll(part.getTextures(owner, modelGetter, missingTextureErrors));
            }
            return textures;
        }
    }

    public static class Submodel
    implements IModelGeometryPart {
        private final String name;
        private final BlockModel model;
        private final ModelState modelTransform;

        private Submodel(String name, BlockModel model, ModelState modelTransform) {
            this.name = name;
            this.model = model;
            this.modelTransform = modelTransform;
        }

        public String name() {
            return this.name;
        }

        public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
            throw new UnsupportedOperationException("Attempted to call adQuads on a Submodel instance. Please don't.");
        }

        public BakedModel bakeModel(ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
            return this.model.m_7611_(bakery, spriteGetter, (ModelState)new CompositeModelState(this.modelTransform, modelTransform, this.modelTransform.m_7538_() || modelTransform.m_7538_()), modelLocation);
        }

        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return this.model.m_5500_(modelGetter, missingTextureErrors);
        }
    }
}

